/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.AccessControlService;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckAccess
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckAccess.class);
    @NonnullAfterInit
    private AccessControlService service;
    @NonnullAfterInit
    private String policyName;
    @Nullable
    private String operation;
    @Nullable
    private String resource;

    public void setAccessControlService(@Nonnull AccessControlService acs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.service = (AccessControlService)Constraint.isNotNull((Object)acs, (String)"AccessControlService cannot be null");
    }

    public void setPolicyName(@Nonnull String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.policyName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Policy name cannot be null or empty");
    }

    public void setOperation(@Nonnull String op) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.operation = StringSupport.trimOrNull((String)op);
    }

    public void setResource(@Nonnull String res) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resource = StringSupport.trimOrNull((String)res);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.service == null || this.policyName == null) {
            throw new ComponentInitializationException("AccessControlService and policy name cannot be null");
        }
    }

    public boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} HttpServletRequest was null, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        return true;
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.service.getInstance(this.policyName).checkAccess((ServletRequest)this.getHttpServletRequest(), this.operation, this.resource)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
        }
    }
}

