/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.hashgrid.HashGrid;
import org.openrndr.extra.noise.PoissonDiskKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeExtensionsKt;
import org.openrndr.shape.ShapeProvider;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aZ\u0010\u0000\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00010\u00020\u0001*\u00020\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001ab\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001*\u00020\u00052\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2 \b\u0002\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00010\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\u0010\u001a\u00020\u0004*\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"multiScatter", "", "Lkotlin/Pair;", "", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/ShapeProvider;", "radii", "distanceToEdge", "tries", "", "random", "Lkotlin/random/Random;", "scatter", "placementRadius", "objectRadius", "obstacles", "uniform", "orx-noise"})
public final class ShapeNoiseKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Vector2 uniform(@NotNull ShapeProvider $this$uniform, double distanceToEdge, @NotNull Random random) {
        Object element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$uniform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Shape shape = $this$uniform.getShape();
        if (!(!shape.getEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int attempts = 0;
        Sequence<Vector2> $this$first$iv = UniformRandomKt.uniformSequence(Vector2.Companion, shape.getBounds(), random);
        boolean $i$f$first = false;
        Iterator iterator = $this$first$iv.iterator();
        do {
            Iterator iterator2;
            if (!iterator.hasNext()) throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            element$iv = iterator.next();
            Vector2 it = (Vector2)element$iv;
            boolean bl2 = false;
            int n = attempts;
            if (!((attempts = n + 1) < 100)) {
                iterator2 = "Failed requirement.";
                throw new IllegalArgumentException(iterator2.toString());
            }
            if (distanceToEdge == 0.0) {
                bl = ShapeExtensionsKt.contains((Shape)shape, (Vector2)it);
                continue;
            }
            if (ShapeExtensionsKt.contains((Shape)shape, (Vector2)it)) {
                iterator2 = ((Iterable)shape.getContours()).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                ShapeContour c = (ShapeContour)iterator2.next();
                boolean bl3 = false;
                double d = c.nearest(it).getPosition().distanceTo(it);
                while (iterator2.hasNext()) {
                    ShapeContour c2 = (ShapeContour)iterator2.next();
                    $i$a$-minOf-ShapeNoiseKt$uniform$1$1 = false;
                    double d2 = c2.nearest(it).getPosition().distanceTo(it);
                    d = Math.min(d, d2);
                }
                if (d > distanceToEdge) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        return (Vector2)element$iv;
    }

    public static /* synthetic */ Vector2 uniform$default(ShapeProvider shapeProvider, double d, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            random = (Random)Random.Default;
        }
        return ShapeNoiseKt.uniform(shapeProvider, d, random);
    }

    @NotNull
    public static final List<Pair<Double, List<Vector2>>> multiScatter(@NotNull ShapeProvider $this$multiScatter, @NotNull List<Pair<Double, Double>> radii, double distanceToEdge, int tries, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)$this$multiScatter, (String)"<this>");
        Intrinsics.checkNotNullParameter(radii, (String)"radii");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        List obstacles = new ArrayList();
        List result = new ArrayList();
        for (Pair<Double, Double> pair : radii) {
            double placementRadius = ((Number)pair.component1()).doubleValue();
            double objectRadius = ((Number)pair.component2()).doubleValue();
            List<Vector2> points = ShapeNoiseKt.scatter($this$multiScatter, placementRadius, objectRadius, distanceToEdge, tries, obstacles, random);
            obstacles.add(new Pair((Object)objectRadius, points));
            result.add(new Pair((Object)objectRadius, points));
        }
        return result;
    }

    public static /* synthetic */ List multiScatter$default(ShapeProvider shapeProvider, List list, double d, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.0;
        }
        if ((n2 & 4) != 0) {
            n = 30;
        }
        if ((n2 & 8) != 0) {
            random = (Random)Random.Default;
        }
        return ShapeNoiseKt.multiScatter(shapeProvider, list, d, n, random);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> scatter(@NotNull ShapeProvider $this$scatter, double placementRadius, double objectRadius, double distanceToEdge, int tries, @NotNull List<? extends Pair<Double, ? extends List<Vector2>>> obstacles, @NotNull Random random) {
        Vector2 $this$mapNotNullTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$scatter, (String)"<this>");
        Intrinsics.checkNotNullParameter(obstacles, (String)"obstacles");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Shape shape = $this$scatter.getShape();
        if (shape.getEmpty()) {
            return CollectionsKt.emptyList();
        }
        Rectangle bounds = shape.getBounds();
        Iterable $this$map$iv = obstacles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator $dstr$obstacleRadius$points;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            double obstacleRadius = ((Number)$dstr$obstacleRadius$points.component1()).doubleValue();
            List points = (List)$dstr$obstacleRadius$points.component2();
            HashGrid hg = new HashGrid(obstacleRadius + objectRadius);
            for (Vector2 point : points) {
                hg.insert(point);
            }
            collection.add(hg);
        }
        List obstacleHashGrids = (List)destination$iv$iv;
        HashGrid initialPointHashGrid = new HashGrid(placementRadius);
        Iterable $this$flatMap$iv = Shape.splitCompounds$default((Shape)shape, null, (int)1, null);
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Shape compound = (Shape)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = compound.getOutline().getSegments();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Vector2 it$iv$iv;
                Object v2;
                block15: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Segment it = (Segment)element$iv$iv2;
                    boolean bl3 = false;
                    Sequence<Vector2> $this$firstOrNull$iv = ShapeNoiseKt.scatter$randomPoints(it, random, distanceToEdge, 20);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl4;
                        Vector2 v;
                        block14: {
                            v = (Vector2)element$iv;
                            boolean bl5 = false;
                            Iterable $this$all$iv = obstacleHashGrids;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (Object element$iv2 : $this$all$iv) {
                                    HashGrid ohg = (HashGrid)element$iv2;
                                    boolean bl6 = false;
                                    if (ohg.isFree(v)) continue;
                                    bl4 = false;
                                    break block14;
                                }
                                bl4 = true;
                            }
                        }
                        boolean bl7 = bl4 && initialPointHashGrid.isFree(v) && ShapeExtensionsKt.contains((Shape)compound, (Vector2)v) && compound.getOutline().nearest(v).getPosition().distanceTo(v) >= distanceToEdge - 0.1;
                        if (!bl7) continue;
                        v2 = element$iv;
                        break block15;
                    }
                    v2 = null;
                }
                Vector2 point = v2;
                if (point != null) {
                    initialPointHashGrid.insert(point);
                }
                if (point == null) continue;
                boolean bl8 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List initialPoints = (List)destination$iv$iv2;
        if (!(!((Collection)initialPoints).isEmpty() || !((Collection)obstacles).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List candidatePoints = new ArrayList();
        for (Vector2 point : initialPoints) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = candidatePoints;
            boolean $i$f$map2 = false;
            Iterable element$iv$iv = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                $this$mapNotNullTo$iv$iv = (Vector2)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl = false;
                collection.add(it.distanceTo(point));
            }
            Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv4));
            double d2 = d == null ? Double.POSITIVE_INFINITY : d;
            if (!(d2 >= placementRadius * 2.0)) continue;
            candidatePoints.add(point);
        }
        if (candidatePoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return PoissonDiskKt.poissonDiskSampling(bounds, placementRadius * 2.0, tries, true, random, candidatePoints, obstacleHashGrids, (Function1<? super Vector2, Boolean>)((Function1)new Function1<Vector2, Boolean>(distanceToEdge, shape){
            final /* synthetic */ double $distanceToEdge;
            final /* synthetic */ Shape $shape;
            {
                this.$distanceToEdge = $distanceToEdge;
                this.$shape = $shape;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Vector2 point) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                if (this.$distanceToEdge == 0.0) {
                    bl = ShapeExtensionsKt.contains((Shape)this.$shape, (Vector2)point);
                    return bl;
                }
                if (ShapeExtensionsKt.contains((Shape)this.$shape, (Vector2)point)) {
                    Iterator<T> iterator = ((Iterable)this.$shape.getContours()).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ShapeContour c = (ShapeContour)iterator.next();
                    boolean bl2 = false;
                    double d = c.nearest(point).getPosition().distanceTo(point);
                    while (iterator.hasNext()) {
                        ShapeContour c2 = (ShapeContour)iterator.next();
                        $i$a$-minOf-ShapeNoiseKt$scatter$2$1 = false;
                        double d2 = c2.nearest(point).getPosition().distanceTo(point);
                        d = Math.min(d, d2);
                    }
                    if (d > this.$distanceToEdge) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    public static /* synthetic */ List scatter$default(ShapeProvider shapeProvider, double d, double d2, double d3, int n, List list, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d2 = d;
        }
        if ((n2 & 4) != 0) {
            d3 = 0.0;
        }
        if ((n2 & 8) != 0) {
            n = 30;
        }
        if ((n2 & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x20) != 0) {
            random = (Random)Random.Default;
        }
        return ShapeNoiseKt.scatter(shapeProvider, d, d2, d3, n, list, random);
    }

    private static final Sequence<Vector2> scatter$randomPoints(Segment $this$scatter_u24randomPoints, Random $random, double $distanceToEdge, int count) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Vector2>, Continuation<? super Unit>, Object>(count, $random, $this$scatter_u24randomPoints, $distanceToEdge, null){
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ int $count;
            final /* synthetic */ Random $random;
            final /* synthetic */ Segment $this_randomPoints;
            final /* synthetic */ double $distanceToEdge;
            {
                this.$count = $count;
                this.$random = $random;
                this.$this_randomPoints = $receiver;
                this.$distanceToEdge = $distanceToEdge;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = 0;
lbl7:
                        // 3 sources

                        while (var3_4 < this.$count) {
                            t = this.$random.nextDouble();
                            this.L$0 = $this$sequence;
                            this.I$0 = ++var3_4;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)this.$this_randomPoints.position(t).minus(Segment.normal$default((Segment)this.$this_randomPoints, (double)t, null, (int)2, null).getNormalized().times(this.$distanceToEdge)), (Continuation)this);
                            if (v0 != var6_2) continue;
                            return var6_2;
                        }
                        break;
                    }
                    case 1: {
                        var3_4 = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Vector2>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Vector2> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

