/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.hashgrid.HashGrid;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0081\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032%\b\u0002\u0010\u0011\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"epsilon", "", "poissonDiskSampling", "", "Lorg/openrndr/math/Vector2;", "bounds", "Lorg/openrndr/shape/Rectangle;", "radius", "tries", "", "randomOnRing", "", "random", "Lkotlin/random/Random;", "initialPoints", "obstacleHashGrids", "Lorg/openrndr/extra/hashgrid/HashGrid;", "boundsMapper", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "v", "orx-noise"})
public final class PoissonDiskKt {
    public static final double epsilon = 1.0E-7;

    @NotNull
    public static final List<Vector2> poissonDiskSampling(@NotNull Rectangle bounds, double radius, int tries, boolean randomOnRing, @NotNull Random random, @NotNull List<Vector2> initialPoints, @NotNull List<HashGrid> obstacleHashGrids, @Nullable Function1<? super Vector2, Boolean> boundsMapper) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter(initialPoints, (String)"initialPoints");
        Intrinsics.checkNotNullParameter(obstacleHashGrids, (String)"obstacleHashGrids");
        List disk = new ArrayList();
        Set queue = new LinkedHashSet();
        HashGrid hashGrid = new HashGrid(radius);
        for (Vector2 initialPoint : initialPoints) {
            PoissonDiskKt.poissonDiskSampling$addPoint(hashGrid, disk, queue, initialPoint, radius);
        }
        for (HashGrid ohg : obstacleHashGrids) {
            for (Vector2 point : ohg.points()) {
                queue.add(new Pair((Object)point, (Object)ohg.getRadius()));
            }
        }
        while (!((Collection)queue).isEmpty()) {
            Pair queueItem = (Pair)CollectionsKt.random((Collection)queue, (Random)random);
            Vector2 active = (Vector2)queueItem.component1();
            double activeRadius = ((Number)queueItem.component2()).doubleValue();
            boolean candidateAccepted = false;
            int n = 0;
            while (n < tries) {
                boolean bl;
                Vector2 c;
                block8: {
                    int l = n++;
                    c = randomOnRing ? active.plus(UniformRandomKt.uniformRing(Vector2.Companion, activeRadius, (double)2 * activeRadius - 1.0E-7, random)) : active.plus(new Polar(random.nextDouble(0.0, 360.0), activeRadius).getCartesian());
                    if (!bounds.contains(c) || !hashGrid.isFree(c)) continue;
                    Iterable $this$any$iv = obstacleHashGrids;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            HashGrid it = (HashGrid)element$iv;
                            boolean bl2 = false;
                            if (!(!it.isFree(c))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl || boundsMapper != null && !((Boolean)boundsMapper.invoke((Object)c)).booleanValue()) continue;
                PoissonDiskKt.poissonDiskSampling$addPoint(hashGrid, disk, queue, c, radius);
                candidateAccepted = true;
                break;
            }
            if (candidateAccepted) continue;
            queue.remove(queueItem);
        }
        return disk;
    }

    public static /* synthetic */ List poissonDiskSampling$default(Rectangle rectangle, double d, int n, boolean bl, Random random, List list, List list2, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 30;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            random = (Random)Random.Default;
        }
        if ((n2 & 0x20) != 0) {
            list = CollectionsKt.listOf((Object)rectangle.getCenter());
        }
        if ((n2 & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x80) != 0) {
            function1 = null;
        }
        return PoissonDiskKt.poissonDiskSampling(rectangle, d, n, bl, random, list, list2, (Function1<? super Vector2, Boolean>)function1);
    }

    private static final void poissonDiskSampling$addPoint(HashGrid hashGrid, List<Vector2> disk, Set<Pair<Vector2, Double>> queue, Vector2 v, double radius) {
        hashGrid.insert(v);
        disk.add(v);
        queue.add((Pair<Vector2, Double>)new Pair((Object)v, (Object)radius));
    }
}

