/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.CellKt;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.GradientPerturbKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u001a<\u0010\u0000\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\n2\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u001a^\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u001a^\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\n2\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a8\u0006\u000f"}, d2={"gradientPerturb", "Lorg/openrndr/math/Vector2;", "seed", "", "amplitude", "", "frequency", "position", "interpolator", "Lkotlin/Function1;", "Lorg/openrndr/math/Vector3;", "gradientPerturbFractal", "lacunarity", "gain", "octaves", "orx-noise"})
public final class GradientPerturbKt {
    @NotNull
    public static final Vector3 gradientPerturbFractal(int seed, double amplitude, double frequency, double lacunarity, double gain, int octaves, @NotNull Vector3 position, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        int seed_ = seed;
        double amplitude_ = amplitude;
        double frequency_ = frequency;
        Vector3 p = GradientPerturbKt.gradientPerturb(seed_, amplitude_, frequency_, position, interpolator);
        int n = 0;
        while (n < octaves) {
            int i = n++;
            int n2 = seed_;
            seed_ = n2 + 1;
            p = GradientPerturbKt.gradientPerturb(seed_, amplitude_ *= gain, frequency_ *= lacunarity, p, interpolator);
        }
        return p;
    }

    public static /* synthetic */ Vector3 gradientPerturbFractal$default(int n, double d, double d2, double d3, double d4, int n2, Vector3 vector3, Function1 function1, int n3, Object object) {
        if ((n3 & 2) != 0) {
            d = 1.0;
        }
        if ((n3 & 4) != 0) {
            d2 = 2.0;
        }
        if ((n3 & 8) != 0) {
            d3 = 2.0;
        }
        if ((n3 & 0x10) != 0) {
            d4 = 0.5;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 4;
        }
        if ((n3 & 0x80) != 0) {
            function1 = gradientPerturbFractal.1.INSTANCE;
        }
        return GradientPerturbKt.gradientPerturbFractal(n, d, d2, d3, d4, n2, vector3, (Function1<? super Double, Double>)function1);
    }

    @NotNull
    public static final Vector3 gradientPerturb(int seed, double amplitude, double frequency, @NotNull Vector3 position, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        double xf = position.getX() * frequency;
        double yf = position.getY() * frequency;
        double zf = position.getZ() * frequency;
        int x0 = MathUtilsKt.fastFloor(xf);
        int y0 = MathUtilsKt.fastFloor(yf);
        int z0 = MathUtilsKt.fastFloor(zf);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        double xs = ((Number)interpolator.invoke((Object)(xf - (double)x0))).doubleValue();
        double ys = ((Number)interpolator.invoke((Object)(yf - (double)y0))).doubleValue();
        double zs = ((Number)interpolator.invoke((Object)(zf - (double)z0))).doubleValue();
        Vector3 vec0 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x0, y0, z0) & 0xFF];
        Vector3 vec1 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x1, y0, z0) & 0xFF];
        double lx0x = MappingKt.mix((double)vec0.getX(), (double)vec1.getX(), (double)xs);
        double ly0x = MappingKt.mix((double)vec0.getY(), (double)vec1.getY(), (double)xs);
        double lz0x = MappingKt.mix((double)vec0.getZ(), (double)vec1.getZ(), (double)xs);
        vec0 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x0, y1, z0) & 0xFF];
        vec1 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x1, y1, z0) & 0xFF];
        double lx1x = MappingKt.mix((double)vec0.getX(), (double)vec1.getX(), (double)xs);
        double ly1x = MappingKt.mix((double)vec0.getY(), (double)vec1.getY(), (double)xs);
        double lz1x = MappingKt.mix((double)vec0.getZ(), (double)vec1.getZ(), (double)xs);
        double lx0y = MappingKt.mix((double)lx0x, (double)lx1x, (double)ys);
        double ly0y = MappingKt.mix((double)ly0x, (double)ly1x, (double)ys);
        double lz0y = MappingKt.mix((double)lz0x, (double)lz1x, (double)ys);
        vec0 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x0, y0, z1) & 0xFF];
        vec1 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x1, y0, z1) & 0xFF];
        lx0x = MappingKt.mix((double)vec0.getX(), (double)vec1.getX(), (double)xs);
        ly0x = MappingKt.mix((double)vec0.getY(), (double)vec1.getY(), (double)xs);
        lz0x = MappingKt.mix((double)vec0.getZ(), (double)vec1.getZ(), (double)xs);
        vec0 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x0, y1, z1) & 0xFF];
        vec1 = CellKt.getCell3D()[GradCoordKt.hash3D(seed, x1, y1, z1) & 0xFF];
        lx1x = MappingKt.mix((double)vec0.getX(), (double)vec1.getX(), (double)xs);
        ly1x = MappingKt.mix((double)vec0.getY(), (double)vec1.getY(), (double)xs);
        lz1x = MappingKt.mix((double)vec0.getZ(), (double)vec1.getZ(), (double)xs);
        return position.plus(new Vector3(MappingKt.mix((double)lx0y, (double)MappingKt.mix((double)lx0x, (double)lx1x, (double)ys), (double)zs), MappingKt.mix((double)ly0y, (double)MappingKt.mix((double)ly0x, (double)ly1x, (double)ys), (double)zs), MappingKt.mix((double)lz0y, (double)MappingKt.mix((double)lz0x, (double)lz1x, (double)ys), (double)zs)).times(amplitude));
    }

    public static /* synthetic */ Vector3 gradientPerturb$default(int n, double d, double d2, Vector3 vector3, Function1 function1, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function1 = gradientPerturb.1.INSTANCE;
        }
        return GradientPerturbKt.gradientPerturb(n, d, d2, vector3, (Function1<? super Double, Double>)function1);
    }

    @NotNull
    public static final Vector2 gradientPerturbFractal(int seed, double amplitude, double frequency, double lacunarity, double gain, int octaves, @NotNull Vector2 position, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        int seed_ = seed;
        double amplitude_ = amplitude;
        double frequency_ = frequency;
        Vector2 p = GradientPerturbKt.gradientPerturb(seed_, amplitude_, frequency_, position, interpolator);
        int n = 0;
        while (n < octaves) {
            int i = n++;
            int n2 = seed_;
            seed_ = n2 + 1;
            p = GradientPerturbKt.gradientPerturb(seed_, amplitude_ *= gain, frequency_ *= lacunarity, p, interpolator);
        }
        return p;
    }

    public static /* synthetic */ Vector2 gradientPerturbFractal$default(int n, double d, double d2, double d3, double d4, int n2, Vector2 vector2, Function1 function1, int n3, Object object) {
        if ((n3 & 2) != 0) {
            d = 1.0;
        }
        if ((n3 & 4) != 0) {
            d2 = 2.0;
        }
        if ((n3 & 8) != 0) {
            d3 = 2.0;
        }
        if ((n3 & 0x10) != 0) {
            d4 = 0.5;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 4;
        }
        if ((n3 & 0x80) != 0) {
            function1 = gradientPerturbFractal.2.INSTANCE;
        }
        return GradientPerturbKt.gradientPerturbFractal(n, d, d2, d3, d4, n2, vector2, (Function1<? super Double, Double>)function1);
    }

    @NotNull
    public static final Vector2 gradientPerturb(int seed, double amplitude, double frequency, @NotNull Vector2 position, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        double xf = position.getX() * frequency;
        double yf = position.getY() * frequency;
        int x0 = MathUtilsKt.fastFloor(xf);
        int y0 = MathUtilsKt.fastFloor(yf);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        double xs = ((Number)interpolator.invoke((Object)(xf - (double)x0))).doubleValue();
        double ys = ((Number)interpolator.invoke((Object)(yf - (double)y0))).doubleValue();
        Vector2 vec0 = CellKt.getCell2D()[GradCoordKt.hash2D(seed, x0, y0) & 0xFF];
        Vector2 vec1 = CellKt.getCell2D()[GradCoordKt.hash2D(seed, x1, y0) & 0xFF];
        double lx0x = MappingKt.mix((double)vec0.getX(), (double)vec1.getX(), (double)xs);
        double ly0x = MappingKt.mix((double)vec0.getY(), (double)vec1.getY(), (double)xs);
        vec0 = CellKt.getCell2D()[GradCoordKt.hash2D(seed, x0, y1) & 0xFF];
        vec1 = CellKt.getCell2D()[GradCoordKt.hash2D(seed, x1, y1) & 0xFF];
        double lx1x = MappingKt.mix((double)vec0.getX(), (double)vec1.getX(), (double)xs);
        double ly1x = MappingKt.mix((double)vec0.getY(), (double)vec1.getY(), (double)xs);
        return position.plus(new Vector2(MappingKt.mix((double)lx0x, (double)lx1x, (double)ys), MappingKt.mix((double)ly0x, (double)ly1x, (double)ys)).times(amplitude));
    }

    public static /* synthetic */ Vector2 gradientPerturb$default(int n, double d, double d2, Vector2 vector2, Function1 function1, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function1 = gradientPerturb.2.INSTANCE;
        }
        return GradientPerturbKt.gradientPerturb(n, d, d2, vector2, (Function1<? super Double, Double>)function1);
    }
}

