/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.CubicNoise2DKt;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a4\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011\u001a\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\")\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\")\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\")\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0017"}, d2={"CUBIC_2D_BOUNDING", "", "cubicHermite2D", "Lkotlin/Function3;", "", "", "getCubicHermite2D", "()Lkotlin/jvm/functions/Function3;", "cubicLinear2D", "getCubicLinear2D", "cubicQuintic2D", "getCubicQuintic2D", "cubic", "seed", "x", "y", "interpolator", "Lkotlin/Function1;", "position", "Lorg/openrndr/math/Vector2;", "cubicHermite", "cubicLinear", "cubicQuintic", "orx-noise"})
public final class CubicNoise2DKt {
    private static final float CUBIC_2D_BOUNDING = 0.44444445f;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> cubicLinear2D = cubicLinear2D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> cubicQuintic2D = cubicQuintic2D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> cubicHermite2D = cubicHermite2D.1.INSTANCE;

    public static final double cubic(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, (Function1<? super Double, Double>)((Function1)cubic.1.INSTANCE));
    }

    public static final double cubicLinear(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, (Function1<? super Double, Double>)((Function1)cubicLinear.1.INSTANCE));
    }

    public static final double cubicQuintic(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, (Function1<? super Double, Double>)((Function1)cubicQuintic.1.INSTANCE));
    }

    public static final double cubicHermite(int seed, double x, double y) {
        return CubicNoise2DKt.cubic(seed, x, y, (Function1<? super Double, Double>)((Function1)cubicHermite.1.INSTANCE));
    }

    public static final double cubic(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise2DKt.cubic(seed, position.getX(), position.getY(), (Function1<? super Double, Double>)((Function1)cubic.2.INSTANCE));
    }

    public static final double cubicLinear(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise2DKt.cubic(seed, position.getX(), position.getY(), (Function1<? super Double, Double>)((Function1)cubicLinear.2.INSTANCE));
    }

    public static final double cubicQuintic(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise2DKt.cubic(seed, position.getX(), position.getY(), (Function1<? super Double, Double>)((Function1)cubicQuintic.2.INSTANCE));
    }

    public static final double cubicHermite(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise2DKt.cubic(seed, position.getX(), position.getY(), (Function1<? super Double, Double>)((Function1)cubicHermite.2.INSTANCE));
    }

    public static final double cubic(int seed, double x, double y, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        int x1 = MathUtilsKt.fastFloor(x);
        int y1 = MathUtilsKt.fastFloor(y);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        double xs = ((Number)interpolator.invoke((Object)(x - (double)x1))).doubleValue();
        double ys = ((Number)interpolator.invoke((Object)(y - (double)y1))).doubleValue();
        return InterpolationKt.cubic(InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y0), GradCoordKt.valCoord2D(seed, x1, y0), GradCoordKt.valCoord2D(seed, x2, y0), GradCoordKt.valCoord2D(seed, x3, y0), xs), InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y1), GradCoordKt.valCoord2D(seed, x1, y1), GradCoordKt.valCoord2D(seed, x2, y1), GradCoordKt.valCoord2D(seed, x3, y1), xs), InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y2), GradCoordKt.valCoord2D(seed, x1, y2), GradCoordKt.valCoord2D(seed, x2, y2), GradCoordKt.valCoord2D(seed, x3, y2), xs), InterpolationKt.cubic(GradCoordKt.valCoord2D(seed, x0, y3), GradCoordKt.valCoord2D(seed, x1, y3), GradCoordKt.valCoord2D(seed, x2, y3), GradCoordKt.valCoord2D(seed, x3, y3), xs), ys) * (double)0.44444445f;
    }

    public static /* synthetic */ double cubic$default(int n, double d, double d2, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function1 = cubic.3.INSTANCE;
        }
        return CubicNoise2DKt.cubic(n, d, d2, (Function1<? super Double, Double>)function1);
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getCubicLinear2D() {
        return cubicLinear2D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getCubicQuintic2D() {
        return cubicQuintic2D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getCubicHermite2D() {
        return cubicHermite2D;
    }
}

