/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.extra.noise.SimplexNoise2DKt;
import org.openrndr.extra.noise.SimplexNoise4DKt;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001a\u0010\u0013\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\")\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\"/\u0010\r\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"/\u0010\u0011\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001a"}, d2={"F2", "", "G2", "SQRT3", "simplex1D", "Lkotlin/Function2;", "", "getSimplex1D", "()Lkotlin/jvm/functions/Function2;", "simplex2D", "Lkotlin/Function3;", "getSimplex2D", "()Lkotlin/jvm/functions/Function3;", "simplex3D", "Lkotlin/Function4;", "getSimplex3D", "()Lkotlin/jvm/functions/Function4;", "simplex4D", "getSimplex4D", "simplex", "seed", "x", "y", "position", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector2$Companion;", "orx-noise"})
public final class SimplexNoise2DKt {
    private static final double SQRT3 = 1.7320508075688772;
    private static final double F2 = 0.3660254037844386;
    private static final double G2 = 0.21132486540518713;
    @NotNull
    private static final Function2<Integer, Double, Double> simplex1D = simplex1D.1.INSTANCE;
    @NotNull
    private static final Function3<Integer, Double, Double, Double> simplex2D = simplex2D.1.INSTANCE;
    @NotNull
    private static final Function4<Integer, Double, Double, Double, Double> simplex3D = simplex3D.1.INSTANCE;
    @NotNull
    private static final Function4<Integer, Double, Double, Double, Double> simplex4D = simplex4D.1.INSTANCE;

    public static final double simplex(int seed, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return SimplexNoise2DKt.simplex(seed, position.getX(), position.getY());
    }

    public static final double simplex(int seed, double x, double y) {
        double t = (x + y) * 0.3660254037844386;
        int i = MathUtilsKt.fastFloor(x + t);
        int j = MathUtilsKt.fastFloor(y + t);
        t = (double)(i + j) * 0.21132486540518713;
        double x0 = x - ((double)i - t);
        double y0 = y - ((double)j - t);
        int i1 = 0;
        int j1 = 0;
        if (x0 > y0) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + 0.21132486540518713;
        double y1 = y0 - (double)j1 + 0.21132486540518713;
        double x2 = x0 - 1.0 + 0.42264973081037427;
        double y2 = y0 - 1.0 + 0.42264973081037427;
        double n0 = 0.0;
        double n1 = 0.0;
        double n2 = 0.0;
        t = 0.5 - x0 * x0 - y0 * y0;
        if (t < 0.0) {
            n0 = 0.0;
        } else {
            t *= t;
            n0 = t * t * GradCoordKt.gradCoord2D(seed, i, j, x0, y0);
        }
        t = 0.5 - x1 * x1 - y1 * y1;
        if (t < 0.0) {
            n1 = 0.0;
        } else {
            t *= t;
            n1 = t * t * GradCoordKt.gradCoord2D(seed, i + i1, j + j1, x1, y1);
        }
        t = 0.5 - x2 * x2 - y2 * y2;
        if (t < 0.0) {
            n2 = 0.0;
        } else {
            t *= t;
            n2 = t * t * GradCoordKt.gradCoord2D(seed, i + 1, j + 1, x2, y2);
        }
        return 50.0 * (n0 + n1 + n2);
    }

    @NotNull
    public static final Function2<Integer, Double, Double> getSimplex1D() {
        return simplex1D;
    }

    @NotNull
    public static final Function3<Integer, Double, Double, Double> getSimplex2D() {
        return simplex2D;
    }

    @NotNull
    public static final Function4<Integer, Double, Double, Double, Double> getSimplex3D() {
        return simplex3D;
    }

    @NotNull
    public static final Function4<Integer, Double, Double, Double, Double> getSimplex4D() {
        return simplex4D;
    }

    @NotNull
    public static final Vector2 simplex(@NotNull Vector2.Companion $this$simplex, int seed, double x) {
        Intrinsics.checkNotNullParameter((Object)$this$simplex, (String)"<this>");
        return new Vector2(SimplexNoise4DKt.simplex(seed, x, 0.0, 0.0, 0.0), SimplexNoise4DKt.simplex(seed, 0.0, x + 31.3383, 0.0, 0.0));
    }
}

