/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.PoissonDiskKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.shape.RectangleKt;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.shape.ShapeExtensionsKt;
import org.openrndr.shape.ShapeProvider;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u00020\u0002*\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"scatter", "", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/shape/ShapeProvider;", "pointDistance", "", "distanceToEdge", "tries", "", "random", "Lkotlin/random/Random;", "uniform", "orx-noise"})
public final class ShapeNoiseKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Vector2 uniform(@NotNull ShapeProvider $this$uniform, double distanceToEdge, @NotNull Random random) {
        Object element$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$uniform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Shape shape = $this$uniform.getShape();
        if (!(!shape.getEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int attempts = 0;
        Sequence<Vector2> $this$first$iv = UniformRandomKt.uniformSequence(Vector2.Companion, shape.getBounds(), random);
        boolean $i$f$first = false;
        Iterator iterator = $this$first$iv.iterator();
        do {
            Iterator iterator2;
            if (!iterator.hasNext()) throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            element$iv = iterator.next();
            Vector2 it = (Vector2)element$iv;
            boolean bl2 = false;
            int n = attempts;
            if (!((attempts = n + 1) < 100)) {
                iterator2 = "Failed requirement.";
                throw new IllegalArgumentException(iterator2.toString());
            }
            if (distanceToEdge == 0.0) {
                bl = ShapeExtensionsKt.contains((Shape)shape, (Vector2)it);
                continue;
            }
            if (ShapeExtensionsKt.contains((Shape)shape, (Vector2)it)) {
                iterator2 = ((Iterable)shape.getContours()).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                ShapeContour c = (ShapeContour)iterator2.next();
                boolean bl3 = false;
                double d = c.nearest(it).getPosition().distanceTo(it);
                while (iterator2.hasNext()) {
                    ShapeContour c2 = (ShapeContour)iterator2.next();
                    $i$a$-minOf-ShapeNoiseKt$uniform$1$1 = false;
                    double d2 = c2.nearest(it).getPosition().distanceTo(it);
                    d = Math.min(d, d2);
                }
                if (d > distanceToEdge) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        return (Vector2)element$iv;
    }

    public static /* synthetic */ Vector2 uniform$default(ShapeProvider shapeProvider, double d, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            random = (Random)Random.Default;
        }
        return ShapeNoiseKt.uniform(shapeProvider, d, random);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Vector2> scatter(@NotNull ShapeProvider $this$scatter, double pointDistance, double distanceToEdge, int tries, @NotNull Random random) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Vector2 $this$mapTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$scatter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Shape shape = $this$scatter.getShape();
        if (shape.getEmpty()) {
            return CollectionsKt.emptyList();
        }
        Rectangle bounds = shape.getBounds();
        Rectangle poissonBounds = new Rectangle(0.0, 0.0, bounds.getWidth(), bounds.getHeight());
        Iterable $this$flatMap$iv = Shape.splitCompounds$default((Shape)shape, null, (int)1, null);
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Vector2 it;
            Collection collection2;
            Shape compound = (Shape)element$iv$iv;
            boolean bl = false;
            Object $this$map$iv2 = compound.getOutline().getSegments();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Segment segment = (Segment)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                double t = random.nextDouble();
                collection2.add(it.position(t).minus(Segment.normal$default((Segment)it, (double)t, null, (int)2, null).getNormalized().times(distanceToEdge)));
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv2 = iterator.next();
                it = (Vector2)element$iv$iv2;
                boolean bl3 = false;
                if (!(ShapeExtensionsKt.contains((Shape)compound, (Vector2)it) && compound.getOutline().nearest(it).getPosition().distanceTo(it) >= distanceToEdge - 0.1)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (Vector2)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add(RectangleKt.map$default((Vector2)it, (Rectangle)bounds, (Rectangle)poissonBounds, (boolean)false, (int)4, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List initialPoints = (List)destination$iv$iv;
        List candidatePoints = new ArrayList();
        for (Vector2 point : initialPoints) {
            void $this$mapTo$iv$iv3;
            Object element$iv$iv;
            Iterable $this$map$iv3 = candidatePoints;
            boolean $i$f$map = false;
            element$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                $this$mapTo$iv$iv2 = (Vector2)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(it.distanceTo(point));
            }
            Double d = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv3));
            double d2 = d == null ? Double.POSITIVE_INFINITY : d;
            if (!(d2 >= pointDistance)) continue;
            candidatePoints.add(point);
        }
        if (candidatePoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $i$f$flatMap22 = PoissonDiskKt.poissonDiskSampling(bounds.getWidth(), bounds.getHeight(), pointDistance, tries, false, random, candidatePoints, (Function3<? super Double, ? super Double, ? super Vector2, Boolean>)((Function3)new Function3<Double, Double, Vector2, Boolean>(poissonBounds, bounds, distanceToEdge, shape){
            final /* synthetic */ Rectangle $poissonBounds;
            final /* synthetic */ Rectangle $bounds;
            final /* synthetic */ double $distanceToEdge;
            final /* synthetic */ Shape $shape;
            {
                this.$poissonBounds = $poissonBounds;
                this.$bounds = $bounds;
                this.$distanceToEdge = $distanceToEdge;
                this.$shape = $shape;
                super(3);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(double $noName_0, double $noName_1, @NotNull Vector2 point) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                Vector2 contourPoint = RectangleKt.map$default((Vector2)point, (Rectangle)this.$poissonBounds, (Rectangle)this.$bounds, (boolean)false, (int)4, null);
                if (this.$distanceToEdge == 0.0) {
                    bl = ShapeExtensionsKt.contains((Shape)this.$shape, (Vector2)contourPoint);
                    return bl;
                }
                if (ShapeExtensionsKt.contains((Shape)this.$shape, (Vector2)contourPoint)) {
                    Iterator<T> iterator = ((Iterable)this.$shape.getContours()).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ShapeContour c = (ShapeContour)iterator.next();
                    boolean bl2 = false;
                    double d = c.nearest(contourPoint).getPosition().distanceTo(contourPoint);
                    while (iterator.hasNext()) {
                        ShapeContour c2 = (ShapeContour)iterator.next();
                        $i$a$-minOf-ShapeNoiseKt$scatter$2$1 = false;
                        double d2 = c2.nearest(contourPoint).getPosition().distanceTo(contourPoint);
                        d = Math.min(d, d2);
                    }
                    if (d > this.$distanceToEdge) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Vector2 $i$f$mapTo2 = (Vector2)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(RectangleKt.map$default((Vector2)it, (Rectangle)poissonBounds, (Rectangle)bounds, (boolean)false, (int)4, null));
        }
        return (List)destination$iv$iv4;
    }

    public static /* synthetic */ List scatter$default(ShapeProvider shapeProvider, double d, double d2, int n, Random random, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d2 = 0.0;
        }
        if ((n2 & 4) != 0) {
            n = 30;
        }
        if ((n2 & 8) != 0) {
            random = (Random)Random.Default;
        }
        return ShapeNoiseKt.scatter(shapeProvider, d, d2, n, random);
    }
}

