/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.RandomKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.CubicNoise2DKt;
import org.openrndr.extra.noise.CubicNoise3DKt;
import org.openrndr.extra.noise.GaussianRandomKt;
import org.openrndr.extra.noise.PerlinNoise2DKt;
import org.openrndr.extra.noise.PerlinNoise3DKt;
import org.openrndr.extra.noise.RandomState;
import org.openrndr.extra.noise.SimplexNoise2DKt;
import org.openrndr.extra.noise.SimplexNoise3DKt;
import org.openrndr.extra.noise.SimplexNoise4DKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.extra.noise.ValueNoise2DKt;
import org.openrndr.extra.noise.ValueNoise3DKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.shape.Rectangle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002abB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u001e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020 J\u001a\u0010!\u001a\u00020\u00062\b\b\u0002\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006J\u0010\u0010$\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006J^\u0010%\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\u00062\b\b\u0002\u0010,\u001a\u00020\u0006Jl\u0010%\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062$\u0010&\u001a \u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060-2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\u00062\b\b\u0002\u0010,\u001a\u00020\u0006JV\u0010%\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\u00062\b\b\u0002\u0010,\u001a\u00020\u0006J\\\u0010%\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020 2$\u0010&\u001a \u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060-2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\u00062\b\b\u0002\u0010,\u001a\u00020\u0006J\u001a\u0010.\u001a\u00020\u00062\b\b\u0002\u0010/\u001a\u00020\u00062\b\b\u0002\u00100\u001a\u00020\u0006J\u001a\u00101\u001a\u00020\u00152\b\b\u0002\u0010\"\u001a\u00020\u00152\b\b\u0002\u0010#\u001a\u00020\u0015J\u0010\u00102\u001a\u00020\u00152\b\b\u0002\u0010#\u001a\u00020\u0015J\u001f\u00103\u001a\u0002042\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020406\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\u000eH\u0002J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00060;2\b\b\u0002\u0010<\u001a\u00020\u0006J(\u0010=\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010(\u001a\u00020>J \u0010=\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010(\u001a\u00020>J\u0018\u0010=\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010(\u001a\u00020>J\u0018\u0010=\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020 2\b\b\u0002\u0010(\u001a\u00020>J\u001f\u0010?\u001a\u0002H@\"\u0004\b\u0000\u0010@2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H@0B\u00a2\u0006\u0002\u0010CJ-\u0010?\u001a\u0002H@\"\u0004\b\u0000\u0010@2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H@0B2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H@0B\u00a2\u0006\u0002\u0010EJ8\u0010?\u001a\b\u0012\u0004\u0012\u0002H@0F\"\u0004\b\u0000\u0010@2\f\u0010A\u001a\b\u0012\u0004\u0012\u0002H@0B2\u000e\b\u0002\u0010D\u001a\b\u0012\u0004\u0012\u0002H@0B2\u0006\u0010G\u001a\u00020\u0015J\u000e\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u000204J\u0006\u0010L\u001a\u000204J\u0006\u0010M\u001a\u000204J\u0006\u0010N\u001a\u000204J$\u0010O\u001a\u00020\u00012\b\b\u0002\u0010P\u001a\u00020\u00062\b\b\u0002\u0010Q\u001a\u00020\u00062\b\b\u0002\u0010G\u001a\u00020\u0015J$\u0010R\u001a\u00020\u00012\b\b\u0002\u0010P\u001a\u00020\u00062\b\b\u0002\u0010Q\u001a\u00020\u00062\b\b\u0002\u0010G\u001a\u00020\u0015J9\u0010S\u001a\u0002H@\"\u0004\b\u0000\u0010@2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002H@0B2\u0018\u0010U\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060V06\u00a2\u0006\u0002\u0010WJ\u0016\u0010X\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006J\u001e\u0010X\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006J&\u0010X\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\u0006J\u000e\u0010X\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010X\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020 J\u000e\u0010X\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020ZJ\u0010\u0010[\u001a\u00020\u00152\u0006\u0010\\\u001a\u00020\u000eH\u0002J\u0014\u0010]\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u0002040;J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010(\u001a\u00020>J \u0010\r\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010(\u001a\u00020>J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010(\u001a\u00020>J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020 2\b\b\u0002\u0010(\u001a\u00020>J\u001a\u0010^\u001a\u00020\u001f2\b\b\u0002\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006J\u001a\u0010_\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006J\u001a\u0010`\u001a\u00020Z2\b\b\u0002\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/openrndr/extra/noise/Random;", "", "()V", "hasNextGaussian", "", "nextGaussian", "", "rnd", "Lkotlin/random/Random;", "getRnd", "()Lkotlin/random/Random;", "setRnd", "(Lkotlin/random/Random;)V", "value", "", "seed", "getSeed", "()Ljava/lang/String;", "setSeed", "(Ljava/lang/String;)V", "seedTracking", "", "state", "Lorg/openrndr/extra/noise/RandomState;", "bool", "probability", "cubic", "x", "y", "z", "position", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "double", "min", "max", "double0", "fbm", "noiseFun", "Lkotlin/Function3;", "type", "Lorg/openrndr/extra/noise/Random$Fractal;", "octaves", "lacunarity", "gain", "Lkotlin/Function4;", "gaussian", "mean", "standardDeviation", "int", "int0", "isolated", "", "fn", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "newRandomGenerator", "newSeed", "pareto", "Lkotlin/Function0;", "alpha", "perlin", "Lorg/openrndr/extra/noise/Random$Noise;", "pick", "T", "coll", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "compareAgainst", "(Ljava/util/Collection;Ljava/util/Collection;)Ljava/lang/Object;", "", "count", "point", "rect", "Lorg/openrndr/shape/Rectangle;", "pop", "push", "randomizeSeed", "resetState", "ring2d", "innerRadius", "outerRadius", "ring3d", "roll", "elements", "distribution", "", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "simplex", "w", "Lorg/openrndr/math/Vector4;", "stringToInt", "str", "unseeded", "vector2", "vector3", "vector4", "Fractal", "Noise", "orx-noise"})
public final class Random {
    @NotNull
    public static final Random INSTANCE = new Random();
    @NotNull
    private static kotlin.random.Random rnd;
    private static int seedTracking;
    private static double nextGaussian;
    private static boolean hasNextGaussian;
    @NotNull
    private static RandomState state;
    @NotNull
    private static String seed;

    private Random() {
    }

    @NotNull
    public final kotlin.random.Random getRnd() {
        return rnd;
    }

    public final void setRnd(@NotNull kotlin.random.Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"<set-?>");
        rnd = random;
    }

    @NotNull
    public final String getSeed() {
        return seed;
    }

    public final void setSeed(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        seed = value2;
        rnd = this.newRandomGenerator(value2);
    }

    private final kotlin.random.Random newRandomGenerator(String newSeed) {
        return RandomKt.Random((int)this.stringToInt(newSeed));
    }

    /*
     * WARNING - void declaration
     */
    private final int stringToInt(String str) {
        void $this$fold$iv;
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void c;
            void var10_11 = element$iv;
            int i = accumulator$iv;
            boolean bl = false;
            accumulator$iv = i + c;
        }
        return accumulator$iv;
    }

    public final void resetState() {
        rnd = this.newRandomGenerator(seed);
    }

    public final void randomizeSeed() {
        CharSequence charSequence = seed;
        Regex regex = new Regex("-\\d+");
        String string = "";
        String seedBase = regex.replace(charSequence, string);
        seedTracking = this.int0(999999);
        this.setSeed(seedBase + '-' + seedTracking);
    }

    public final void unseeded(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.push();
        fn.invoke();
        this.pop();
    }

    public final void push() {
        state = new RandomState(seed, rnd);
        rnd = (kotlin.random.Random)kotlin.random.Random.Default;
    }

    public final void pop() {
        this.resetState();
        this.setSeed(state.getSeed());
        rnd = state.getRng();
    }

    public final void isolated(@NotNull Function1<? super Random, Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        kotlin.random.Random state = rnd;
        String currentSeed = seed;
        this.resetState();
        fn.invoke((Object)this);
        this.setSeed(currentSeed);
        rnd = state;
    }

    public final double double(double min, double max) {
        return UniformRandomKt.uniform(DoubleCompanionObject.INSTANCE, min, max, rnd);
    }

    public static /* synthetic */ double double$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.double(d, d2);
    }

    public final double double0(double max) {
        return rnd.nextDouble(max);
    }

    public static /* synthetic */ double double0$default(Random random, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        return random.double0(d);
    }

    public final int int0(int max) {
        return rnd.nextInt(max);
    }

    public static /* synthetic */ int int0$default(Random random, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        return random.int0(n);
    }

    public final int int(int min, int max) {
        return rnd.nextInt(min, max);
    }

    public static /* synthetic */ int int$default(Random random, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return random.int(n, n2);
    }

    public final boolean bool(double probability) {
        return rnd.nextDouble(1.0) < probability;
    }

    public static /* synthetic */ boolean bool$default(Random random, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return random.bool(d);
    }

    public final <T> T pick(@NotNull Collection<? extends T> coll) {
        Intrinsics.checkNotNullParameter(coll, (String)"coll");
        return (T)CollectionsKt.first((List)Random.pick$default(this, coll, null, 1, 2, null));
    }

    public final <T> T pick(@NotNull Collection<? extends T> coll, @NotNull Collection<? extends T> compareAgainst) {
        Intrinsics.checkNotNullParameter(coll, (String)"coll");
        Intrinsics.checkNotNullParameter(compareAgainst, (String)"compareAgainst");
        return (T)CollectionsKt.first(this.pick(coll, compareAgainst, 1));
    }

    @NotNull
    public final <T> List<T> pick(@NotNull Collection<? extends T> coll, @NotNull Collection<? extends T> compareAgainst, int count) {
        Intrinsics.checkNotNullParameter(coll, (String)"coll");
        Intrinsics.checkNotNullParameter(compareAgainst, (String)"compareAgainst");
        List list = CollectionsKt.toMutableList(coll);
        List picked = new ArrayList();
        if (coll.isEmpty()) {
            return list;
        }
        while (picked.size() < count) {
            if (list.isEmpty()) {
                list = CollectionsKt.toMutableList(coll);
            }
            int index = this.int0(list.size());
            Object newElem = list.get(index);
            while (compareAgainst.contains(newElem)) {
                index = this.int0(list.size());
                newElem = list.get(index);
            }
            picked.add(list.get(index));
            list.remove(index);
        }
        return picked;
    }

    public static /* synthetic */ List pick$default(Random random, Collection collection, Collection collection2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        return random.pick(collection, collection2, n);
    }

    public final double gaussian(double mean, double standardDeviation) {
        return GaussianRandomKt.gaussian(mean, standardDeviation, rnd);
    }

    public static /* synthetic */ double gaussian$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.gaussian(d, d2);
    }

    @NotNull
    public final Function0<Double> pareto(double alpha) {
        double d = 0.0;
        double invAlpha = 1.0 / Math.max(alpha, d);
        return (Function0)new Function0<Double>(invAlpha){
            final /* synthetic */ double $invAlpha;
            {
                this.$invAlpha = $invAlpha;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return 1.0 / Math.pow(1.0 - Random.double0$default(Random.INSTANCE, 0.0, 1, null), this.$invAlpha);
            }
        };
    }

    public static /* synthetic */ Function0 pareto$default(Random random, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        return random.pareto(d);
    }

    @NotNull
    public final Vector2 vector2(double min, double max) {
        return UniformRandomKt.uniform(Vector2.Companion, min, max, rnd);
    }

    public static /* synthetic */ Vector2 vector2$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.vector2(d, d2);
    }

    @NotNull
    public final Vector3 vector3(double min, double max) {
        return UniformRandomKt.uniform(Vector3.Companion, min, max, rnd);
    }

    public static /* synthetic */ Vector3 vector3$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.vector3(d, d2);
    }

    @NotNull
    public final Vector4 vector4(double min, double max) {
        return UniformRandomKt.uniform(Vector4.Companion, min, max, rnd);
    }

    public static /* synthetic */ Vector4 vector4$default(Random random, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = -1.0;
        }
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        return random.vector4(d, d2);
    }

    public final double perlin(double x, double y, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = PerlinNoise2DKt.perlinLinear(sd, x, y);
                break;
            }
            case 2: {
                d = PerlinNoise2DKt.perlinQuintic(sd, x, y);
                break;
            }
            case 3: {
                d = PerlinNoise2DKt.perlinHermite(sd, x, y);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double perlin$default(Random random, double d, double d2, Noise noise, int n, Object object) {
        if ((n & 4) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(d, d2, noise);
    }

    public final double perlin(@NotNull Vector2 position, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = PerlinNoise2DKt.perlinLinear(sd, position);
                break;
            }
            case 2: {
                d = PerlinNoise2DKt.perlinQuintic(sd, position);
                break;
            }
            case 3: {
                d = PerlinNoise2DKt.perlinHermite(sd, position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double perlin$default(Random random, Vector2 vector2, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(vector2, noise);
    }

    public final double perlin(double x, double y, double z, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = PerlinNoise3DKt.perlinLinear(sd, x, y, z);
                break;
            }
            case 2: {
                d = PerlinNoise3DKt.perlinQuintic(sd, x, y, z);
                break;
            }
            case 3: {
                d = PerlinNoise3DKt.perlinHermite(sd, x, y, z);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double perlin$default(Random random, double d, double d2, double d3, Noise noise, int n, Object object) {
        if ((n & 8) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(d, d2, d3, noise);
    }

    public final double perlin(@NotNull Vector3 position, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = PerlinNoise3DKt.perlinLinear(sd, position);
                break;
            }
            case 2: {
                d = PerlinNoise3DKt.perlinQuintic(sd, position);
                break;
            }
            case 3: {
                d = PerlinNoise3DKt.perlinHermite(sd, position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double perlin$default(Random random, Vector3 vector3, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.perlin(vector3, noise);
    }

    public final double value(double x, double y, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = ValueNoise2DKt.valueLinear(sd, x, y);
                break;
            }
            case 2: {
                d = ValueNoise2DKt.valueQuintic(sd, x, y);
                break;
            }
            case 3: {
                d = ValueNoise2DKt.valueHermite(sd, x, y);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double value$default(Random random, double d, double d2, Noise noise, int n, Object object) {
        if ((n & 4) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(d, d2, noise);
    }

    public final double value(@NotNull Vector2 position, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = ValueNoise2DKt.valueLinear(sd, position);
                break;
            }
            case 2: {
                d = ValueNoise2DKt.valueQuintic(sd, position);
                break;
            }
            case 3: {
                d = ValueNoise2DKt.valueHermite(sd, position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double value$default(Random random, Vector2 vector2, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(vector2, noise);
    }

    public final double value(double x, double y, double z, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = ValueNoise3DKt.valueLinear(sd, x, y, z);
                break;
            }
            case 2: {
                d = ValueNoise3DKt.valueQuintic(sd, x, y, z);
                break;
            }
            case 3: {
                d = ValueNoise3DKt.valueHermite(sd, x, y, z);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double value$default(Random random, double d, double d2, double d3, Noise noise, int n, Object object) {
        if ((n & 8) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(d, d2, d3, noise);
    }

    public final double value(@NotNull Vector3 position, @NotNull Noise type) {
        double d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int sd = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                d = ValueNoise3DKt.valueLinear(sd, position);
                break;
            }
            case 2: {
                d = ValueNoise3DKt.valueQuintic(sd, position);
                break;
            }
            case 3: {
                d = ValueNoise3DKt.valueHermite(sd, position);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double value$default(Random random, Vector3 vector3, Noise noise, int n, Object object) {
        if ((n & 2) != 0) {
            noise = Noise.LINEAR;
        }
        return random.value(vector3, noise);
    }

    public final double simplex(double x, double y) {
        return SimplexNoise2DKt.simplex(this.stringToInt(seed), x, y);
    }

    public final double simplex(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return SimplexNoise2DKt.simplex(this.stringToInt(seed), position);
    }

    public final double simplex(double x, double y, double z) {
        return SimplexNoise3DKt.simplex(this.stringToInt(seed), x, y, z);
    }

    public final double simplex(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return SimplexNoise3DKt.simplex(this.stringToInt(seed), position);
    }

    public final double simplex(double x, double y, double z, double w) {
        return SimplexNoise4DKt.simplex(this.stringToInt(seed), x, y, z, w);
    }

    public final double simplex(@NotNull Vector4 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return SimplexNoise4DKt.simplex(this.stringToInt(seed), position);
    }

    public final double fbm(double x, double y, @NotNull Function3<? super Integer, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        double d;
        Intrinsics.checkNotNullParameter(noiseFun, (String)"noiseFun");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int s = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                boolean $i$f$fbm = false;
                double sum$iv = ((Number)noiseFun.invoke((Object)s, (Object)x, (Object)y)).doubleValue();
                double amp$iv = 1.0;
                double lx$iv = x;
                double ly$iv = y;
                int n = 1;
                while (n < octaves) {
                    int i$iv = n++;
                    sum$iv += ((Number)noiseFun.invoke((Object)(s + i$iv), (Object)(lx$iv *= lacunarity), (Object)(ly$iv *= lacunarity))).doubleValue() * (amp$iv *= gain);
                }
                d = sum$iv;
                break;
            }
            case 2: {
                boolean $i$f$rigid = false;
                double sum$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x, (Object)y)).doubleValue());
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                int n = 1;
                while (n < octaves) {
                    int i$iv = n++;
                    sum$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv), (Object)(x$iv *= lacunarity), (Object)(y$iv *= lacunarity))).doubleValue())) * (amp$iv *= gain);
                }
                d = sum$iv;
                break;
            }
            case 3: {
                boolean $i$f$billow = false;
                double sum$iv = Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x, (Object)y)).doubleValue() * 2.0 - 1.0);
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                int n = 1;
                while (n < octaves) {
                    int i$iv = n++;
                    sum$iv += Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv), (Object)(x$iv *= lacunarity), (Object)(y$iv *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv *= gain);
                }
                d = sum$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double fbm$default(Random random, double d, double d2, Function3 function3, Fractal fractal, int n, double d3, double d4, int n2, Object object) {
        if ((n2 & 8) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 0x10) != 0) {
            n = 8;
        }
        if ((n2 & 0x20) != 0) {
            d3 = 0.5;
        }
        if ((n2 & 0x40) != 0) {
            d4 = 0.5;
        }
        return random.fbm(d, d2, (Function3<? super Integer, ? super Double, ? super Double, Double>)function3, fractal, n, d3, d4);
    }

    /*
     * WARNING - void declaration
     */
    public final double fbm(@NotNull Vector2 position, @NotNull Function3<? super Integer, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        double d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(noiseFun, (String)"noiseFun");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int s = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                void x$iv$iv;
                boolean $i$f$fbm = false;
                double d2 = position.getX();
                double y$iv$iv = position.getY();
                boolean $i$f$fbm2 = false;
                double sum$iv$iv = ((Number)noiseFun.invoke((Object)s, (Object)((double)x$iv$iv), (Object)y$iv$iv)).doubleValue();
                double amp$iv$iv = 1.0;
                void lx$iv$iv = x$iv$iv;
                double ly$iv$iv = y$iv$iv;
                int n = 1;
                while (n < octaves) {
                    int i$iv$iv = n++;
                    sum$iv$iv += ((Number)noiseFun.invoke((Object)(s + i$iv$iv), (Object)((double)(lx$iv$iv *= lacunarity)), (Object)(ly$iv$iv *= lacunarity))).doubleValue() * (amp$iv$iv *= gain);
                }
                d = sum$iv$iv;
                break;
            }
            case 2: {
                boolean $i$f$rigid = false;
                double x$iv$iv = position.getX();
                double y$iv$iv = position.getY();
                boolean $i$f$rigid2 = false;
                double sum$iv$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x$iv$iv, (Object)y$iv$iv)).doubleValue());
                double amp$iv$iv = 1.0;
                double x$iv$iv2 = x$iv$iv;
                double y$iv$iv2 = y$iv$iv;
                int n = 1;
                while (n < octaves) {
                    int i$iv$iv = n++;
                    sum$iv$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv$iv), (Object)(x$iv$iv2 *= lacunarity), (Object)(y$iv$iv2 *= lacunarity))).doubleValue())) * (amp$iv$iv *= gain);
                }
                d = sum$iv$iv;
                break;
            }
            case 3: {
                boolean $i$f$billow = false;
                double x$iv$iv = position.getX();
                double y$iv$iv = position.getY();
                boolean $i$f$billow2 = false;
                double sum$iv$iv = Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x$iv$iv, (Object)y$iv$iv)).doubleValue() * 2.0 - 1.0);
                double amp$iv$iv = 1.0;
                double x$iv$iv3 = x$iv$iv;
                double y$iv$iv3 = y$iv$iv;
                int n = 1;
                while (n < octaves) {
                    int i$iv$iv = n++;
                    sum$iv$iv += Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv$iv), (Object)(x$iv$iv3 *= lacunarity), (Object)(y$iv$iv3 *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv$iv *= gain);
                }
                d = sum$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double fbm$default(Random random, Vector2 vector2, Function3 function3, Fractal fractal, int n, double d, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        if ((n2 & 0x10) != 0) {
            d = 0.5;
        }
        if ((n2 & 0x20) != 0) {
            d2 = 0.5;
        }
        return random.fbm(vector2, (Function3<? super Integer, ? super Double, ? super Double, Double>)function3, fractal, n, d, d2);
    }

    public final double fbm(double x, double y, double z, @NotNull Function4<? super Integer, ? super Double, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        double d;
        Intrinsics.checkNotNullParameter(noiseFun, (String)"noiseFun");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int s = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                boolean $i$f$fbm = false;
                double sum$iv = ((Number)noiseFun.invoke((Object)s, (Object)x, (Object)y, (Object)z)).doubleValue();
                double amp$iv = 1.0;
                double lx$iv = x;
                double ly$iv = y;
                double lz$iv = z;
                int n = 1;
                while (n < octaves) {
                    int i$iv = n++;
                    sum$iv += ((Number)noiseFun.invoke((Object)(s + i$iv), (Object)(lx$iv *= lacunarity), (Object)(ly$iv *= lacunarity), (Object)(lz$iv *= lacunarity))).doubleValue() * (amp$iv *= gain);
                }
                d = sum$iv;
                break;
            }
            case 2: {
                boolean $i$f$rigid = false;
                double sum$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x, (Object)y, (Object)z)).doubleValue());
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                double z$iv = z;
                int n = 1;
                while (n < octaves) {
                    int i$iv = n++;
                    sum$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv), (Object)(x$iv *= lacunarity), (Object)(y$iv *= lacunarity), (Object)(z$iv *= lacunarity))).doubleValue())) * (amp$iv *= gain);
                }
                d = sum$iv;
                break;
            }
            case 3: {
                boolean $i$f$billow = false;
                double sum$iv = Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x, (Object)y, (Object)z)).doubleValue() * 2.0 - 1.0);
                double amp$iv = 1.0;
                double x$iv = x;
                double y$iv = y;
                double z$iv = z;
                int n = 1;
                while (n < octaves) {
                    int i$iv = n++;
                    sum$iv += Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv), (Object)(x$iv *= lacunarity), (Object)(y$iv *= lacunarity), (Object)(z$iv *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv *= gain);
                }
                d = sum$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double fbm$default(Random random, double d, double d2, double d3, Function4 function4, Fractal fractal, int n, double d4, double d5, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 0x20) != 0) {
            n = 8;
        }
        if ((n2 & 0x40) != 0) {
            d4 = 0.5;
        }
        if ((n2 & 0x80) != 0) {
            d5 = 0.5;
        }
        return random.fbm(d, d2, d3, (Function4<? super Integer, ? super Double, ? super Double, ? super Double, Double>)function4, fractal, n, d4, d5);
    }

    /*
     * WARNING - void declaration
     */
    public final double fbm(@NotNull Vector3 position, @NotNull Function4<? super Integer, ? super Double, ? super Double, ? super Double, Double> noiseFun, @NotNull Fractal type, int octaves, double lacunarity, double gain) {
        double d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(noiseFun, (String)"noiseFun");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int s = this.stringToInt(seed);
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                void y$iv$iv;
                void x$iv$iv;
                boolean $i$f$fbm = false;
                double d2 = position.getX();
                double d3 = position.getY();
                double z$iv$iv = position.getZ();
                boolean $i$f$fbm2 = false;
                double sum$iv$iv = ((Number)noiseFun.invoke((Object)s, (Object)((double)x$iv$iv), (Object)((double)y$iv$iv), (Object)z$iv$iv)).doubleValue();
                double amp$iv$iv = 1.0;
                void lx$iv$iv = x$iv$iv;
                void ly$iv$iv = y$iv$iv;
                double lz$iv$iv = z$iv$iv;
                int n = 1;
                while (n < octaves) {
                    int i$iv$iv = n++;
                    sum$iv$iv += ((Number)noiseFun.invoke((Object)(s + i$iv$iv), (Object)((double)(lx$iv$iv *= lacunarity)), (Object)((double)(ly$iv$iv *= lacunarity)), (Object)(lz$iv$iv *= lacunarity))).doubleValue() * (amp$iv$iv *= gain);
                }
                d = sum$iv$iv;
                break;
            }
            case 2: {
                boolean $i$f$rigid = false;
                double x$iv$iv = position.getX();
                double y$iv$iv = position.getY();
                double z$iv$iv = position.getZ();
                boolean $i$f$rigid2 = false;
                double sum$iv$iv = 1.0 - Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x$iv$iv, (Object)y$iv$iv, (Object)z$iv$iv)).doubleValue());
                double amp$iv$iv = 1.0;
                double x$iv$iv2 = x$iv$iv;
                double y$iv$iv2 = y$iv$iv;
                double z$iv$iv2 = z$iv$iv;
                int n = 1;
                while (n < octaves) {
                    int i$iv$iv = n++;
                    sum$iv$iv -= (1.0 - Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv$iv), (Object)(x$iv$iv2 *= lacunarity), (Object)(y$iv$iv2 *= lacunarity), (Object)(z$iv$iv2 *= lacunarity))).doubleValue())) * (amp$iv$iv *= gain);
                }
                d = sum$iv$iv;
                break;
            }
            case 3: {
                boolean $i$f$billow = false;
                double x$iv$iv = position.getX();
                double y$iv$iv = position.getY();
                double z$iv$iv = position.getZ();
                boolean $i$f$billow2 = false;
                double sum$iv$iv = Math.abs(((Number)noiseFun.invoke((Object)s, (Object)x$iv$iv, (Object)y$iv$iv, (Object)z$iv$iv)).doubleValue() * 2.0 - 1.0);
                double amp$iv$iv = 1.0;
                double x$iv$iv3 = x$iv$iv;
                double y$iv$iv3 = y$iv$iv;
                double z$iv$iv3 = z$iv$iv;
                int n = 1;
                while (n < octaves) {
                    int i$iv$iv = n++;
                    sum$iv$iv += Math.abs(((Number)noiseFun.invoke((Object)(s + i$iv$iv), (Object)(x$iv$iv3 *= lacunarity), (Object)(y$iv$iv3 *= lacunarity), (Object)(z$iv$iv3 *= lacunarity))).doubleValue() * 2.0 - 1.0) * (amp$iv$iv *= gain);
                }
                d = sum$iv$iv;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static /* synthetic */ double fbm$default(Random random, Vector3 vector3, Function4 function4, Fractal fractal, int n, double d, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fractal = Fractal.FBM;
        }
        if ((n2 & 8) != 0) {
            n = 8;
        }
        if ((n2 & 0x10) != 0) {
            d = 0.5;
        }
        if ((n2 & 0x20) != 0) {
            d2 = 0.5;
        }
        return random.fbm(vector3, (Function4<? super Integer, ? super Double, ? super Double, ? super Double, Double>)function4, fractal, n, d, d2);
    }

    public final double cubic(double x, double y) {
        return CubicNoise2DKt.cubic(this.stringToInt(seed), x, y);
    }

    public final double cubic(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise2DKt.cubic(this.stringToInt(seed), position);
    }

    public final double cubic(double x, double y, double z) {
        return CubicNoise3DKt.cubic(this.stringToInt(seed), x, y, z);
    }

    public final double cubic(@NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise3DKt.cubic(this.stringToInt(seed), position);
    }

    @NotNull
    public final Object ring2d(double innerRadius, double outerRadius, int count) {
        return count == 1 ? UniformRandomKt.uniformRing(Vector2.Companion, innerRadius, outerRadius, rnd) : UniformRandomKt.uniformsRing(Vector2.Companion, count, innerRadius, outerRadius, rnd);
    }

    public static /* synthetic */ Object ring2d$default(Random random, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = 0.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return random.ring2d(d, d2, n);
    }

    @NotNull
    public final Object ring3d(double innerRadius, double outerRadius, int count) {
        return count == 1 ? UniformRandomKt.uniformRing(Vector3.Companion, innerRadius, outerRadius, rnd) : UniformRandomKt.uniformsRing(Vector3.Companion, count, innerRadius, outerRadius, rnd);
    }

    public static /* synthetic */ Object ring3d$default(Random random, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = 0.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return random.ring3d(d, d2, n);
    }

    public final <T> T roll(@NotNull Collection<? extends T> elements, @NotNull Function1<? super Integer, ? extends List<Double>> distribution) {
        Object object;
        int index;
        block3: {
            int n;
            List probabilities;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(distribution, (String)"distribution");
            double result = Random.double0$default(this, 0.0, 1, null);
            List $this$indexOfFirst$iv = probabilities = (List)distribution.invoke((Object)elements.size());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                double it = ((Number)item$iv).doubleValue();
                boolean bl = false;
                if (result <= it) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if ((object = CollectionsKt.elementAtOrNull((Iterable)elements, (int)index)) == null) {
            object = CollectionsKt.last((Iterable)elements);
        }
        return (T)object;
    }

    @NotNull
    public final Vector2 point(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return rect.position(this.vector2(0.0, 1.0));
    }

    static {
        seed = "OPENRNDR";
        rnd = INSTANCE.newRandomGenerator(seed);
        state = new RandomState(seed, rnd);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openrndr/extra/noise/Random$Fractal;", "", "(Ljava/lang/String;I)V", "FBM", "BILLOW", "RIGID", "orx-noise"})
    public static final class Fractal
    extends Enum<Fractal> {
        public static final /* enum */ Fractal FBM = new Fractal();
        public static final /* enum */ Fractal BILLOW = new Fractal();
        public static final /* enum */ Fractal RIGID = new Fractal();
        private static final /* synthetic */ Fractal[] $VALUES;

        public static Fractal[] values() {
            return (Fractal[])$VALUES.clone();
        }

        public static Fractal valueOf(String value2) {
            return Enum.valueOf(Fractal.class, value2);
        }

        static {
            $VALUES = fractalArray = new Fractal[]{Fractal.FBM, Fractal.BILLOW, Fractal.RIGID};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openrndr/extra/noise/Random$Noise;", "", "(Ljava/lang/String;I)V", "LINEAR", "QUINTIC", "HERMIT", "orx-noise"})
    public static final class Noise
    extends Enum<Noise> {
        public static final /* enum */ Noise LINEAR = new Noise();
        public static final /* enum */ Noise QUINTIC = new Noise();
        public static final /* enum */ Noise HERMIT = new Noise();
        private static final /* synthetic */ Noise[] $VALUES;

        public static Noise[] values() {
            return (Noise[])$VALUES.clone();
        }

        public static Noise valueOf(String value2) {
            return Enum.valueOf(Noise.class, value2);
        }

        static {
            $VALUES = noiseArray = new Noise[]{Noise.LINEAR, Noise.QUINTIC, Noise.HERMIT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Noise.values().length];
            nArray[Noise.LINEAR.ordinal()] = 1;
            nArray[Noise.QUINTIC.ordinal()] = 2;
            nArray[Noise.HERMIT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Fractal.values().length];
            nArray[Fractal.FBM.ordinal()] = 1;
            nArray[Fractal.RIGID.ordinal()] = 2;
            nArray[Fractal.BILLOW.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

