/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.extra.noise.UniformRandomKt;
import org.openrndr.math.FunctionsKt;
import org.openrndr.math.Polar;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u00a3\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032O\b\u0002\u0010\u000f\u001aI\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"epsilon", "", "poissonDiskSampling", "", "Lorg/openrndr/math/Vector2;", "width", "height", "r", "tries", "", "randomOnRing", "", "random", "Lkotlin/random/Random;", "initialPoints", "boundsMapper", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "w", "h", "v", "orx-noise"})
public final class PoissonDiskKt {
    public static final double epsilon = 1.0E-7;

    @NotNull
    public static final List<Vector2> poissonDiskSampling(double width, double height, double r, int tries, boolean randomOnRing, @NotNull Random random, @NotNull List<Vector2> initialPoints, @Nullable Function3<? super Double, ? super Double, ? super Vector2, Boolean> boundsMapper) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter(initialPoints, (String)"initialPoints");
        List disk = new ArrayList();
        List queue = new ArrayList();
        double r2 = r * r;
        double radius = r + 1.0E-7;
        double cellSize = r / Math.sqrt(2.0);
        int rows = (int)Math.ceil(height / cellSize);
        int cols = (int)Math.ceil(width / cellSize);
        int n = 0;
        int n2 = rows * cols;
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = -1;
        }
        Integer[] grid = integerArray;
        for (Vector2 initialPoint : initialPoints) {
            PoissonDiskKt.poissonDiskSampling$addPoint(cellSize, cols, rows, disk, grid, queue, initialPoint);
        }
        Rectangle boundsRect = new Rectangle(0.0, 0.0, width, height);
        while (!((Collection)queue).isEmpty()) {
            int activeIndex = ((Number)CollectionsKt.random((Collection)queue, (Random)random)).intValue();
            Vector2 active = (Vector2)disk.get(activeIndex);
            boolean candidateAccepted = false;
            int n4 = 0;
            block3: while (n4 < tries) {
                int y;
                int x;
                int l = n4++;
                Vector2 c = randomOnRing ? active.plus(UniformRandomKt.uniformRing(Vector2.Companion, r, (double)2 * r, random)) : active.plus(new Polar(random.nextDouble(0.0, 360.0), radius).getCartesian());
                if (!boundsRect.contains(c) || grid[(x = MathUtilsKt.fastFloor(c.getX() / cellSize)) + (y = MathUtilsKt.fastFloor(c.getY() / cellSize)) * cols] != -1) continue;
                int n5 = -2;
                while (n5 < 3) {
                    int iy = n5++;
                    int n6 = -2;
                    while (n6 < 3) {
                        Vector2 neighbor;
                        int ny;
                        int ix;
                        int nx;
                        int neighborIdx;
                        if ((neighborIdx = grid[(nx = FunctionsKt.clamp((int)(x + (ix = n6++)), (int)0, (int)(cols - 1))) + (ny = FunctionsKt.clamp((int)(y + iy), (int)0, (int)(rows - 1))) * cols].intValue()) == -1 || !((neighbor = (Vector2)disk.get(neighborIdx)).minus(c).getSquaredLength() <= r2)) continue;
                        continue block3;
                    }
                }
                if (boundsMapper != null && !((Boolean)boundsMapper.invoke((Object)width, (Object)height, (Object)c)).booleanValue()) continue;
                PoissonDiskKt.poissonDiskSampling$addPoint(cellSize, cols, rows, disk, grid, queue, c);
                candidateAccepted = true;
                break;
            }
            if (candidateAccepted) continue;
            queue.remove((Object)activeIndex);
        }
        return disk;
    }

    public static /* synthetic */ List poissonDiskSampling$default(double d, double d2, double d3, int n, boolean bl, Random random, List list, Function3 function3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 30;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            random = (Random)Random.Default;
        }
        if ((n2 & 0x40) != 0) {
            list = CollectionsKt.listOf((Object)new Vector2(d / 2.0, d2 / 2.0));
        }
        if ((n2 & 0x80) != 0) {
            function3 = null;
        }
        return PoissonDiskKt.poissonDiskSampling(d, d2, d3, n, bl, random, list, (Function3<? super Double, ? super Double, ? super Vector2, Boolean>)function3);
    }

    private static final void poissonDiskSampling$addPoint(double cellSize, int cols, int rows, List<Vector2> disk, Integer[] grid, List<Integer> queue, Vector2 v) {
        int x = MathUtilsKt.fastFloor(v.getX() / cellSize);
        int y = MathUtilsKt.fastFloor(v.getY() / cellSize);
        int index = x + y * cols;
        if (x >= 0 && y >= 0 && x < cols && y < rows) {
            disk.add(v);
            grid[index] = CollectionsKt.getLastIndex(disk);
            queue.add(CollectionsKt.getLastIndex(disk));
        }
    }
}

