/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.extra.noise;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.extra.noise.CubicNoise3DKt;
import org.openrndr.extra.noise.GradCoordKt;
import org.openrndr.extra.noise.InterpolationKt;
import org.openrndr.extra.noise.MathUtilsKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a:\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012\u001a\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005\u001a\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"/\u0010\u0002\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"/\u0010\b\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"/\u0010\n\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0018"}, d2={"CUBIC_3D_BOUNDING", "", "cubicHermite3D", "Lkotlin/Function4;", "", "", "getCubicHermite3D", "()Lkotlin/jvm/functions/Function4;", "cubicLinear3D", "getCubicLinear3D", "cubicQuintic3D", "getCubicQuintic3D", "cubic", "seed", "x", "y", "z", "interpolator", "Lkotlin/Function1;", "position", "Lorg/openrndr/math/Vector3;", "cubicHermite", "cubicLinear", "cubicQuintic", "orx-noise"})
public final class CubicNoise3DKt {
    private static final float CUBIC_3D_BOUNDING = 0.2962963f;
    @NotNull
    private static final Function4<Integer, Double, Double, Double, Double> cubicLinear3D = cubicLinear3D.1.INSTANCE;
    @NotNull
    private static final Function4<Integer, Double, Double, Double, Double> cubicQuintic3D = cubicQuintic3D.1.INSTANCE;
    @NotNull
    private static final Function4<Integer, Double, Double, Double, Double> cubicHermite3D = cubicHermite3D.1.INSTANCE;

    public static final double cubic(int seed, double x, double y, double z) {
        return CubicNoise3DKt.cubic(seed, x, y, z, (Function1<? super Double, Double>)((Function1)cubic.1.INSTANCE));
    }

    public static final double cubicLinear(int seed, double x, double y, double z) {
        return CubicNoise3DKt.cubic(seed, x, y, z, (Function1<? super Double, Double>)((Function1)cubicLinear.1.INSTANCE));
    }

    public static final double cubicQuintic(int seed, double x, double y, double z) {
        return CubicNoise3DKt.cubic(seed, x, y, z, (Function1<? super Double, Double>)((Function1)cubicQuintic.1.INSTANCE));
    }

    public static final double cubicHermite(int seed, double x, double y, double z) {
        boolean $i$f$perlin = false;
        int x0$iv = MathUtilsKt.fastFloor(x);
        int y0$iv = MathUtilsKt.fastFloor(y);
        int z0$iv = MathUtilsKt.fastFloor(z);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        int z1$iv = z0$iv + 1;
        double p0 = x - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.hermite(p0);
        double p02 = y - (double)y0$iv;
        $i$a$-perlin-CubicNoise3DKt$cubicHermite$1 = false;
        double ys$iv = InterpolationKt.hermite(p02);
        double p03 = z - (double)z0$iv;
        $i$a$-perlin-CubicNoise3DKt$cubicHermite$1 = false;
        double zs$iv = InterpolationKt.hermite(p03);
        double xd0$iv = x - (double)x0$iv;
        double yd0$iv = y - (double)y0$iv;
        double zd0$iv = z - (double)z0$iv;
        double xd1$iv = xd0$iv - 1.0;
        double yd1$iv = yd0$iv - 1.0;
        double zd1$iv = zd0$iv - 1.0;
        double xf00$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y0$iv, z0$iv, xd0$iv, yd0$iv, zd0$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y0$iv, z0$iv, xd1$iv, yd0$iv, zd0$iv), (double)xs$iv);
        double xf10$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y1$iv, z0$iv, xd0$iv, yd1$iv, zd0$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y1$iv, z0$iv, xd1$iv, yd1$iv, zd0$iv), (double)xs$iv);
        double xf01$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y0$iv, z1$iv, xd0$iv, yd0$iv, zd1$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y0$iv, z1$iv, xd1$iv, yd0$iv, zd1$iv), (double)xs$iv);
        double xf11$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y1$iv, z1$iv, xd0$iv, yd1$iv, zd1$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y1$iv, z1$iv, xd1$iv, yd1$iv, zd1$iv), (double)xs$iv);
        double yf0$iv = MappingKt.mix((double)xf00$iv, (double)xf10$iv, (double)ys$iv);
        double yf1$iv = MappingKt.mix((double)xf01$iv, (double)xf11$iv, (double)ys$iv);
        return MappingKt.mix((double)yf0$iv, (double)yf1$iv, (double)zs$iv);
    }

    public static final double cubic(int seed, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise3DKt.cubic(seed, position.getX(), position.getY(), position.getZ(), (Function1<? super Double, Double>)((Function1)cubic.2.INSTANCE));
    }

    public static final double cubicLinear(int seed, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise3DKt.cubic(seed, position.getX(), position.getY(), position.getZ(), (Function1<? super Double, Double>)((Function1)cubicLinear.2.INSTANCE));
    }

    public static final double cubicQuintic(int seed, @NotNull Vector3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return CubicNoise3DKt.cubic(seed, position.getX(), position.getY(), position.getZ(), (Function1<? super Double, Double>)((Function1)cubicQuintic.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public static final double cubicHermite(int seed, @NotNull Vector3 position) {
        void y$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        double d = position.getX();
        double d2 = position.getY();
        double z$iv = position.getZ();
        boolean $i$f$perlin = false;
        int x0$iv = MathUtilsKt.fastFloor((double)x$iv);
        int y0$iv = MathUtilsKt.fastFloor((double)y$iv);
        int z0$iv = MathUtilsKt.fastFloor(z$iv);
        int x1$iv = x0$iv + 1;
        int y1$iv = y0$iv + 1;
        int z1$iv = z0$iv + 1;
        void p0 = x$iv - (double)x0$iv;
        boolean bl = false;
        double xs$iv = InterpolationKt.hermite((double)p0);
        void p02 = y$iv - (double)y0$iv;
        $i$a$-perlin-CubicNoise3DKt$cubicHermite$2 = false;
        double ys$iv = InterpolationKt.hermite((double)p02);
        double p03 = z$iv - (double)z0$iv;
        $i$a$-perlin-CubicNoise3DKt$cubicHermite$2 = false;
        double zs$iv = InterpolationKt.hermite(p03);
        void xd0$iv = x$iv - (double)x0$iv;
        void yd0$iv = y$iv - (double)y0$iv;
        double zd0$iv = z$iv - (double)z0$iv;
        void xd1$iv = xd0$iv - 1.0;
        void yd1$iv = yd0$iv - 1.0;
        double zd1$iv = zd0$iv - 1.0;
        double xf00$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y0$iv, z0$iv, (double)xd0$iv, (double)yd0$iv, zd0$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y0$iv, z0$iv, (double)xd1$iv, (double)yd0$iv, zd0$iv), (double)xs$iv);
        double xf10$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y1$iv, z0$iv, (double)xd0$iv, (double)yd1$iv, zd0$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y1$iv, z0$iv, (double)xd1$iv, (double)yd1$iv, zd0$iv), (double)xs$iv);
        double xf01$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y0$iv, z1$iv, (double)xd0$iv, (double)yd0$iv, zd1$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y0$iv, z1$iv, (double)xd1$iv, (double)yd0$iv, zd1$iv), (double)xs$iv);
        double xf11$iv = MappingKt.mix((double)GradCoordKt.gradCoord3D(seed, x0$iv, y1$iv, z1$iv, (double)xd0$iv, (double)yd1$iv, zd1$iv), (double)GradCoordKt.gradCoord3D(seed, x1$iv, y1$iv, z1$iv, (double)xd1$iv, (double)yd1$iv, zd1$iv), (double)xs$iv);
        double yf0$iv = MappingKt.mix((double)xf00$iv, (double)xf10$iv, (double)ys$iv);
        double yf1$iv = MappingKt.mix((double)xf01$iv, (double)xf11$iv, (double)ys$iv);
        return MappingKt.mix((double)yf0$iv, (double)yf1$iv, (double)zs$iv);
    }

    public static final double cubic(int seed, double x, double y, double z, @NotNull Function1<? super Double, Double> interpolator) {
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        int x1 = MathUtilsKt.fastFloor(x);
        int y1 = MathUtilsKt.fastFloor(y);
        int z1 = MathUtilsKt.fastFloor(z);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int z0 = z1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        int z3 = z1 + 2;
        double xs = ((Number)interpolator.invoke((Object)(x - (double)x1))).doubleValue();
        double ys = ((Number)interpolator.invoke((Object)(y - (double)y1))).doubleValue();
        double zs = ((Number)interpolator.invoke((Object)(z - (double)z1))).doubleValue();
        return InterpolationKt.cubic(InterpolationKt.cubic(InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y0, z0), GradCoordKt.valCoord3D(seed, x1, y0, z0), GradCoordKt.valCoord3D(seed, x2, y0, z0), GradCoordKt.valCoord3D(seed, x3, y0, z0), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y1, z0), GradCoordKt.valCoord3D(seed, x1, y1, z0), GradCoordKt.valCoord3D(seed, x2, y1, z0), GradCoordKt.valCoord3D(seed, x3, y1, z0), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y2, z0), GradCoordKt.valCoord3D(seed, x1, y2, z0), GradCoordKt.valCoord3D(seed, x2, y2, z0), GradCoordKt.valCoord3D(seed, x3, y2, z0), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y3, z0), GradCoordKt.valCoord3D(seed, x1, y3, z0), GradCoordKt.valCoord3D(seed, x2, y3, z0), GradCoordKt.valCoord3D(seed, x3, y3, z0), xs), ys), InterpolationKt.cubic(InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y0, z1), GradCoordKt.valCoord3D(seed, x1, y0, z1), GradCoordKt.valCoord3D(seed, x2, y0, z1), GradCoordKt.valCoord3D(seed, x3, y0, z1), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y1, z1), GradCoordKt.valCoord3D(seed, x1, y1, z1), GradCoordKt.valCoord3D(seed, x2, y1, z1), GradCoordKt.valCoord3D(seed, x3, y1, z1), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y2, z1), GradCoordKt.valCoord3D(seed, x1, y2, z1), GradCoordKt.valCoord3D(seed, x2, y2, z1), GradCoordKt.valCoord3D(seed, x3, y2, z1), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y3, z1), GradCoordKt.valCoord3D(seed, x1, y3, z1), GradCoordKt.valCoord3D(seed, x2, y3, z1), GradCoordKt.valCoord3D(seed, x3, y3, z1), xs), ys), InterpolationKt.cubic(InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y0, z2), GradCoordKt.valCoord3D(seed, x1, y0, z2), GradCoordKt.valCoord3D(seed, x2, y0, z2), GradCoordKt.valCoord3D(seed, x3, y0, z2), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y1, z2), GradCoordKt.valCoord3D(seed, x1, y1, z2), GradCoordKt.valCoord3D(seed, x2, y1, z2), GradCoordKt.valCoord3D(seed, x3, y1, z2), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y2, z2), GradCoordKt.valCoord3D(seed, x1, y2, z2), GradCoordKt.valCoord3D(seed, x2, y2, z2), GradCoordKt.valCoord3D(seed, x3, y2, z2), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y3, z2), GradCoordKt.valCoord3D(seed, x1, y3, z2), GradCoordKt.valCoord3D(seed, x2, y3, z2), GradCoordKt.valCoord3D(seed, x3, y3, z2), xs), ys), InterpolationKt.cubic(InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y0, z3), GradCoordKt.valCoord3D(seed, x1, y0, z3), GradCoordKt.valCoord3D(seed, x2, y0, z3), GradCoordKt.valCoord3D(seed, x3, y0, z3), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y1, z3), GradCoordKt.valCoord3D(seed, x1, y1, z3), GradCoordKt.valCoord3D(seed, x2, y1, z3), GradCoordKt.valCoord3D(seed, x3, y1, z3), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y2, z3), GradCoordKt.valCoord3D(seed, x1, y2, z3), GradCoordKt.valCoord3D(seed, x2, y2, z3), GradCoordKt.valCoord3D(seed, x3, y2, z3), xs), InterpolationKt.cubic(GradCoordKt.valCoord3D(seed, x0, y3, z3), GradCoordKt.valCoord3D(seed, x1, y3, z3), GradCoordKt.valCoord3D(seed, x2, y3, z3), GradCoordKt.valCoord3D(seed, x3, y3, z3), xs), ys), zs) * (double)0.2962963f;
    }

    @NotNull
    public static final Function4<Integer, Double, Double, Double, Double> getCubicLinear3D() {
        return cubicLinear3D;
    }

    @NotNull
    public static final Function4<Integer, Double, Double, Double, Double> getCubicQuintic3D() {
        return cubicQuintic3D;
    }

    @NotNull
    public static final Function4<Integer, Double, Double, Double, Double> getCubicHermite3D() {
        return cubicHermite3D;
    }
}

