/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.openrewrite.jgit.annotations.NonNull;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.events.RefsChangedEvent;
import org.openrewrite.jgit.internal.storage.file.FileReftableStack;
import org.openrewrite.jgit.internal.storage.file.FileRepository;
import org.openrewrite.jgit.internal.storage.reftable.MergedReftable;
import org.openrewrite.jgit.internal.storage.reftable.ReftableBatchRefUpdate;
import org.openrewrite.jgit.internal.storage.reftable.ReftableDatabase;
import org.openrewrite.jgit.internal.storage.reftable.ReftableWriter;
import org.openrewrite.jgit.lib.BatchRefUpdate;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectIdRef;
import org.openrewrite.jgit.lib.PersonIdent;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.RefDatabase;
import org.openrewrite.jgit.lib.RefRename;
import org.openrewrite.jgit.lib.RefUpdate;
import org.openrewrite.jgit.lib.ReflogEntry;
import org.openrewrite.jgit.lib.ReflogReader;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.lib.SymbolicRef;
import org.openrewrite.jgit.revwalk.RevObject;
import org.openrewrite.jgit.revwalk.RevTag;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.transport.ReceiveCommand;
import org.openrewrite.jgit.util.FileUtils;
import org.openrewrite.jgit.util.RefList;
import org.openrewrite.jgit.util.RefMap;

public class FileReftableDatabase
extends RefDatabase {
    private final ReftableDatabase reftableDatabase;
    private final FileRepository fileRepository;
    private final FileReftableStack reftableStack;

    FileReftableDatabase(FileRepository repo) throws IOException {
        this(repo, new File(new File(repo.getDirectory(), "reftable"), "tables.list"));
    }

    FileReftableDatabase(FileRepository repo, File refstackName) throws IOException {
        this.fileRepository = repo;
        this.reftableStack = new FileReftableStack(refstackName, new File(this.fileRepository.getDirectory(), "reftable"), () -> this.fileRepository.fireEvent(new RefsChangedEvent()), () -> this.fileRepository.getConfig());
        this.reftableDatabase = new ReftableDatabase(){

            @Override
            public MergedReftable openMergedReftable() throws IOException {
                return FileReftableDatabase.this.reftableStack.getMergedReftable();
            }
        };
    }

    ReflogReader getReflogReader(String refname) throws IOException {
        return this.reftableDatabase.getReflogReader(refname);
    }

    public static boolean isReftable(File repoDir) {
        return new File(repoDir, "reftable").isDirectory();
    }

    @Override
    public boolean hasFastTipsWithSha1() throws IOException {
        return this.reftableDatabase.hasFastTipsWithSha1();
    }

    public void compactFully() throws IOException {
        ReentrantLock l = this.reftableDatabase.getLock();
        l.lock();
        try {
            this.reftableStack.compactFully();
            this.reftableDatabase.clearCache();
        }
        finally {
            l.unlock();
        }
    }

    private ReentrantLock getLock() {
        return this.reftableDatabase.getLock();
    }

    @Override
    public boolean performsAtomicTransactions() {
        return true;
    }

    @Override
    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new FileReftableBatchRefUpdate(this, this.fileRepository);
    }

    @Override
    public RefUpdate newUpdate(String refName, boolean detach) throws IOException {
        boolean detachingSymbolicRef = false;
        Ref ref = this.exactRef(refName);
        if (ref == null) {
            ref = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, refName, null);
        } else {
            detachingSymbolicRef = detach && ref.isSymbolic();
        }
        FileReftableRefUpdate update = new FileReftableRefUpdate(ref);
        if (detachingSymbolicRef) {
            update.setDetachingSymbolicRef();
        }
        return update;
    }

    @Override
    public Ref exactRef(String name) throws IOException {
        return this.reftableDatabase.exactRef(name);
    }

    @Override
    public List<Ref> getRefs() throws IOException {
        return super.getRefs();
    }

    @Override
    public Map<String, Ref> getRefs(String prefix) throws IOException {
        List<Ref> refs = this.reftableDatabase.getRefsByPrefix(prefix);
        RefList.Builder<Ref> builder = new RefList.Builder<Ref>(refs.size());
        for (Ref r : refs) {
            builder.add(r);
        }
        return new RefMap(prefix, builder.toRefList(), RefList.emptyList(), RefList.emptyList());
    }

    @Override
    public List<Ref> getRefsByPrefixWithExclusions(String include, Set<String> excludes) throws IOException {
        return this.reftableDatabase.getRefsByPrefixWithExclusions(include, excludes);
    }

    @Override
    public List<Ref> getAdditionalRefs() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public Ref peel(Ref ref) throws IOException {
        Ref oldLeaf = ref.getLeaf();
        if (oldLeaf.isPeeled() || oldLeaf.getObjectId() == null) {
            return ref;
        }
        return FileReftableDatabase.recreate(ref, this.doPeel(oldLeaf), this.hasVersioning());
    }

    private Ref doPeel(Ref leaf) throws IOException {
        try (RevWalk rw = new RevWalk(this.fileRepository);){
            RevObject obj = rw.parseAny(leaf.getObjectId());
            if (obj instanceof RevTag) {
                ObjectIdRef.PeeledTag peeledTag = new ObjectIdRef.PeeledTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), rw.peel(obj).copy(), this.hasVersioning() ? leaf.getUpdateIndex() : -1L);
                return peeledTag;
            }
            ObjectIdRef.PeeledNonTag peeledNonTag = new ObjectIdRef.PeeledNonTag(leaf.getStorage(), leaf.getName(), leaf.getObjectId(), this.hasVersioning() ? leaf.getUpdateIndex() : -1L);
            return peeledNonTag;
        }
    }

    private static Ref recreate(Ref old, Ref leaf, boolean hasVersioning) {
        if (old.isSymbolic()) {
            Ref dst = FileReftableDatabase.recreate(old.getTarget(), leaf, hasVersioning);
            return new SymbolicRef(old.getName(), dst, hasVersioning ? old.getUpdateIndex() : -1L);
        }
        return leaf;
    }

    @Override
    public RefRename newRename(String fromName, String toName) throws IOException {
        RefUpdate src = this.newUpdate(fromName, true);
        RefUpdate dst = this.newUpdate(toName, true);
        return new FileRefRename(src, dst);
    }

    @Override
    public boolean isNameConflicting(String name) throws IOException {
        return this.reftableDatabase.isNameConflicting(name, new TreeSet<String>(), new HashSet<String>());
    }

    @Override
    public void close() {
        this.reftableStack.close();
    }

    @Override
    public void create() throws IOException {
        FileUtils.mkdir(new File(this.fileRepository.getDirectory(), "reftable"), true);
    }

    private boolean addReftable(FileReftableStack.Writer w) throws IOException {
        if (!this.reftableStack.addReftable(w)) {
            this.reftableStack.reload();
            this.reftableDatabase.clearCache();
            return false;
        }
        this.reftableDatabase.clearCache();
        return true;
    }

    private static void writeConvertTable(Repository repo, ReftableWriter w, boolean writeLogs) throws IOException {
        int size = 0;
        List<Ref> refs = repo.getRefDatabase().getRefs();
        if (writeLogs) {
            for (Ref ref : refs) {
                ReflogReader rlr = repo.getReflogReader(ref.getName());
                if (rlr == null) continue;
                size = Math.max(rlr.getReverseEntries().size(), size);
            }
        }
        w.setMinUpdateIndex(1L).setMaxUpdateIndex(size + 1).begin();
        Throwable throwable = null;
        try (RevWalk rw = new RevWalk(repo);){
            ArrayList<Ref> toWrite = new ArrayList<Ref>(refs.size());
            for (Ref r3 : refs) {
                toWrite.add(FileReftableDatabase.refForWrite(rw, r3));
            }
            w.sortAndWriteRefs(toWrite);
        }
        catch (Throwable toWrite) {
            Throwable throwable2 = toWrite;
            throw toWrite;
        }
        if (writeLogs) {
            for (Ref ref : refs) {
                long idx = size;
                ReflogReader reader = repo.getReflogReader(ref.getName());
                if (reader == null) continue;
                for (ReflogEntry e : reader.getReverseEntries()) {
                    w.writeLog(ref.getName(), idx, e.getWho(), e.getOldId(), e.getNewId(), e.getComment());
                    --idx;
                }
            }
        }
    }

    private static Ref refForWrite(RevWalk rw, Ref r) throws IOException {
        if (r.isSymbolic()) {
            return new SymbolicRef(r.getName(), new ObjectIdRef.Unpeeled(Ref.Storage.NEW, r.getTarget().getName(), null));
        }
        ObjectId newId = r.getObjectId();
        RevObject peel = null;
        try {
            RevObject obj = rw.parseAny(newId);
            if (obj instanceof RevTag) {
                peel = rw.peel(obj);
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
        if (peel != null) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, r.getName(), newId, peel.copy());
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, r.getName(), newId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileReftableDatabase convertFrom(FileRepository repo, boolean writeLogs) throws IOException {
        FileReftableDatabase newDb = null;
        File reftableList = null;
        try {
            File reftableDir = new File(repo.getDirectory(), "reftable");
            reftableList = new File(reftableDir, "tables.list");
            if (!reftableDir.isDirectory()) {
                reftableDir.mkdir();
            }
            try (FileReftableStack stack = new FileReftableStack(reftableList, reftableDir, null, () -> repo.getConfig());){
                stack.addReftable(rw -> FileReftableDatabase.writeConvertTable(repo, rw, writeLogs));
            }
            reftableList = null;
        }
        finally {
            if (reftableList != null) {
                reftableList.delete();
            }
        }
        return newDb;
    }

    private class FileReftableRefUpdate
    extends RefUpdate {
        private RevWalk rw;
        private Ref dstRef;

        FileReftableRefUpdate(Ref ref) {
            super(ref);
        }

        @Override
        protected RefDatabase getRefDatabase() {
            return FileReftableDatabase.this;
        }

        @Override
        protected Repository getRepository() {
            return FileReftableDatabase.this.fileRepository;
        }

        @Override
        protected void unlock() {
        }

        @Override
        public RefUpdate.Result update(RevWalk walk) throws IOException {
            try {
                this.rw = walk;
                RefUpdate.Result result = super.update(walk);
                return result;
            }
            finally {
                this.rw = null;
            }
        }

        @Override
        protected boolean tryLock(boolean deref) throws IOException {
            Ref derefed;
            this.dstRef = this.getRef();
            if (deref) {
                this.dstRef = this.dstRef.getLeaf();
            }
            if ((derefed = FileReftableDatabase.this.exactRef(this.dstRef.getName())) != null) {
                this.setOldObjectId(derefed.getObjectId());
            }
            return true;
        }

        void writeUpdate(ReftableWriter w) throws IOException {
            RevObject obj;
            ObjectIdRef newRef = null;
            if (this.rw != null && !ObjectId.zeroId().equals(this.getNewObjectId()) && (obj = this.rw.parseAny(this.getNewObjectId())) instanceof RevTag) {
                newRef = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, this.dstRef.getName(), this.getNewObjectId(), this.rw.peel(obj).copy());
            }
            if (newRef == null) {
                newRef = new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, this.dstRef.getName(), this.getNewObjectId());
            }
            long idx = FileReftableDatabase.this.reftableDatabase.nextUpdateIndex();
            w.setMinUpdateIndex(idx).setMaxUpdateIndex(idx).begin().writeRef(newRef);
            ObjectId oldId = this.getOldObjectId();
            if (oldId == null) {
                oldId = ObjectId.zeroId();
            }
            w.writeLog(this.dstRef.getName(), idx, this.getRefLogIdent(), oldId, this.getNewObjectId(), this.getRefLogMessage());
        }

        @Override
        public PersonIdent getRefLogIdent() {
            PersonIdent who = super.getRefLogIdent();
            if (who == null) {
                who = new PersonIdent(this.getRepository());
            }
            return who;
        }

        void writeDelete(ReftableWriter w) throws IOException {
            ObjectIdRef.Unpeeled newRef = new ObjectIdRef.Unpeeled(Ref.Storage.NEW, this.dstRef.getName(), null);
            long idx = FileReftableDatabase.this.reftableDatabase.nextUpdateIndex();
            w.setMinUpdateIndex(idx).setMaxUpdateIndex(idx).begin().writeRef(newRef);
            ObjectId oldId = ObjectId.zeroId();
            Ref old = FileReftableDatabase.this.exactRef(this.dstRef.getName());
            if (old != null && (old = old.getLeaf()).getObjectId() != null) {
                oldId = old.getObjectId();
            }
            w.writeLog(this.dstRef.getName(), idx, this.getRefLogIdent(), oldId, ObjectId.zeroId(), this.getRefLogMessage());
        }

        @Override
        protected RefUpdate.Result doUpdate(RefUpdate.Result desiredResult) throws IOException {
            if (this.isRefLogIncludingResult()) {
                this.setRefLogMessage(this.getRefLogMessage() + ": " + desiredResult.toString(), false);
            }
            if (!FileReftableDatabase.this.addReftable(this::writeUpdate)) {
                return RefUpdate.Result.LOCK_FAILURE;
            }
            return desiredResult;
        }

        @Override
        protected RefUpdate.Result doDelete(RefUpdate.Result desiredResult) throws IOException {
            if (this.isRefLogIncludingResult()) {
                this.setRefLogMessage(this.getRefLogMessage() + ": " + desiredResult.toString(), false);
            }
            if (!FileReftableDatabase.this.addReftable(this::writeDelete)) {
                return RefUpdate.Result.LOCK_FAILURE;
            }
            return desiredResult;
        }

        void writeLink(ReftableWriter w) throws IOException {
            long idx = FileReftableDatabase.this.reftableDatabase.nextUpdateIndex();
            w.setMinUpdateIndex(idx).setMaxUpdateIndex(idx).begin().writeRef(this.dstRef);
            ObjectId beforeId = ObjectId.zeroId();
            Ref before = FileReftableDatabase.this.exactRef(this.dstRef.getName());
            if (before != null && (before = before.getLeaf()).getObjectId() != null) {
                beforeId = before.getObjectId();
            }
            Ref after = this.dstRef.getLeaf();
            ObjectId afterId = ObjectId.zeroId();
            if (after.getObjectId() != null) {
                afterId = after.getObjectId();
            }
            w.writeLog(this.dstRef.getName(), idx, this.getRefLogIdent(), beforeId, afterId, this.getRefLogMessage());
        }

        @Override
        protected RefUpdate.Result doLink(String target) throws IOException {
            if (this.isRefLogIncludingResult()) {
                this.setRefLogMessage(this.getRefLogMessage() + ": " + RefUpdate.Result.FORCED.toString(), false);
            }
            boolean exists = FileReftableDatabase.this.exactRef(this.getName()) != null;
            this.dstRef = new SymbolicRef(this.getName(), new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null), FileReftableDatabase.this.reftableDatabase.nextUpdateIndex());
            if (!FileReftableDatabase.this.addReftable(this::writeLink)) {
                return RefUpdate.Result.LOCK_FAILURE;
            }
            return exists ? RefUpdate.Result.FORCED : RefUpdate.Result.NEW;
        }
    }

    private class FileReftableBatchRefUpdate
    extends ReftableBatchRefUpdate {
        FileReftableBatchRefUpdate(FileReftableDatabase db, Repository repository) {
            super(db, db.reftableDatabase, db.getLock(), repository);
        }

        @Override
        protected void applyUpdates(List<Ref> newRefs, List<ReceiveCommand> pending) throws IOException {
            if (!FileReftableDatabase.this.addReftable(rw -> this.write(rw, newRefs, pending))) {
                for (ReceiveCommand c : pending) {
                    if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    c.setResult(RefUpdate.Result.LOCK_FAILURE);
                }
            }
        }
    }

    private class FileRefRename
    extends RefRename {
        FileRefRename(RefUpdate src, RefUpdate dst) {
            super(src, dst);
        }

        void writeRename(ReftableWriter w) throws IOException {
            long idx = FileReftableDatabase.this.reftableDatabase.nextUpdateIndex();
            w.setMinUpdateIndex(idx).setMaxUpdateIndex(idx).begin();
            ArrayList<Ref> refs = new ArrayList<Ref>(3);
            Ref dest = this.destination.getRef();
            Ref head = FileReftableDatabase.this.exactRef("HEAD");
            if (head != null && head.isSymbolic() && head.getLeaf().getName().equals(this.source.getName())) {
                head = new SymbolicRef("HEAD", dest, idx);
                refs.add(head);
            }
            ObjectId objId = this.source.getRef().getObjectId();
            refs.add(new ObjectIdRef.PeeledNonTag(Ref.Storage.NEW, this.destination.getName(), objId));
            refs.add(new ObjectIdRef.Unpeeled(Ref.Storage.NEW, this.source.getName(), null));
            w.sortAndWriteRefs(refs);
            PersonIdent who = this.destination.getRefLogIdent();
            if (who == null) {
                who = new PersonIdent(FileReftableDatabase.this.fileRepository);
            }
            if (!this.destination.getRefLogMessage().isEmpty()) {
                List refnames = refs.stream().map(r -> r.getName()).collect(Collectors.toList());
                Collections.sort(refnames);
                for (String s : refnames) {
                    ObjectId old = "HEAD".equals(s) || s.equals(this.source.getName()) ? objId : ObjectId.zeroId();
                    ObjectId newId = "HEAD".equals(s) || s.equals(this.destination.getName()) ? objId : ObjectId.zeroId();
                    w.writeLog(s, idx, who, old, newId, this.destination.getRefLogMessage());
                }
            }
        }

        @Override
        protected RefUpdate.Result doRename() throws IOException {
            Ref src = FileReftableDatabase.this.exactRef(this.source.getName());
            if (FileReftableDatabase.this.exactRef(this.destination.getName()) != null || src == null || !this.source.getOldObjectId().equals(src.getObjectId())) {
                return RefUpdate.Result.LOCK_FAILURE;
            }
            if (src.isSymbolic()) {
                return RefUpdate.Result.IO_FAILURE;
            }
            if (!FileReftableDatabase.this.addReftable(this::writeRename)) {
                return RefUpdate.Result.LOCK_FAILURE;
            }
            return RefUpdate.Result.RENAMED;
        }
    }
}

