/*
* Copyright 2017 Marc Stevens <marc@marc-stevens.nl>, Dan Shumow <danshu@microsoft.com>
* Distributed under the MIT Software License.
* MIT License
*
* Copyright (c) 2017:
*     Marc Stevens
*     Cryptology Group
*     Centrum Wiskunde & Informatica
*     P.O. Box 94079, 1090 GB Amsterdam, Netherlands
*     marc@marc-stevens.nl
*
*     Dan Shumow
*     Microsoft Research
*     danshu@microsoft.com
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*/

package org.openrewrite.jgit.util.sha1;

// Converted by hand by Shawn Pearce (Google), using lib/ubc_check.c from
// https://github.com/cr-marcstevens/sha1collisiondetection/
//
// this file was generated by the 'parse_bitrel' program in the tools section
// using the data files from directory 'tools/data/3565'
//
// Array DV contains a list of SHA-1 Disturbance Vectors (DV) to check
// dvType, dvK and dvB define the DV: I(K,B) or II(K,B) (see the paper)
// dm[80] is the expanded message block XOR-difference defined by the DV
// testt is the step to do the recompression from for collision detection
// maski and maskb define the bit to check for each DV in the dvmask returned by ubc_check
//
// ubc_check takes as input an expanded message block and verifies the unavoidable bitconditions for all listed DVs
// it returns a dvmask where each bit belonging to a DV is set if all unavoidable bitconditions for that DV have been met
// thus one needs to do the recompression check for each DV that has its bit set
//
// ubc_check is programmatically generated and the unavoidable bitconditions have been hardcoded
// a directly verifiable version named ubc_check_verify can be found in ubc_check_verify.c
// ubc_check has been verified against ubc_check_verify using the 'ubc_check_test' program in the tools section

final class UbcCheck {
	private static final int DV_I_43_0_bit = 1 << 0;
	private static final int DV_I_44_0_bit = 1 << 1;
	private static final int DV_I_45_0_bit = 1 << 2;
	private static final int DV_I_46_0_bit = 1 << 3;
	private static final int DV_I_46_2_bit = 1 << 4;
	private static final int DV_I_47_0_bit = 1 << 5;
	private static final int DV_I_47_2_bit = 1 << 6;
	private static final int DV_I_48_0_bit = 1 << 7;
	private static final int DV_I_48_2_bit = 1 << 8;
	private static final int DV_I_49_0_bit = 1 << 9;
	private static final int DV_I_49_2_bit = 1 << 10;
	private static final int DV_I_50_0_bit = 1 << 11;
	private static final int DV_I_50_2_bit = 1 << 12;
	private static final int DV_I_51_0_bit = 1 << 13;
	private static final int DV_I_51_2_bit = 1 << 14;
	private static final int DV_I_52_0_bit = 1 << 15;
	private static final int DV_II_45_0_bit = 1 << 16;
	private static final int DV_II_46_0_bit = 1 << 17;
	private static final int DV_II_46_2_bit = 1 << 18;
	private static final int DV_II_47_0_bit = 1 << 19;
	private static final int DV_II_48_0_bit = 1 << 20;
	private static final int DV_II_49_0_bit = 1 << 21;
	private static final int DV_II_49_2_bit = 1 << 22;
	private static final int DV_II_50_0_bit = 1 << 23;
	private static final int DV_II_50_2_bit = 1 << 24;
	private static final int DV_II_51_0_bit = 1 << 25;
	private static final int DV_II_51_2_bit = 1 << 26;
	private static final int DV_II_52_0_bit = 1 << 27;
	private static final int DV_II_53_0_bit = 1 << 28;
	private static final int DV_II_54_0_bit = 1 << 29;
	private static final int DV_II_55_0_bit = 1 << 30;
	private static final int DV_II_56_0_bit = 1 << 31;

	static int check(int[] w) {
		int mask = ~0;
		mask &= (((((w[44] ^ w[45]) >>> 29) & 1) - 1) | ~(DV_I_48_0_bit
				| DV_I_51_0_bit | DV_I_52_0_bit | DV_II_45_0_bit
				| DV_II_46_0_bit | DV_II_50_0_bit | DV_II_51_0_bit));
		mask &= (((((w[49] ^ w[50]) >>> 29) & 1) - 1)
				| ~(DV_I_46_0_bit | DV_II_45_0_bit | DV_II_50_0_bit
						| DV_II_51_0_bit | DV_II_55_0_bit | DV_II_56_0_bit));
		mask &= (((((w[48] ^ w[49]) >>> 29) & 1) - 1)
				| ~(DV_I_45_0_bit | DV_I_52_0_bit | DV_II_49_0_bit
						| DV_II_50_0_bit | DV_II_54_0_bit | DV_II_55_0_bit));
		mask &= ((((w[47] ^ (w[50] >>> 25)) & (1 << 4)) - (1 << 4))
				| ~(DV_I_47_0_bit | DV_I_49_0_bit | DV_I_51_0_bit
						| DV_II_45_0_bit | DV_II_51_0_bit | DV_II_56_0_bit));
		mask &= (((((w[47] ^ w[48]) >>> 29) & 1) - 1)
				| ~(DV_I_44_0_bit | DV_I_51_0_bit | DV_II_48_0_bit
						| DV_II_49_0_bit | DV_II_53_0_bit | DV_II_54_0_bit));
		mask &= (((((w[46] >>> 4) ^ (w[49] >>> 29)) & 1) - 1)
				| ~(DV_I_46_0_bit | DV_I_48_0_bit | DV_I_50_0_bit
						| DV_I_52_0_bit | DV_II_50_0_bit | DV_II_55_0_bit));
		mask &= (((((w[46] ^ w[47]) >>> 29) & 1) - 1)
				| ~(DV_I_43_0_bit | DV_I_50_0_bit | DV_II_47_0_bit
						| DV_II_48_0_bit | DV_II_52_0_bit | DV_II_53_0_bit));
		mask &= (((((w[45] >>> 4) ^ (w[48] >>> 29)) & 1) - 1)
				| ~(DV_I_45_0_bit | DV_I_47_0_bit | DV_I_49_0_bit
						| DV_I_51_0_bit | DV_II_49_0_bit | DV_II_54_0_bit));
		mask &= (((((w[45] ^ w[46]) >>> 29) & 1) - 1)
				| ~(DV_I_49_0_bit | DV_I_52_0_bit | DV_II_46_0_bit
						| DV_II_47_0_bit | DV_II_51_0_bit | DV_II_52_0_bit));
		mask &= (((((w[44] >>> 4) ^ (w[47] >>> 29)) & 1) - 1)
				| ~(DV_I_44_0_bit | DV_I_46_0_bit | DV_I_48_0_bit
						| DV_I_50_0_bit | DV_II_48_0_bit | DV_II_53_0_bit));
		mask &= (((((w[43] >>> 4) ^ (w[46] >>> 29)) & 1) - 1)
				| ~(DV_I_43_0_bit | DV_I_45_0_bit | DV_I_47_0_bit
						| DV_I_49_0_bit | DV_II_47_0_bit | DV_II_52_0_bit));
		mask &= (((((w[43] ^ w[44]) >>> 29) & 1) - 1)
				| ~(DV_I_47_0_bit | DV_I_50_0_bit | DV_I_51_0_bit
						| DV_II_45_0_bit | DV_II_49_0_bit | DV_II_50_0_bit));
		mask &= (((((w[42] >>> 4) ^ (w[45] >>> 29)) & 1) - 1)
				| ~(DV_I_44_0_bit | DV_I_46_0_bit | DV_I_48_0_bit
						| DV_I_52_0_bit | DV_II_46_0_bit | DV_II_51_0_bit));
		mask &= (((((w[41] >>> 4) ^ (w[44] >>> 29)) & 1) - 1)
				| ~(DV_I_43_0_bit | DV_I_45_0_bit | DV_I_47_0_bit
						| DV_I_51_0_bit | DV_II_45_0_bit | DV_II_50_0_bit));
		mask &= (((((w[40] ^ w[41]) >>> 29) & 1) - 1)
				| ~(DV_I_44_0_bit | DV_I_47_0_bit | DV_I_48_0_bit
						| DV_II_46_0_bit | DV_II_47_0_bit | DV_II_56_0_bit));
		mask &= (((((w[54] ^ w[55]) >>> 29) & 1) - 1)
				| ~(DV_I_51_0_bit | DV_II_47_0_bit | DV_II_50_0_bit
						| DV_II_55_0_bit | DV_II_56_0_bit));
		mask &= (((((w[53] ^ w[54]) >>> 29) & 1) - 1)
				| ~(DV_I_50_0_bit | DV_II_46_0_bit | DV_II_49_0_bit
						| DV_II_54_0_bit | DV_II_55_0_bit));
		mask &= (((((w[52] ^ w[53]) >>> 29) & 1) - 1)
				| ~(DV_I_49_0_bit | DV_II_45_0_bit | DV_II_48_0_bit
						| DV_II_53_0_bit | DV_II_54_0_bit));
		mask &= ((((w[50] ^ (w[53] >>> 25)) & (1 << 4)) - (1 << 4))
				| ~(DV_I_50_0_bit | DV_I_52_0_bit | DV_II_46_0_bit
						| DV_II_48_0_bit | DV_II_54_0_bit));
		mask &= (((((w[50] ^ w[51]) >>> 29) & 1) - 1)
				| ~(DV_I_47_0_bit | DV_II_46_0_bit | DV_II_51_0_bit
						| DV_II_52_0_bit | DV_II_56_0_bit));
		mask &= ((((w[49] ^ (w[52] >>> 25)) & (1 << 4)) - (1 << 4))
				| ~(DV_I_49_0_bit | DV_I_51_0_bit | DV_II_45_0_bit
						| DV_II_47_0_bit | DV_II_53_0_bit));
		mask &= ((((w[48] ^ (w[51] >>> 25)) & (1 << 4)) - (1 << 4))
				| ~(DV_I_48_0_bit | DV_I_50_0_bit | DV_I_52_0_bit
						| DV_II_46_0_bit | DV_II_52_0_bit));
		mask &= (((((w[42] ^ w[43]) >>> 29) & 1) - 1)
				| ~(DV_I_46_0_bit | DV_I_49_0_bit | DV_I_50_0_bit
						| DV_II_48_0_bit | DV_II_49_0_bit));
		mask &= (((((w[41] ^ w[42]) >>> 29) & 1) - 1)
				| ~(DV_I_45_0_bit | DV_I_48_0_bit | DV_I_49_0_bit
						| DV_II_47_0_bit | DV_II_48_0_bit));
		mask &= (((((w[40] >>> 4) ^ (w[43] >>> 29)) & 1) - 1)
				| ~(DV_I_44_0_bit | DV_I_46_0_bit | DV_I_50_0_bit
						| DV_II_49_0_bit | DV_II_56_0_bit));
		mask &= (((((w[39] >>> 4) ^ (w[42] >>> 29)) & 1) - 1)
				| ~(DV_I_43_0_bit | DV_I_45_0_bit | DV_I_49_0_bit
						| DV_II_48_0_bit | DV_II_55_0_bit));
		if ((mask & (DV_I_44_0_bit | DV_I_48_0_bit | DV_II_47_0_bit
				| DV_II_54_0_bit | DV_II_56_0_bit)) != 0)
			mask &= (((((w[38] >>> 4) ^ (w[41] >>> 29)) & 1) - 1)
					| ~(DV_I_44_0_bit | DV_I_48_0_bit | DV_II_47_0_bit
							| DV_II_54_0_bit | DV_II_56_0_bit));
		mask &= (((((w[37] >>> 4) ^ (w[40] >>> 29)) & 1) - 1)
				| ~(DV_I_43_0_bit | DV_I_47_0_bit | DV_II_46_0_bit
						| DV_II_53_0_bit | DV_II_55_0_bit));
		if ((mask & (DV_I_52_0_bit | DV_II_48_0_bit | DV_II_51_0_bit
				| DV_II_56_0_bit)) != 0)
			mask &= (((((w[55] ^ w[56]) >>> 29) & 1) - 1) | ~(DV_I_52_0_bit
					| DV_II_48_0_bit | DV_II_51_0_bit | DV_II_56_0_bit));
		if ((mask & (DV_I_52_0_bit | DV_II_48_0_bit | DV_II_50_0_bit
				| DV_II_56_0_bit)) != 0)
			mask &= ((((w[52] ^ (w[55] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_I_52_0_bit | DV_II_48_0_bit | DV_II_50_0_bit
							| DV_II_56_0_bit));
		if ((mask & (DV_I_51_0_bit | DV_II_47_0_bit | DV_II_49_0_bit
				| DV_II_55_0_bit)) != 0)
			mask &= ((((w[51] ^ (w[54] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_I_51_0_bit | DV_II_47_0_bit | DV_II_49_0_bit
							| DV_II_55_0_bit));
		if ((mask & (DV_I_48_0_bit | DV_II_47_0_bit | DV_II_52_0_bit
				| DV_II_53_0_bit)) != 0)
			mask &= (((((w[51] ^ w[52]) >>> 29) & 1) - 1) | ~(DV_I_48_0_bit
					| DV_II_47_0_bit | DV_II_52_0_bit | DV_II_53_0_bit));
		if ((mask & (DV_I_46_0_bit | DV_I_49_0_bit | DV_II_45_0_bit
				| DV_II_48_0_bit)) != 0)
			mask &= (((((w[36] >>> 4) ^ (w[40] >>> 29)) & 1) - 1)
					| ~(DV_I_46_0_bit | DV_I_49_0_bit | DV_II_45_0_bit
							| DV_II_48_0_bit));
		if ((mask & (DV_I_52_0_bit | DV_II_48_0_bit | DV_II_49_0_bit)) != 0)
			mask &= ((0 - (((w[53] ^ w[56]) >>> 29) & 1))
					| ~(DV_I_52_0_bit | DV_II_48_0_bit | DV_II_49_0_bit));
		if ((mask & (DV_I_50_0_bit | DV_II_46_0_bit | DV_II_47_0_bit)) != 0)
			mask &= ((0 - (((w[51] ^ w[54]) >>> 29) & 1))
					| ~(DV_I_50_0_bit | DV_II_46_0_bit | DV_II_47_0_bit));
		if ((mask & (DV_I_49_0_bit | DV_I_51_0_bit | DV_II_45_0_bit)) != 0)
			mask &= ((0 - (((w[50] ^ w[52]) >>> 29) & 1))
					| ~(DV_I_49_0_bit | DV_I_51_0_bit | DV_II_45_0_bit));
		if ((mask & (DV_I_48_0_bit | DV_I_50_0_bit | DV_I_52_0_bit)) != 0)
			mask &= ((0 - (((w[49] ^ w[51]) >>> 29) & 1))
					| ~(DV_I_48_0_bit | DV_I_50_0_bit | DV_I_52_0_bit));
		if ((mask & (DV_I_47_0_bit | DV_I_49_0_bit | DV_I_51_0_bit)) != 0)
			mask &= ((0 - (((w[48] ^ w[50]) >>> 29) & 1))
					| ~(DV_I_47_0_bit | DV_I_49_0_bit | DV_I_51_0_bit));
		if ((mask & (DV_I_46_0_bit | DV_I_48_0_bit | DV_I_50_0_bit)) != 0)
			mask &= ((0 - (((w[47] ^ w[49]) >>> 29) & 1))
					| ~(DV_I_46_0_bit | DV_I_48_0_bit | DV_I_50_0_bit));
		if ((mask & (DV_I_45_0_bit | DV_I_47_0_bit | DV_I_49_0_bit)) != 0)
			mask &= ((0 - (((w[46] ^ w[48]) >>> 29) & 1))
					| ~(DV_I_45_0_bit | DV_I_47_0_bit | DV_I_49_0_bit));
		mask &= ((((w[45] ^ w[47]) & (1 << 6)) - (1 << 6))
				| ~(DV_I_47_2_bit | DV_I_49_2_bit | DV_I_51_2_bit));
		if ((mask & (DV_I_44_0_bit | DV_I_46_0_bit | DV_I_48_0_bit)) != 0)
			mask &= ((0 - (((w[45] ^ w[47]) >>> 29) & 1))
					| ~(DV_I_44_0_bit | DV_I_46_0_bit | DV_I_48_0_bit));
		mask &= (((((w[44] ^ w[46]) >>> 6) & 1) - 1)
				| ~(DV_I_46_2_bit | DV_I_48_2_bit | DV_I_50_2_bit));
		if ((mask & (DV_I_43_0_bit | DV_I_45_0_bit | DV_I_47_0_bit)) != 0)
			mask &= ((0 - (((w[44] ^ w[46]) >>> 29) & 1))
					| ~(DV_I_43_0_bit | DV_I_45_0_bit | DV_I_47_0_bit));
		mask &= ((0 - ((w[41] ^ (w[42] >>> 5)) & (1 << 1)))
				| ~(DV_I_48_2_bit | DV_II_46_2_bit | DV_II_51_2_bit));
		mask &= ((0 - ((w[40] ^ (w[41] >>> 5)) & (1 << 1)))
				| ~(DV_I_47_2_bit | DV_I_51_2_bit | DV_II_50_2_bit));
		if ((mask & (DV_I_44_0_bit | DV_I_46_0_bit | DV_II_56_0_bit)) != 0)
			mask &= ((0 - (((w[40] ^ w[42]) >>> 4) & 1))
					| ~(DV_I_44_0_bit | DV_I_46_0_bit | DV_II_56_0_bit));
		mask &= ((0 - ((w[39] ^ (w[40] >>> 5)) & (1 << 1)))
				| ~(DV_I_46_2_bit | DV_I_50_2_bit | DV_II_49_2_bit));
		if ((mask & (DV_I_43_0_bit | DV_I_45_0_bit | DV_II_55_0_bit)) != 0)
			mask &= ((0 - (((w[39] ^ w[41]) >>> 4) & 1))
					| ~(DV_I_43_0_bit | DV_I_45_0_bit | DV_II_55_0_bit));
		if ((mask & (DV_I_44_0_bit | DV_II_54_0_bit | DV_II_56_0_bit)) != 0)
			mask &= ((0 - (((w[38] ^ w[40]) >>> 4) & 1))
					| ~(DV_I_44_0_bit | DV_II_54_0_bit | DV_II_56_0_bit));
		if ((mask & (DV_I_43_0_bit | DV_II_53_0_bit | DV_II_55_0_bit)) != 0)
			mask &= ((0 - (((w[37] ^ w[39]) >>> 4) & 1))
					| ~(DV_I_43_0_bit | DV_II_53_0_bit | DV_II_55_0_bit));
		mask &= ((0 - ((w[36] ^ (w[37] >>> 5)) & (1 << 1)))
				| ~(DV_I_47_2_bit | DV_I_50_2_bit | DV_II_46_2_bit));
		if ((mask & (DV_I_45_0_bit | DV_I_48_0_bit | DV_II_47_0_bit)) != 0)
			mask &= (((((w[35] >>> 4) ^ (w[39] >>> 29)) & 1) - 1)
					| ~(DV_I_45_0_bit | DV_I_48_0_bit | DV_II_47_0_bit));
		if ((mask & (DV_I_48_0_bit | DV_II_48_0_bit)) != 0)
			mask &= ((0 - ((w[63] ^ (w[64] >>> 5)) & (1 << 0)))
					| ~(DV_I_48_0_bit | DV_II_48_0_bit));
		if ((mask & (DV_I_45_0_bit | DV_II_45_0_bit)) != 0)
			mask &= ((0 - ((w[63] ^ (w[64] >>> 5)) & (1 << 1)))
					| ~(DV_I_45_0_bit | DV_II_45_0_bit));
		if ((mask & (DV_I_47_0_bit | DV_II_47_0_bit)) != 0)
			mask &= ((0 - ((w[62] ^ (w[63] >>> 5)) & (1 << 0)))
					| ~(DV_I_47_0_bit | DV_II_47_0_bit));
		if ((mask & (DV_I_46_0_bit | DV_II_46_0_bit)) != 0)
			mask &= ((0 - ((w[61] ^ (w[62] >>> 5)) & (1 << 0)))
					| ~(DV_I_46_0_bit | DV_II_46_0_bit));
		mask &= ((0 - ((w[61] ^ (w[62] >>> 5)) & (1 << 2)))
				| ~(DV_I_46_2_bit | DV_II_46_2_bit));
		if ((mask & (DV_I_45_0_bit | DV_II_45_0_bit)) != 0)
			mask &= ((0 - ((w[60] ^ (w[61] >>> 5)) & (1 << 0)))
					| ~(DV_I_45_0_bit | DV_II_45_0_bit));
		if ((mask & (DV_II_51_0_bit | DV_II_54_0_bit)) != 0)
			mask &= (((((w[58] ^ w[59]) >>> 29) & 1) - 1)
					| ~(DV_II_51_0_bit | DV_II_54_0_bit));
		if ((mask & (DV_II_50_0_bit | DV_II_53_0_bit)) != 0)
			mask &= (((((w[57] ^ w[58]) >>> 29) & 1) - 1)
					| ~(DV_II_50_0_bit | DV_II_53_0_bit));
		if ((mask & (DV_II_52_0_bit | DV_II_54_0_bit)) != 0)
			mask &= ((((w[56] ^ (w[59] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_II_52_0_bit | DV_II_54_0_bit));
		if ((mask & (DV_II_51_0_bit | DV_II_52_0_bit)) != 0)
			mask &= ((0 - (((w[56] ^ w[59]) >>> 29) & 1))
					| ~(DV_II_51_0_bit | DV_II_52_0_bit));
		if ((mask & (DV_II_49_0_bit | DV_II_52_0_bit)) != 0)
			mask &= (((((w[56] ^ w[57]) >>> 29) & 1) - 1)
					| ~(DV_II_49_0_bit | DV_II_52_0_bit));
		if ((mask & (DV_II_51_0_bit | DV_II_53_0_bit)) != 0)
			mask &= ((((w[55] ^ (w[58] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_II_51_0_bit | DV_II_53_0_bit));
		if ((mask & (DV_II_50_0_bit | DV_II_52_0_bit)) != 0)
			mask &= ((((w[54] ^ (w[57] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_II_50_0_bit | DV_II_52_0_bit));
		if ((mask & (DV_II_49_0_bit | DV_II_51_0_bit)) != 0)
			mask &= ((((w[53] ^ (w[56] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_II_49_0_bit | DV_II_51_0_bit));
		mask &= ((((w[51] ^ (w[50] >>> 5)) & (1 << 1)) - (1 << 1))
				| ~(DV_I_50_2_bit | DV_II_46_2_bit));
		mask &= ((((w[48] ^ w[50]) & (1 << 6)) - (1 << 6))
				| ~(DV_I_50_2_bit | DV_II_46_2_bit));
		if ((mask & (DV_I_51_0_bit | DV_I_52_0_bit)) != 0)
			mask &= ((0 - (((w[48] ^ w[55]) >>> 29) & 1))
					| ~(DV_I_51_0_bit | DV_I_52_0_bit));
		mask &= ((((w[47] ^ w[49]) & (1 << 6)) - (1 << 6))
				| ~(DV_I_49_2_bit | DV_I_51_2_bit));
		mask &= ((((w[48] ^ (w[47] >>> 5)) & (1 << 1)) - (1 << 1))
				| ~(DV_I_47_2_bit | DV_II_51_2_bit));
		mask &= ((((w[46] ^ w[48]) & (1 << 6)) - (1 << 6))
				| ~(DV_I_48_2_bit | DV_I_50_2_bit));
		mask &= ((((w[47] ^ (w[46] >>> 5)) & (1 << 1)) - (1 << 1))
				| ~(DV_I_46_2_bit | DV_II_50_2_bit));
		mask &= ((0 - ((w[44] ^ (w[45] >>> 5)) & (1 << 1)))
				| ~(DV_I_51_2_bit | DV_II_49_2_bit));
		mask &= ((((w[43] ^ w[45]) & (1 << 6)) - (1 << 6))
				| ~(DV_I_47_2_bit | DV_I_49_2_bit));
		mask &= (((((w[42] ^ w[44]) >>> 6) & 1) - 1)
				| ~(DV_I_46_2_bit | DV_I_48_2_bit));
		mask &= ((((w[43] ^ (w[42] >>> 5)) & (1 << 1)) - (1 << 1))
				| ~(DV_II_46_2_bit | DV_II_51_2_bit));
		mask &= ((((w[42] ^ (w[41] >>> 5)) & (1 << 1)) - (1 << 1))
				| ~(DV_I_51_2_bit | DV_II_50_2_bit));
		mask &= ((((w[41] ^ (w[40] >>> 5)) & (1 << 1)) - (1 << 1))
				| ~(DV_I_50_2_bit | DV_II_49_2_bit));
		if ((mask & (DV_I_52_0_bit | DV_II_51_0_bit)) != 0)
			mask &= ((((w[39] ^ (w[43] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_I_52_0_bit | DV_II_51_0_bit));
		if ((mask & (DV_I_51_0_bit | DV_II_50_0_bit)) != 0)
			mask &= ((((w[38] ^ (w[42] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_I_51_0_bit | DV_II_50_0_bit));
		if ((mask & (DV_I_48_2_bit | DV_I_51_2_bit)) != 0)
			mask &= ((0 - ((w[37] ^ (w[38] >>> 5)) & (1 << 1)))
					| ~(DV_I_48_2_bit | DV_I_51_2_bit));
		if ((mask & (DV_I_50_0_bit | DV_II_49_0_bit)) != 0)
			mask &= ((((w[37] ^ (w[41] >>> 25)) & (1 << 4)) - (1 << 4))
					| ~(DV_I_50_0_bit | DV_II_49_0_bit));
		if ((mask & (DV_II_52_0_bit | DV_II_54_0_bit)) != 0)
			mask &= ((0 - ((w[36] ^ w[38]) & (1 << 4)))
					| ~(DV_II_52_0_bit | DV_II_54_0_bit));
		mask &= ((0 - ((w[35] ^ (w[36] >>> 5)) & (1 << 1)))
				| ~(DV_I_46_2_bit | DV_I_49_2_bit));
		if ((mask & (DV_I_51_0_bit | DV_II_47_0_bit)) != 0)
			mask &= ((((w[35] ^ (w[39] >>> 25)) & (1 << 3)) - (1 << 3))
					| ~(DV_I_51_0_bit | DV_II_47_0_bit));

		if (mask == 0) {
			return mask;
		}

		if ((mask & DV_I_43_0_bit) != 0)
			if (0 == ((w[61] ^ (w[62] >>> 5)) & (1 << 1))
					|| 0 != ((w[59] ^ (w[63] >>> 25)) & (1 << 5))
					|| 0 == ((w[58] ^ (w[63] >>> 30)) & (1 << 0)))
				mask &= ~DV_I_43_0_bit;
		if ((mask & DV_I_44_0_bit) != 0)
			if (0 == ((w[62] ^ (w[63] >>> 5)) & (1 << 1))
					|| 0 != ((w[60] ^ (w[64] >>> 25)) & (1 << 5))
					|| 0 == ((w[59] ^ (w[64] >>> 30)) & (1 << 0)))
				mask &= ~DV_I_44_0_bit;
		if ((mask & DV_I_46_2_bit) != 0)
			mask &= ((~((w[40] ^ w[42]) >>> 2)) | ~DV_I_46_2_bit);
		if ((mask & DV_I_47_2_bit) != 0)
			if (0 == ((w[62] ^ (w[63] >>> 5)) & (1 << 2))
					|| 0 != ((w[41] ^ w[43]) & (1 << 6)))
				mask &= ~DV_I_47_2_bit;
		if ((mask & DV_I_48_2_bit) != 0)
			if (0 == ((w[63] ^ (w[64] >>> 5)) & (1 << 2))
					|| 0 != ((w[48] ^ (w[49] << 5)) & (1 << 6)))
				mask &= ~DV_I_48_2_bit;
		if ((mask & DV_I_49_2_bit) != 0)
			if (0 != ((w[49] ^ (w[50] << 5)) & (1 << 6))
					|| 0 == ((w[42] ^ w[50]) & (1 << 1))
					|| 0 != ((w[39] ^ (w[40] << 5)) & (1 << 6))
					|| 0 == ((w[38] ^ w[40]) & (1 << 1)))
				mask &= ~DV_I_49_2_bit;
		if ((mask & DV_I_50_0_bit) != 0)
			mask &= ((((w[36] ^ w[37]) << 7)) | ~DV_I_50_0_bit);
		if ((mask & DV_I_50_2_bit) != 0)
			mask &= ((((w[43] ^ w[51]) << 11)) | ~DV_I_50_2_bit);
		if ((mask & DV_I_51_0_bit) != 0)
			mask &= ((((w[37] ^ w[38]) << 9)) | ~DV_I_51_0_bit);
		if ((mask & DV_I_51_2_bit) != 0)
			if (0 != ((w[51] ^ (w[52] << 5)) & (1 << 6))
					|| 0 != ((w[49] ^ w[51]) & (1 << 6))
					|| 0 != ((w[37] ^ (w[37] >>> 5)) & (1 << 1))
					|| 0 != ((w[35] ^ (w[39] >>> 25)) & (1 << 5)))
				mask &= ~DV_I_51_2_bit;
		if ((mask & DV_I_52_0_bit) != 0)
			mask &= ((((w[38] ^ w[39]) << 11)) | ~DV_I_52_0_bit);
		if ((mask & DV_II_46_2_bit) != 0)
			mask &= ((((w[47] ^ w[51]) << 17)) | ~DV_II_46_2_bit);
		if ((mask & DV_II_48_0_bit) != 0)
			if (0 != ((w[36] ^ (w[40] >>> 25)) & (1 << 3))
					|| 0 == ((w[35] ^ (w[40] << 2)) & (1 << 30)))
				mask &= ~DV_II_48_0_bit;
		if ((mask & DV_II_49_0_bit) != 0)
			if (0 != ((w[37] ^ (w[41] >>> 25)) & (1 << 3))
					|| 0 == ((w[36] ^ (w[41] << 2)) & (1 << 30)))
				mask &= ~DV_II_49_0_bit;
		if ((mask & DV_II_49_2_bit) != 0)
			if (0 != ((w[53] ^ (w[54] << 5)) & (1 << 6))
					|| 0 != ((w[51] ^ w[53]) & (1 << 6))
					|| 0 == ((w[50] ^ w[54]) & (1 << 1))
					|| 0 != ((w[45] ^ (w[46] << 5)) & (1 << 6))
					|| 0 != ((w[37] ^ (w[41] >>> 25)) & (1 << 5))
					|| 0 == ((w[36] ^ (w[41] >>> 30)) & (1 << 0)))
				mask &= ~DV_II_49_2_bit;
		if ((mask & DV_II_50_0_bit) != 0)
			if (0 == ((w[55] ^ w[58]) & (1 << 29))
					|| 0 != ((w[38] ^ (w[42] >>> 25)) & (1 << 3))
					|| 0 == ((w[37] ^ (w[42] << 2)) & (1 << 30)))
				mask &= ~DV_II_50_0_bit;
		if ((mask & DV_II_50_2_bit) != 0)
			if (0 != ((w[54] ^ (w[55] << 5)) & (1 << 6))
					|| 0!=((w[52] ^ w[54]) & (1 << 6))
					|| 0==((w[51] ^ w[55]) & (1 << 1))
					|| 0==((w[45] ^ w[47]) & (1 << 1))
					|| 0!=((w[38] ^ (w[42] >>> 25)) & (1 << 5))
					|| 0==((w[37] ^ (w[42] >>> 30)) & (1 << 0)))
				mask &= ~DV_II_50_2_bit;
		if ((mask & DV_II_51_0_bit) != 0)
			if (0 != ((w[39] ^ (w[43] >>> 25)) & (1 << 3))
					|| 0 == ((w[38] ^ (w[43] << 2)) & (1 << 30)))
				mask &= ~DV_II_51_0_bit;
		if ((mask & DV_II_51_2_bit) != 0)
			if (0 != ((w[55] ^ (w[56] << 5)) & (1 << 6))
					|| 0 != ((w[53] ^ w[55]) & (1 << 6))
					|| 0 == ((w[52] ^ w[56]) & (1 << 1))
					|| 0 == ((w[46] ^ w[48]) & (1 << 1))
					|| 0 != ((w[39] ^ (w[43] >>> 25)) & (1 << 5))
					|| 0 == ((w[38] ^ (w[43] >>> 30)) & (1 << 0)))
				mask &= ~DV_II_51_2_bit;
		if ((mask & DV_II_52_0_bit) != 0)
			if (0 != ((w[59] ^ w[60]) & (1 << 29))
					|| 0 != ((w[40] ^ (w[44] >>> 25)) & (1 << 3))
					|| 0 != ((w[40] ^ (w[44] >>> 25)) & (1 << 4))
					|| 0==((w[39] ^ (w[44] << 2)) & (1 << 30)))
				mask &= ~DV_II_52_0_bit;
		if ((mask & DV_II_53_0_bit) != 0)
			if (0==((w[58] ^ w[61]) & (1 << 29))
					|| 0!=((w[57] ^ (w[61] >>> 25)) & (1 << 4))
					|| 0!=((w[41] ^ (w[45] >>> 25)) & (1 << 3))
					|| 0!=((w[41] ^ (w[45] >>> 25)) & (1 << 4)))
				mask &= ~DV_II_53_0_bit;
		if ((mask & DV_II_54_0_bit) != 0)
			if (0 != ((w[58] ^ (w[62] >>> 25)) & (1 << 4))
					|| 0 != ((w[42] ^ (w[46] >>> 25)) & (1 << 3))
					|| 0 != ((w[42] ^ (w[46] >>> 25)) & (1 << 4)))
				mask &= ~DV_II_54_0_bit;
		if ((mask & DV_II_55_0_bit) != 0)
			if (0 != ((w[59] ^ (w[63] >>> 25)) & (1 << 4))
					|| 0 != ((w[57] ^ (w[59] >>> 25)) & (1 << 4))
					|| 0 != ((w[43] ^ (w[47] >>> 25)) & (1 << 3))
					|| 0 != ((w[43] ^ (w[47] >>> 25)) & (1 << 4)))
				mask &= ~DV_II_55_0_bit;
		if ((mask & DV_II_56_0_bit) != 0)
			if (0 != ((w[60] ^ (w[64] >>> 25)) & (1 << 4))
					|| 0 != ((w[44] ^ (w[48] >>> 25)) & (1 << 3))
					|| 0 != ((w[44] ^ (w[48] >>> 25)) & (1 << 4)))
				mask &= ~DV_II_56_0_bit;
		return mask;
	}

	private UbcCheck() {
	}

	static final class DvInfo {
		final int testt;
		final int maskb;
		final int[] dm;

		@SuppressWarnings("unused")
		DvInfo(int dvType, int dvK, int dvB, int testt, int maskb, int[] dm) {
			this.testt = testt;
			this.maskb = maskb;
			this.dm = dm;

			// Only states 58 and 65 are saved.
			if (testt != 58 && testt != 65) {
				throw new IllegalArgumentException();
			}
		}
	}

	static final DvInfo[] DV = new DvInfo[] {
			new DvInfo(1, 43, 0, 58, 0, new int[] { 0x08000000, 0x9800000c,
					0xd8000010, 0x08000010, 0xb8000010, 0x98000000, 0x60000000,
					0x00000008, 0xc0000000, 0x90000014, 0x10000010, 0xb8000014,
					0x28000000, 0x20000010, 0x48000000, 0x08000018, 0x60000000,
					0x90000010, 0xf0000010, 0x90000008, 0xc0000000, 0x90000010,
					0xf0000010, 0xb0000008, 0x40000000, 0x90000000, 0xf0000010,
					0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000,
					0x80000000, 0x00000010, 0xa0000000, 0x20000000, 0xa0000000,
					0x20000010, 0x00000000, 0x20000010, 0x20000000, 0x00000010,
					0x20000000, 0x00000010, 0xa0000000, 0x00000000, 0x20000000,
					0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000001, 0x00000020, 0x00000001, 0x40000002,
					0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006,
					0x00000049, 0x00000103, 0x80000009, 0x80000012, 0x80000202,
					0x00000018, 0x00000164, 0x00000408, 0x800000e6, 0x8000004c,
					0x00000803, 0x80000161, 0x80000599 }),
			new DvInfo(1, 44, 0, 58, 1, new int[] { 0xb4000008, 0x08000000,
					0x9800000c, 0xd8000010, 0x08000010, 0xb8000010, 0x98000000,
					0x60000000, 0x00000008, 0xc0000000, 0x90000014, 0x10000010,
					0xb8000014, 0x28000000, 0x20000010, 0x48000000, 0x08000018,
					0x60000000, 0x90000010, 0xf0000010, 0x90000008, 0xc0000000,
					0x90000010, 0xf0000010, 0xb0000008, 0x40000000, 0x90000000,
					0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010,
					0x90000000, 0x80000000, 0x00000010, 0xa0000000, 0x20000000,
					0xa0000000, 0x20000010, 0x00000000, 0x20000010, 0x20000000,
					0x00000010, 0x20000000, 0x00000010, 0xa0000000, 0x00000000,
					0x20000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000001, 0x00000020, 0x00000001,
					0x40000002, 0x40000040, 0x40000002, 0x80000004, 0x80000080,
					0x80000006, 0x00000049, 0x00000103, 0x80000009, 0x80000012,
					0x80000202, 0x00000018, 0x00000164, 0x00000408, 0x800000e6,
					0x8000004c, 0x00000803, 0x80000161 }),
			new DvInfo(1, 45, 0, 58, 2, new int[] { 0xf4000014, 0xb4000008,
					0x08000000, 0x9800000c, 0xd8000010, 0x08000010, 0xb8000010,
					0x98000000, 0x60000000, 0x00000008, 0xc0000000, 0x90000014,
					0x10000010, 0xb8000014, 0x28000000, 0x20000010, 0x48000000,
					0x08000018, 0x60000000, 0x90000010, 0xf0000010, 0x90000008,
					0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000,
					0x90000000, 0xf0000010, 0x90000018, 0x60000000, 0x90000010,
					0x90000010, 0x90000000, 0x80000000, 0x00000010, 0xa0000000,
					0x20000000, 0xa0000000, 0x20000010, 0x00000000, 0x20000010,
					0x20000000, 0x00000010, 0x20000000, 0x00000010, 0xa0000000,
					0x00000000, 0x20000000, 0x20000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000020,
					0x00000001, 0x40000002, 0x40000040, 0x40000002, 0x80000004,
					0x80000080, 0x80000006, 0x00000049, 0x00000103, 0x80000009,
					0x80000012, 0x80000202, 0x00000018, 0x00000164, 0x00000408,
					0x800000e6, 0x8000004c, 0x00000803 }),
			new DvInfo(1, 46, 0, 58, 3, new int[] { 0x2c000010, 0xf4000014,
					0xb4000008, 0x08000000, 0x9800000c, 0xd8000010, 0x08000010,
					0xb8000010, 0x98000000, 0x60000000, 0x00000008, 0xc0000000,
					0x90000014, 0x10000010, 0xb8000014, 0x28000000, 0x20000010,
					0x48000000, 0x08000018, 0x60000000, 0x90000010, 0xf0000010,
					0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008,
					0x40000000, 0x90000000, 0xf0000010, 0x90000018, 0x60000000,
					0x90000010, 0x90000010, 0x90000000, 0x80000000, 0x00000010,
					0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0x00000000,
					0x20000010, 0x20000000, 0x00000010, 0x20000000, 0x00000010,
					0xa0000000, 0x00000000, 0x20000000, 0x20000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
					0x00000020, 0x00000001, 0x40000002, 0x40000040, 0x40000002,
					0x80000004, 0x80000080, 0x80000006, 0x00000049, 0x00000103,
					0x80000009, 0x80000012, 0x80000202, 0x00000018, 0x00000164,
					0x00000408, 0x800000e6, 0x8000004c }),
			new DvInfo(1, 46, 2, 58, 4, new int[] { 0xb0000040, 0xd0000053,
					0xd0000022, 0x20000000, 0x60000032, 0x60000043, 0x20000040,
					0xe0000042, 0x60000002, 0x80000001, 0x00000020, 0x00000003,
					0x40000052, 0x40000040, 0xe0000052, 0xa0000000, 0x80000040,
					0x20000001, 0x20000060, 0x80000001, 0x40000042, 0xc0000043,
					0x40000022, 0x00000003, 0x40000042, 0xc0000043, 0xc0000022,
					0x00000001, 0x40000002, 0xc0000043, 0x40000062, 0x80000001,
					0x40000042, 0x40000042, 0x40000002, 0x00000002, 0x00000040,
					0x80000002, 0x80000000, 0x80000002, 0x80000040, 0x00000000,
					0x80000040, 0x80000000, 0x00000040, 0x80000000, 0x00000040,
					0x80000002, 0x00000000, 0x80000000, 0x80000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004,
					0x00000080, 0x00000004, 0x00000009, 0x00000101, 0x00000009,
					0x00000012, 0x00000202, 0x0000001a, 0x00000124, 0x0000040c,
					0x00000026, 0x0000004a, 0x0000080a, 0x00000060, 0x00000590,
					0x00001020, 0x0000039a, 0x00000132 }),
			new DvInfo(1, 47, 0, 58, 5, new int[] { 0xc8000010, 0x2c000010,
					0xf4000014, 0xb4000008, 0x08000000, 0x9800000c, 0xd8000010,
					0x08000010, 0xb8000010, 0x98000000, 0x60000000, 0x00000008,
					0xc0000000, 0x90000014, 0x10000010, 0xb8000014, 0x28000000,
					0x20000010, 0x48000000, 0x08000018, 0x60000000, 0x90000010,
					0xf0000010, 0x90000008, 0xc0000000, 0x90000010, 0xf0000010,
					0xb0000008, 0x40000000, 0x90000000, 0xf0000010, 0x90000018,
					0x60000000, 0x90000010, 0x90000010, 0x90000000, 0x80000000,
					0x00000010, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010,
					0x00000000, 0x20000010, 0x20000000, 0x00000010, 0x20000000,
					0x00000010, 0xa0000000, 0x00000000, 0x20000000, 0x20000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000001, 0x00000020, 0x00000001, 0x40000002, 0x40000040,
					0x40000002, 0x80000004, 0x80000080, 0x80000006, 0x00000049,
					0x00000103, 0x80000009, 0x80000012, 0x80000202, 0x00000018,
					0x00000164, 0x00000408, 0x800000e6 }),
			new DvInfo(1, 47, 2, 58, 6, new int[] { 0x20000043, 0xb0000040,
					0xd0000053, 0xd0000022, 0x20000000, 0x60000032, 0x60000043,
					0x20000040, 0xe0000042, 0x60000002, 0x80000001, 0x00000020,
					0x00000003, 0x40000052, 0x40000040, 0xe0000052, 0xa0000000,
					0x80000040, 0x20000001, 0x20000060, 0x80000001, 0x40000042,
					0xc0000043, 0x40000022, 0x00000003, 0x40000042, 0xc0000043,
					0xc0000022, 0x00000001, 0x40000002, 0xc0000043, 0x40000062,
					0x80000001, 0x40000042, 0x40000042, 0x40000002, 0x00000002,
					0x00000040, 0x80000002, 0x80000000, 0x80000002, 0x80000040,
					0x00000000, 0x80000040, 0x80000000, 0x00000040, 0x80000000,
					0x00000040, 0x80000002, 0x00000000, 0x80000000, 0x80000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000004, 0x00000080, 0x00000004, 0x00000009, 0x00000101,
					0x00000009, 0x00000012, 0x00000202, 0x0000001a, 0x00000124,
					0x0000040c, 0x00000026, 0x0000004a, 0x0000080a, 0x00000060,
					0x00000590, 0x00001020, 0x0000039a }),
			new DvInfo(1, 48, 0, 58, 7, new int[] { 0xb800000a, 0xc8000010,
					0x2c000010, 0xf4000014, 0xb4000008, 0x08000000, 0x9800000c,
					0xd8000010, 0x08000010, 0xb8000010, 0x98000000, 0x60000000,
					0x00000008, 0xc0000000, 0x90000014, 0x10000010, 0xb8000014,
					0x28000000, 0x20000010, 0x48000000, 0x08000018, 0x60000000,
					0x90000010, 0xf0000010, 0x90000008, 0xc0000000, 0x90000010,
					0xf0000010, 0xb0000008, 0x40000000, 0x90000000, 0xf0000010,
					0x90000018, 0x60000000, 0x90000010, 0x90000010, 0x90000000,
					0x80000000, 0x00000010, 0xa0000000, 0x20000000, 0xa0000000,
					0x20000010, 0x00000000, 0x20000010, 0x20000000, 0x00000010,
					0x20000000, 0x00000010, 0xa0000000, 0x00000000, 0x20000000,
					0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000001, 0x00000020, 0x00000001, 0x40000002,
					0x40000040, 0x40000002, 0x80000004, 0x80000080, 0x80000006,
					0x00000049, 0x00000103, 0x80000009, 0x80000012, 0x80000202,
					0x00000018, 0x00000164, 0x00000408 }),
			new DvInfo(1, 48, 2, 58, 8, new int[] { 0xe000002a, 0x20000043,
					0xb0000040, 0xd0000053, 0xd0000022, 0x20000000, 0x60000032,
					0x60000043, 0x20000040, 0xe0000042, 0x60000002, 0x80000001,
					0x00000020, 0x00000003, 0x40000052, 0x40000040, 0xe0000052,
					0xa0000000, 0x80000040, 0x20000001, 0x20000060, 0x80000001,
					0x40000042, 0xc0000043, 0x40000022, 0x00000003, 0x40000042,
					0xc0000043, 0xc0000022, 0x00000001, 0x40000002, 0xc0000043,
					0x40000062, 0x80000001, 0x40000042, 0x40000042, 0x40000002,
					0x00000002, 0x00000040, 0x80000002, 0x80000000, 0x80000002,
					0x80000040, 0x00000000, 0x80000040, 0x80000000, 0x00000040,
					0x80000000, 0x00000040, 0x80000002, 0x00000000, 0x80000000,
					0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000004, 0x00000080, 0x00000004, 0x00000009,
					0x00000101, 0x00000009, 0x00000012, 0x00000202, 0x0000001a,
					0x00000124, 0x0000040c, 0x00000026, 0x0000004a, 0x0000080a,
					0x00000060, 0x00000590, 0x00001020 }),
			new DvInfo(1, 49, 0, 58, 9, new int[] { 0x18000000, 0xb800000a,
					0xc8000010, 0x2c000010, 0xf4000014, 0xb4000008, 0x08000000,
					0x9800000c, 0xd8000010, 0x08000010, 0xb8000010, 0x98000000,
					0x60000000, 0x00000008, 0xc0000000, 0x90000014, 0x10000010,
					0xb8000014, 0x28000000, 0x20000010, 0x48000000, 0x08000018,
					0x60000000, 0x90000010, 0xf0000010, 0x90000008, 0xc0000000,
					0x90000010, 0xf0000010, 0xb0000008, 0x40000000, 0x90000000,
					0xf0000010, 0x90000018, 0x60000000, 0x90000010, 0x90000010,
					0x90000000, 0x80000000, 0x00000010, 0xa0000000, 0x20000000,
					0xa0000000, 0x20000010, 0x00000000, 0x20000010, 0x20000000,
					0x00000010, 0x20000000, 0x00000010, 0xa0000000, 0x00000000,
					0x20000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000001, 0x00000020, 0x00000001,
					0x40000002, 0x40000040, 0x40000002, 0x80000004, 0x80000080,
					0x80000006, 0x00000049, 0x00000103, 0x80000009, 0x80000012,
					0x80000202, 0x00000018, 0x00000164 }),
			new DvInfo(1, 49, 2, 58, 10, new int[] { 0x60000000, 0xe000002a,
					0x20000043, 0xb0000040, 0xd0000053, 0xd0000022, 0x20000000,
					0x60000032, 0x60000043, 0x20000040, 0xe0000042, 0x60000002,
					0x80000001, 0x00000020, 0x00000003, 0x40000052, 0x40000040,
					0xe0000052, 0xa0000000, 0x80000040, 0x20000001, 0x20000060,
					0x80000001, 0x40000042, 0xc0000043, 0x40000022, 0x00000003,
					0x40000042, 0xc0000043, 0xc0000022, 0x00000001, 0x40000002,
					0xc0000043, 0x40000062, 0x80000001, 0x40000042, 0x40000042,
					0x40000002, 0x00000002, 0x00000040, 0x80000002, 0x80000000,
					0x80000002, 0x80000040, 0x00000000, 0x80000040, 0x80000000,
					0x00000040, 0x80000000, 0x00000040, 0x80000002, 0x00000000,
					0x80000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000004, 0x00000080, 0x00000004,
					0x00000009, 0x00000101, 0x00000009, 0x00000012, 0x00000202,
					0x0000001a, 0x00000124, 0x0000040c, 0x00000026, 0x0000004a,
					0x0000080a, 0x00000060, 0x00000590 }),
			new DvInfo(1, 50, 0, 65, 11, new int[] { 0x0800000c, 0x18000000,
					0xb800000a, 0xc8000010, 0x2c000010, 0xf4000014, 0xb4000008,
					0x08000000, 0x9800000c, 0xd8000010, 0x08000010, 0xb8000010,
					0x98000000, 0x60000000, 0x00000008, 0xc0000000, 0x90000014,
					0x10000010, 0xb8000014, 0x28000000, 0x20000010, 0x48000000,
					0x08000018, 0x60000000, 0x90000010, 0xf0000010, 0x90000008,
					0xc0000000, 0x90000010, 0xf0000010, 0xb0000008, 0x40000000,
					0x90000000, 0xf0000010, 0x90000018, 0x60000000, 0x90000010,
					0x90000010, 0x90000000, 0x80000000, 0x00000010, 0xa0000000,
					0x20000000, 0xa0000000, 0x20000010, 0x00000000, 0x20000010,
					0x20000000, 0x00000010, 0x20000000, 0x00000010, 0xa0000000,
					0x00000000, 0x20000000, 0x20000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000020,
					0x00000001, 0x40000002, 0x40000040, 0x40000002, 0x80000004,
					0x80000080, 0x80000006, 0x00000049, 0x00000103, 0x80000009,
					0x80000012, 0x80000202, 0x00000018 }),
			new DvInfo(1, 50, 2, 65, 12, new int[] { 0x20000030, 0x60000000,
					0xe000002a, 0x20000043, 0xb0000040, 0xd0000053, 0xd0000022,
					0x20000000, 0x60000032, 0x60000043, 0x20000040, 0xe0000042,
					0x60000002, 0x80000001, 0x00000020, 0x00000003, 0x40000052,
					0x40000040, 0xe0000052, 0xa0000000, 0x80000040, 0x20000001,
					0x20000060, 0x80000001, 0x40000042, 0xc0000043, 0x40000022,
					0x00000003, 0x40000042, 0xc0000043, 0xc0000022, 0x00000001,
					0x40000002, 0xc0000043, 0x40000062, 0x80000001, 0x40000042,
					0x40000042, 0x40000002, 0x00000002, 0x00000040, 0x80000002,
					0x80000000, 0x80000002, 0x80000040, 0x00000000, 0x80000040,
					0x80000000, 0x00000040, 0x80000000, 0x00000040, 0x80000002,
					0x00000000, 0x80000000, 0x80000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x00000080,
					0x00000004, 0x00000009, 0x00000101, 0x00000009, 0x00000012,
					0x00000202, 0x0000001a, 0x00000124, 0x0000040c, 0x00000026,
					0x0000004a, 0x0000080a, 0x00000060 }),
			new DvInfo(1, 51, 0, 65, 13, new int[] { 0xe8000000, 0x0800000c,
					0x18000000, 0xb800000a, 0xc8000010, 0x2c000010, 0xf4000014,
					0xb4000008, 0x08000000, 0x9800000c, 0xd8000010, 0x08000010,
					0xb8000010, 0x98000000, 0x60000000, 0x00000008, 0xc0000000,
					0x90000014, 0x10000010, 0xb8000014, 0x28000000, 0x20000010,
					0x48000000, 0x08000018, 0x60000000, 0x90000010, 0xf0000010,
					0x90000008, 0xc0000000, 0x90000010, 0xf0000010, 0xb0000008,
					0x40000000, 0x90000000, 0xf0000010, 0x90000018, 0x60000000,
					0x90000010, 0x90000010, 0x90000000, 0x80000000, 0x00000010,
					0xa0000000, 0x20000000, 0xa0000000, 0x20000010, 0x00000000,
					0x20000010, 0x20000000, 0x00000010, 0x20000000, 0x00000010,
					0xa0000000, 0x00000000, 0x20000000, 0x20000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
					0x00000020, 0x00000001, 0x40000002, 0x40000040, 0x40000002,
					0x80000004, 0x80000080, 0x80000006, 0x00000049, 0x00000103,
					0x80000009, 0x80000012, 0x80000202 }),
			new DvInfo(1, 51, 2, 65, 14, new int[] { 0xa0000003, 0x20000030,
					0x60000000, 0xe000002a, 0x20000043, 0xb0000040, 0xd0000053,
					0xd0000022, 0x20000000, 0x60000032, 0x60000043, 0x20000040,
					0xe0000042, 0x60000002, 0x80000001, 0x00000020, 0x00000003,
					0x40000052, 0x40000040, 0xe0000052, 0xa0000000, 0x80000040,
					0x20000001, 0x20000060, 0x80000001, 0x40000042, 0xc0000043,
					0x40000022, 0x00000003, 0x40000042, 0xc0000043, 0xc0000022,
					0x00000001, 0x40000002, 0xc0000043, 0x40000062, 0x80000001,
					0x40000042, 0x40000042, 0x40000002, 0x00000002, 0x00000040,
					0x80000002, 0x80000000, 0x80000002, 0x80000040, 0x00000000,
					0x80000040, 0x80000000, 0x00000040, 0x80000000, 0x00000040,
					0x80000002, 0x00000000, 0x80000000, 0x80000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004,
					0x00000080, 0x00000004, 0x00000009, 0x00000101, 0x00000009,
					0x00000012, 0x00000202, 0x0000001a, 0x00000124, 0x0000040c,
					0x00000026, 0x0000004a, 0x0000080a }),
			new DvInfo(1, 52, 0, 65, 15, new int[] { 0x04000010, 0xe8000000,
					0x0800000c, 0x18000000, 0xb800000a, 0xc8000010, 0x2c000010,
					0xf4000014, 0xb4000008, 0x08000000, 0x9800000c, 0xd8000010,
					0x08000010, 0xb8000010, 0x98000000, 0x60000000, 0x00000008,
					0xc0000000, 0x90000014, 0x10000010, 0xb8000014, 0x28000000,
					0x20000010, 0x48000000, 0x08000018, 0x60000000, 0x90000010,
					0xf0000010, 0x90000008, 0xc0000000, 0x90000010, 0xf0000010,
					0xb0000008, 0x40000000, 0x90000000, 0xf0000010, 0x90000018,
					0x60000000, 0x90000010, 0x90000010, 0x90000000, 0x80000000,
					0x00000010, 0xa0000000, 0x20000000, 0xa0000000, 0x20000010,
					0x00000000, 0x20000010, 0x20000000, 0x00000010, 0x20000000,
					0x00000010, 0xa0000000, 0x00000000, 0x20000000, 0x20000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000001, 0x00000020, 0x00000001, 0x40000002, 0x40000040,
					0x40000002, 0x80000004, 0x80000080, 0x80000006, 0x00000049,
					0x00000103, 0x80000009, 0x80000012 }),
			new DvInfo(2, 45, 0, 58, 16, new int[] { 0xec000014, 0x0c000002,
					0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010,
					0x0000000c, 0xb8000010, 0x08000018, 0x78000010, 0x08000014,
					0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010,
					0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010,
					0xa0000000, 0x00000000, 0x00000000, 0x20000000, 0x80000000,
					0x00000010, 0x00000000, 0x20000010, 0x20000000, 0x00000010,
					0x60000000, 0x00000018, 0xe0000000, 0x90000000, 0x30000010,
					0xb0000000, 0x20000000, 0x20000000, 0xa0000000, 0x00000010,
					0x80000000, 0x20000000, 0x20000000, 0x20000000, 0x80000000,
					0x00000010, 0x00000000, 0x20000010, 0xa0000000, 0x00000000,
					0x20000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000020,
					0x00000001, 0x40000002, 0x40000041, 0x40000022, 0x80000005,
					0xc0000082, 0xc0000046, 0x4000004b, 0x80000107, 0x00000089,
					0x00000014, 0x8000024b, 0x0000011b, 0x8000016d, 0x8000041a,
					0x000002e4, 0x80000054, 0x00000967 }),
			new DvInfo(2, 46, 0, 58, 17, new int[] { 0x2400001c, 0xec000014,
					0x0c000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018,
					0xb0000010, 0x0000000c, 0xb8000010, 0x08000018, 0x78000010,
					0x08000014, 0x70000010, 0xb800001c, 0xe8000000, 0xb0000004,
					0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010,
					0x98000010, 0xa0000000, 0x00000000, 0x00000000, 0x20000000,
					0x80000000, 0x00000010, 0x00000000, 0x20000010, 0x20000000,
					0x00000010, 0x60000000, 0x00000018, 0xe0000000, 0x90000000,
					0x30000010, 0xb0000000, 0x20000000, 0x20000000, 0xa0000000,
					0x00000010, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
					0x80000000, 0x00000010, 0x00000000, 0x20000010, 0xa0000000,
					0x00000000, 0x20000000, 0x20000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
					0x00000020, 0x00000001, 0x40000002, 0x40000041, 0x40000022,
					0x80000005, 0xc0000082, 0xc0000046, 0x4000004b, 0x80000107,
					0x00000089, 0x00000014, 0x8000024b, 0x0000011b, 0x8000016d,
					0x8000041a, 0x000002e4, 0x80000054 }),
			new DvInfo(2, 46, 2, 58, 18, new int[] { 0x90000070, 0xb0000053,
					0x30000008, 0x00000043, 0xd0000072, 0xb0000010, 0xf0000062,
					0xc0000042, 0x00000030, 0xe0000042, 0x20000060, 0xe0000041,
					0x20000050, 0xc0000041, 0xe0000072, 0xa0000003, 0xc0000012,
					0x60000041, 0xc0000032, 0x20000001, 0xc0000002, 0xe0000042,
					0x60000042, 0x80000002, 0x00000000, 0x00000000, 0x80000000,
					0x00000002, 0x00000040, 0x00000000, 0x80000040, 0x80000000,
					0x00000040, 0x80000001, 0x00000060, 0x80000003, 0x40000002,
					0xc0000040, 0xc0000002, 0x80000000, 0x80000000, 0x80000002,
					0x00000040, 0x00000002, 0x80000000, 0x80000000, 0x80000000,
					0x00000002, 0x00000040, 0x00000000, 0x80000040, 0x80000002,
					0x00000000, 0x80000000, 0x80000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004,
					0x00000080, 0x00000004, 0x00000009, 0x00000105, 0x00000089,
					0x00000016, 0x0000020b, 0x0000011b, 0x0000012d, 0x0000041e,
					0x00000224, 0x00000050, 0x0000092e, 0x0000046c, 0x000005b6,
					0x0000106a, 0x00000b90, 0x00000152 }),
			new DvInfo(2, 47, 0, 58, 19, new int[] { 0x20000010, 0x2400001c,
					0xec000014, 0x0c000002, 0xc0000010, 0xb400001c, 0x2c000004,
					0xbc000018, 0xb0000010, 0x0000000c, 0xb8000010, 0x08000018,
					0x78000010, 0x08000014, 0x70000010, 0xb800001c, 0xe8000000,
					0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000,
					0xb8000010, 0x98000010, 0xa0000000, 0x00000000, 0x00000000,
					0x20000000, 0x80000000, 0x00000010, 0x00000000, 0x20000010,
					0x20000000, 0x00000010, 0x60000000, 0x00000018, 0xe0000000,
					0x90000000, 0x30000010, 0xb0000000, 0x20000000, 0x20000000,
					0xa0000000, 0x00000010, 0x80000000, 0x20000000, 0x20000000,
					0x20000000, 0x80000000, 0x00000010, 0x00000000, 0x20000010,
					0xa0000000, 0x00000000, 0x20000000, 0x20000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000001, 0x00000020, 0x00000001, 0x40000002, 0x40000041,
					0x40000022, 0x80000005, 0xc0000082, 0xc0000046, 0x4000004b,
					0x80000107, 0x00000089, 0x00000014, 0x8000024b, 0x0000011b,
					0x8000016d, 0x8000041a, 0x000002e4 }),
			new DvInfo(2, 48, 0, 58, 20, new int[] { 0xbc00001a, 0x20000010,
					0x2400001c, 0xec000014, 0x0c000002, 0xc0000010, 0xb400001c,
					0x2c000004, 0xbc000018, 0xb0000010, 0x0000000c, 0xb8000010,
					0x08000018, 0x78000010, 0x08000014, 0x70000010, 0xb800001c,
					0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000,
					0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0x00000000,
					0x00000000, 0x20000000, 0x80000000, 0x00000010, 0x00000000,
					0x20000010, 0x20000000, 0x00000010, 0x60000000, 0x00000018,
					0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000,
					0x20000000, 0xa0000000, 0x00000010, 0x80000000, 0x20000000,
					0x20000000, 0x20000000, 0x80000000, 0x00000010, 0x00000000,
					0x20000010, 0xa0000000, 0x00000000, 0x20000000, 0x20000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000001, 0x00000020, 0x00000001, 0x40000002,
					0x40000041, 0x40000022, 0x80000005, 0xc0000082, 0xc0000046,
					0x4000004b, 0x80000107, 0x00000089, 0x00000014, 0x8000024b,
					0x0000011b, 0x8000016d, 0x8000041a }),
			new DvInfo(2, 49, 0, 58, 21, new int[] { 0x3c000004, 0xbc00001a,
					0x20000010, 0x2400001c, 0xec000014, 0x0c000002, 0xc0000010,
					0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0x0000000c,
					0xb8000010, 0x08000018, 0x78000010, 0x08000014, 0x70000010,
					0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c,
					0x48000000, 0xb0000000, 0xb8000010, 0x98000010, 0xa0000000,
					0x00000000, 0x00000000, 0x20000000, 0x80000000, 0x00000010,
					0x00000000, 0x20000010, 0x20000000, 0x00000010, 0x60000000,
					0x00000018, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000,
					0x20000000, 0x20000000, 0xa0000000, 0x00000010, 0x80000000,
					0x20000000, 0x20000000, 0x20000000, 0x80000000, 0x00000010,
					0x00000000, 0x20000010, 0xa0000000, 0x00000000, 0x20000000,
					0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000001, 0x00000020, 0x00000001,
					0x40000002, 0x40000041, 0x40000022, 0x80000005, 0xc0000082,
					0xc0000046, 0x4000004b, 0x80000107, 0x00000089, 0x00000014,
					0x8000024b, 0x0000011b, 0x8000016d }),
			new DvInfo(2, 49, 2, 58, 22, new int[] { 0xf0000010, 0xf000006a,
					0x80000040, 0x90000070, 0xb0000053, 0x30000008, 0x00000043,
					0xd0000072, 0xb0000010, 0xf0000062, 0xc0000042, 0x00000030,
					0xe0000042, 0x20000060, 0xe0000041, 0x20000050, 0xc0000041,
					0xe0000072, 0xa0000003, 0xc0000012, 0x60000041, 0xc0000032,
					0x20000001, 0xc0000002, 0xe0000042, 0x60000042, 0x80000002,
					0x00000000, 0x00000000, 0x80000000, 0x00000002, 0x00000040,
					0x00000000, 0x80000040, 0x80000000, 0x00000040, 0x80000001,
					0x00000060, 0x80000003, 0x40000002, 0xc0000040, 0xc0000002,
					0x80000000, 0x80000000, 0x80000002, 0x00000040, 0x00000002,
					0x80000000, 0x80000000, 0x80000000, 0x00000002, 0x00000040,
					0x00000000, 0x80000040, 0x80000002, 0x00000000, 0x80000000,
					0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000004, 0x00000080, 0x00000004,
					0x00000009, 0x00000105, 0x00000089, 0x00000016, 0x0000020b,
					0x0000011b, 0x0000012d, 0x0000041e, 0x00000224, 0x00000050,
					0x0000092e, 0x0000046c, 0x000005b6 }),
			new DvInfo(2, 50, 0, 65, 23, new int[] { 0xb400001c, 0x3c000004,
					0xbc00001a, 0x20000010, 0x2400001c, 0xec000014, 0x0c000002,
					0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010,
					0x0000000c, 0xb8000010, 0x08000018, 0x78000010, 0x08000014,
					0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010,
					0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010,
					0xa0000000, 0x00000000, 0x00000000, 0x20000000, 0x80000000,
					0x00000010, 0x00000000, 0x20000010, 0x20000000, 0x00000010,
					0x60000000, 0x00000018, 0xe0000000, 0x90000000, 0x30000010,
					0xb0000000, 0x20000000, 0x20000000, 0xa0000000, 0x00000010,
					0x80000000, 0x20000000, 0x20000000, 0x20000000, 0x80000000,
					0x00000010, 0x00000000, 0x20000010, 0xa0000000, 0x00000000,
					0x20000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000020,
					0x00000001, 0x40000002, 0x40000041, 0x40000022, 0x80000005,
					0xc0000082, 0xc0000046, 0x4000004b, 0x80000107, 0x00000089,
					0x00000014, 0x8000024b, 0x0000011b }),
			new DvInfo(2, 50, 2, 65, 24, new int[] { 0xd0000072, 0xf0000010,
					0xf000006a, 0x80000040, 0x90000070, 0xb0000053, 0x30000008,
					0x00000043, 0xd0000072, 0xb0000010, 0xf0000062, 0xc0000042,
					0x00000030, 0xe0000042, 0x20000060, 0xe0000041, 0x20000050,
					0xc0000041, 0xe0000072, 0xa0000003, 0xc0000012, 0x60000041,
					0xc0000032, 0x20000001, 0xc0000002, 0xe0000042, 0x60000042,
					0x80000002, 0x00000000, 0x00000000, 0x80000000, 0x00000002,
					0x00000040, 0x00000000, 0x80000040, 0x80000000, 0x00000040,
					0x80000001, 0x00000060, 0x80000003, 0x40000002, 0xc0000040,
					0xc0000002, 0x80000000, 0x80000000, 0x80000002, 0x00000040,
					0x00000002, 0x80000000, 0x80000000, 0x80000000, 0x00000002,
					0x00000040, 0x00000000, 0x80000040, 0x80000002, 0x00000000,
					0x80000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000004, 0x00000080,
					0x00000004, 0x00000009, 0x00000105, 0x00000089, 0x00000016,
					0x0000020b, 0x0000011b, 0x0000012d, 0x0000041e, 0x00000224,
					0x00000050, 0x0000092e, 0x0000046c }),
			new DvInfo(2, 51, 0, 65, 25, new int[] { 0xc0000010, 0xb400001c,
					0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c, 0xec000014,
					0x0c000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018,
					0xb0000010, 0x0000000c, 0xb8000010, 0x08000018, 0x78000010,
					0x08000014, 0x70000010, 0xb800001c, 0xe8000000, 0xb0000004,
					0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010,
					0x98000010, 0xa0000000, 0x00000000, 0x00000000, 0x20000000,
					0x80000000, 0x00000010, 0x00000000, 0x20000010, 0x20000000,
					0x00000010, 0x60000000, 0x00000018, 0xe0000000, 0x90000000,
					0x30000010, 0xb0000000, 0x20000000, 0x20000000, 0xa0000000,
					0x00000010, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
					0x80000000, 0x00000010, 0x00000000, 0x20000010, 0xa0000000,
					0x00000000, 0x20000000, 0x20000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
					0x00000020, 0x00000001, 0x40000002, 0x40000041, 0x40000022,
					0x80000005, 0xc0000082, 0xc0000046, 0x4000004b, 0x80000107,
					0x00000089, 0x00000014, 0x8000024b }),
			new DvInfo(2, 51, 2, 65, 26, new int[] { 0x00000043, 0xd0000072,
					0xf0000010, 0xf000006a, 0x80000040, 0x90000070, 0xb0000053,
					0x30000008, 0x00000043, 0xd0000072, 0xb0000010, 0xf0000062,
					0xc0000042, 0x00000030, 0xe0000042, 0x20000060, 0xe0000041,
					0x20000050, 0xc0000041, 0xe0000072, 0xa0000003, 0xc0000012,
					0x60000041, 0xc0000032, 0x20000001, 0xc0000002, 0xe0000042,
					0x60000042, 0x80000002, 0x00000000, 0x00000000, 0x80000000,
					0x00000002, 0x00000040, 0x00000000, 0x80000040, 0x80000000,
					0x00000040, 0x80000001, 0x00000060, 0x80000003, 0x40000002,
					0xc0000040, 0xc0000002, 0x80000000, 0x80000000, 0x80000002,
					0x00000040, 0x00000002, 0x80000000, 0x80000000, 0x80000000,
					0x00000002, 0x00000040, 0x00000000, 0x80000040, 0x80000002,
					0x00000000, 0x80000000, 0x80000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000004,
					0x00000080, 0x00000004, 0x00000009, 0x00000105, 0x00000089,
					0x00000016, 0x0000020b, 0x0000011b, 0x0000012d, 0x0000041e,
					0x00000224, 0x00000050, 0x0000092e }),
			new DvInfo(2, 52, 0, 65, 27, new int[] { 0x0c000002, 0xc0000010,
					0xb400001c, 0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c,
					0xec000014, 0x0c000002, 0xc0000010, 0xb400001c, 0x2c000004,
					0xbc000018, 0xb0000010, 0x0000000c, 0xb8000010, 0x08000018,
					0x78000010, 0x08000014, 0x70000010, 0xb800001c, 0xe8000000,
					0xb0000004, 0x58000010, 0xb000000c, 0x48000000, 0xb0000000,
					0xb8000010, 0x98000010, 0xa0000000, 0x00000000, 0x00000000,
					0x20000000, 0x80000000, 0x00000010, 0x00000000, 0x20000010,
					0x20000000, 0x00000010, 0x60000000, 0x00000018, 0xe0000000,
					0x90000000, 0x30000010, 0xb0000000, 0x20000000, 0x20000000,
					0xa0000000, 0x00000010, 0x80000000, 0x20000000, 0x20000000,
					0x20000000, 0x80000000, 0x00000010, 0x00000000, 0x20000010,
					0xa0000000, 0x00000000, 0x20000000, 0x20000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000001, 0x00000020, 0x00000001, 0x40000002, 0x40000041,
					0x40000022, 0x80000005, 0xc0000082, 0xc0000046, 0x4000004b,
					0x80000107, 0x00000089, 0x00000014 }),
			new DvInfo(2, 53, 0, 65, 28, new int[] { 0xcc000014, 0x0c000002,
					0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a, 0x20000010,
					0x2400001c, 0xec000014, 0x0c000002, 0xc0000010, 0xb400001c,
					0x2c000004, 0xbc000018, 0xb0000010, 0x0000000c, 0xb8000010,
					0x08000018, 0x78000010, 0x08000014, 0x70000010, 0xb800001c,
					0xe8000000, 0xb0000004, 0x58000010, 0xb000000c, 0x48000000,
					0xb0000000, 0xb8000010, 0x98000010, 0xa0000000, 0x00000000,
					0x00000000, 0x20000000, 0x80000000, 0x00000010, 0x00000000,
					0x20000010, 0x20000000, 0x00000010, 0x60000000, 0x00000018,
					0xe0000000, 0x90000000, 0x30000010, 0xb0000000, 0x20000000,
					0x20000000, 0xa0000000, 0x00000010, 0x80000000, 0x20000000,
					0x20000000, 0x20000000, 0x80000000, 0x00000010, 0x00000000,
					0x20000010, 0xa0000000, 0x00000000, 0x20000000, 0x20000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000001, 0x00000020, 0x00000001, 0x40000002,
					0x40000041, 0x40000022, 0x80000005, 0xc0000082, 0xc0000046,
					0x4000004b, 0x80000107, 0x00000089 }),
			new DvInfo(2, 54, 0, 65, 29, new int[] { 0x0400001c, 0xcc000014,
					0x0c000002, 0xc0000010, 0xb400001c, 0x3c000004, 0xbc00001a,
					0x20000010, 0x2400001c, 0xec000014, 0x0c000002, 0xc0000010,
					0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010, 0x0000000c,
					0xb8000010, 0x08000018, 0x78000010, 0x08000014, 0x70000010,
					0xb800001c, 0xe8000000, 0xb0000004, 0x58000010, 0xb000000c,
					0x48000000, 0xb0000000, 0xb8000010, 0x98000010, 0xa0000000,
					0x00000000, 0x00000000, 0x20000000, 0x80000000, 0x00000010,
					0x00000000, 0x20000010, 0x20000000, 0x00000010, 0x60000000,
					0x00000018, 0xe0000000, 0x90000000, 0x30000010, 0xb0000000,
					0x20000000, 0x20000000, 0xa0000000, 0x00000010, 0x80000000,
					0x20000000, 0x20000000, 0x20000000, 0x80000000, 0x00000010,
					0x00000000, 0x20000010, 0xa0000000, 0x00000000, 0x20000000,
					0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000001, 0x00000020, 0x00000001,
					0x40000002, 0x40000041, 0x40000022, 0x80000005, 0xc0000082,
					0xc0000046, 0x4000004b, 0x80000107 }),
			new DvInfo(2, 55, 0, 65, 30, new int[] { 0x00000010, 0x0400001c,
					0xcc000014, 0x0c000002, 0xc0000010, 0xb400001c, 0x3c000004,
					0xbc00001a, 0x20000010, 0x2400001c, 0xec000014, 0x0c000002,
					0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018, 0xb0000010,
					0x0000000c, 0xb8000010, 0x08000018, 0x78000010, 0x08000014,
					0x70000010, 0xb800001c, 0xe8000000, 0xb0000004, 0x58000010,
					0xb000000c, 0x48000000, 0xb0000000, 0xb8000010, 0x98000010,
					0xa0000000, 0x00000000, 0x00000000, 0x20000000, 0x80000000,
					0x00000010, 0x00000000, 0x20000010, 0x20000000, 0x00000010,
					0x60000000, 0x00000018, 0xe0000000, 0x90000000, 0x30000010,
					0xb0000000, 0x20000000, 0x20000000, 0xa0000000, 0x00000010,
					0x80000000, 0x20000000, 0x20000000, 0x20000000, 0x80000000,
					0x00000010, 0x00000000, 0x20000010, 0xa0000000, 0x00000000,
					0x20000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000020,
					0x00000001, 0x40000002, 0x40000041, 0x40000022, 0x80000005,
					0xc0000082, 0xc0000046, 0x4000004b }),
			new DvInfo(2, 56, 0, 65, 31, new int[] { 0x2600001a, 0x00000010,
					0x0400001c, 0xcc000014, 0x0c000002, 0xc0000010, 0xb400001c,
					0x3c000004, 0xbc00001a, 0x20000010, 0x2400001c, 0xec000014,
					0x0c000002, 0xc0000010, 0xb400001c, 0x2c000004, 0xbc000018,
					0xb0000010, 0x0000000c, 0xb8000010, 0x08000018, 0x78000010,
					0x08000014, 0x70000010, 0xb800001c, 0xe8000000, 0xb0000004,
					0x58000010, 0xb000000c, 0x48000000, 0xb0000000, 0xb8000010,
					0x98000010, 0xa0000000, 0x00000000, 0x00000000, 0x20000000,
					0x80000000, 0x00000010, 0x00000000, 0x20000010, 0x20000000,
					0x00000010, 0x60000000, 0x00000018, 0xe0000000, 0x90000000,
					0x30000010, 0xb0000000, 0x20000000, 0x20000000, 0xa0000000,
					0x00000010, 0x80000000, 0x20000000, 0x20000000, 0x20000000,
					0x80000000, 0x00000010, 0x00000000, 0x20000010, 0xa0000000,
					0x00000000, 0x20000000, 0x20000000, 0x00000000, 0x00000000,
					0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
					0x00000020, 0x00000001, 0x40000002, 0x40000041, 0x40000022,
					0x80000005, 0xc0000082, 0xc0000046 }), };

	static {
		// Assert the DV array is indexed by maskb; that is DV block using
		// maskb = N must be at array index N.
		for (int i = 0; i < DV.length; i++) {
			if (i != DV[i].maskb) {
				throw new IllegalStateException("must be indexed by maskb"); //$NON-NLS-1$
			}
		}
	}
}
