/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openrewrite.jgit.api.CherryPickResult;
import org.openrewrite.jgit.api.Git;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.ConcurrentRefUpdateException;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.api.errors.MultipleParentsNotAllowedException;
import org.openrewrite.jgit.api.errors.NoHeadException;
import org.openrewrite.jgit.api.errors.NoMessageException;
import org.openrewrite.jgit.api.errors.UnmergedPathsException;
import org.openrewrite.jgit.api.errors.WrongRepositoryStateException;
import org.openrewrite.jgit.dircache.DirCacheCheckout;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.events.WorkingTreeModifiedEvent;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.NullProgressMonitor;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectIdRef;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.lib.Ref;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.merge.ContentMergeStrategy;
import org.openrewrite.jgit.merge.MergeMessageFormatter;
import org.openrewrite.jgit.merge.MergeStrategy;
import org.openrewrite.jgit.merge.Merger;
import org.openrewrite.jgit.merge.ResolveMerger;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.treewalk.FileTreeIterator;

public class CherryPickCommand
extends GitCommand<CherryPickResult> {
    private String reflogPrefix = "cherry-pick:";
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private ContentMergeStrategy contentStrategy;
    private Integer mainlineParentNumber;
    private boolean noCommit = false;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CherryPickResult call() throws GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        RevCommit newHead = null;
        LinkedList<Ref> cherryPickedRefs = new LinkedList<Ref>();
        this.checkCallable();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object dco;
            List<String> unmergedPaths;
            Map<String, ResolveMerger.MergeFailureReason> failingPaths;
            RevCommit srcCommit;
            block41: {
                Ref headRef = this.repo.exactRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = revWalk.parseCommit(headRef.getObjectId());
                Iterator<Ref> iterator = this.commits.iterator();
                while (iterator.hasNext()) {
                    boolean noProblems;
                    Ref src = iterator.next();
                    ObjectId srcObjectId = src.getPeeledObjectId();
                    if (srcObjectId == null) {
                        srcObjectId = src.getObjectId();
                    }
                    srcCommit = revWalk.parseCommit(srcObjectId);
                    RevCommit srcParent = this.getParentCommit(srcCommit, revWalk);
                    String ourName = this.calculateOurName(headRef);
                    String cherryPickName = srcCommit.getId().abbreviate(7).name() + " " + srcCommit.getShortMessage();
                    Merger merger = this.strategy.newMerger(this.repo);
                    merger.setProgressMonitor(this.monitor);
                    failingPaths = null;
                    unmergedPaths = null;
                    if (merger instanceof ResolveMerger) {
                        ResolveMerger resolveMerger = (ResolveMerger)merger;
                        resolveMerger.setContentMergeStrategy(this.contentStrategy);
                        resolveMerger.setCommitNames(new String[]{"BASE", ourName, cherryPickName});
                        resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                        resolveMerger.setBase(srcParent.getTree());
                        noProblems = merger.merge(newHead, srcCommit);
                        failingPaths = resolveMerger.getFailingPaths();
                        unmergedPaths = resolveMerger.getUnmergedPaths();
                        if (!resolveMerger.getModifiedFiles().isEmpty()) {
                            this.repo.fireEvent(new WorkingTreeModifiedEvent(resolveMerger.getModifiedFiles(), null));
                        }
                    } else {
                        noProblems = merger.merge(newHead, srcCommit);
                    }
                    if (!noProblems) break block41;
                    if (AnyObjectId.isEqual(newHead.getTree().getId(), merger.getResultTreeId())) continue;
                    dco = new DirCacheCheckout(this.repo, newHead.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                    ((DirCacheCheckout)dco).setFailOnConflict(true);
                    ((DirCacheCheckout)dco).setProgressMonitor(this.monitor);
                    ((DirCacheCheckout)dco).checkout();
                    if (!this.noCommit) {
                        try (Git git = new Git(this.getRepository());){
                            newHead = git.commit().setMessage(srcCommit.getFullMessage()).setReflogComment(this.reflogPrefix + " " + srcCommit.getShortMessage()).setAuthor(srcCommit.getAuthorIdent()).setNoVerify(true).call();
                        }
                    }
                    cherryPickedRefs.add(src);
                }
                return new CherryPickResult(newHead, cherryPickedRefs);
            }
            if (failingPaths != null && !failingPaths.isEmpty()) {
                dco = new CherryPickResult(failingPaths);
                return dco;
            }
            String message = unmergedPaths != null ? new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), unmergedPaths) : srcCommit.getFullMessage();
            if (!this.noCommit) {
                this.repo.writeCherryPickHead(srcCommit.getId());
            }
            this.repo.writeMergeCommitMsg(message);
            CherryPickResult cherryPickResult = CherryPickResult.CONFLICT;
            return cherryPickResult;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), e);
        }
    }

    private RevCommit getParentCommit(RevCommit srcCommit, RevWalk revWalk) throws MultipleParentsNotAllowedException, MissingObjectException, IOException {
        RevCommit srcParent;
        if (this.mainlineParentNumber == null) {
            if (srcCommit.getParentCount() != 1) {
                throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
            }
            srcParent = srcCommit.getParent(0);
        } else {
            if (this.mainlineParentNumber > srcCommit.getParentCount()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().commitDoesNotHaveGivenParent, srcCommit, this.mainlineParentNumber));
            }
            srcParent = srcCommit.getParent(this.mainlineParentNumber - 1);
        }
        revWalk.parseHeaders(srcParent);
        return srcParent;
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public CherryPickCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    public CherryPickCommand setReflogPrefix(String prefix) {
        this.reflogPrefix = prefix;
        return this;
    }

    public CherryPickCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CherryPickCommand setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.contentStrategy = strategy;
        return this;
    }

    public CherryPickCommand setMainlineParentNumber(int mainlineParentNumber) {
        this.mainlineParentNumber = mainlineParentNumber;
        return this;
    }

    public CherryPickCommand setNoCommit(boolean noCommit) {
        this.noCommit = noCommit;
        return this;
    }

    public CherryPickCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public String toString() {
        return "CherryPickCommand [repo=" + this.repo + ",\ncommits=" + this.commits + ",\nmainlineParentNumber=" + this.mainlineParentNumber + ", noCommit=" + this.noCommit + ", ourCommitName=" + this.ourCommitName + ", reflogPrefix=" + this.reflogPrefix + ", strategy=" + this.strategy + "]";
    }
}

