/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeDuplicateSectionsVisitor;
import org.openrewrite.yaml.ShiftFormatLeftVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UnfoldProperties
extends Recipe {
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    @Option(displayName="Exclusions", description="An optional list of [JsonPath Plus](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expressions to specify keys that should not be unfolded.", example="$..[org.springframework.security]")
    private final List<String> exclusions;
    @Option(displayName="Apply to", description="An optional list of [JsonPath Plus](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expressions that specify which keys the recipe should target only. Only the properties matching these expressions will be unfolded.", example="$..[org.springframework.security]")
    private final List<String> applyTo;

    public UnfoldProperties(@Nullable List<String> exclusions, @Nullable List<String> applyTo) {
        this.exclusions = exclusions == null ? Collections.emptyList() : exclusions;
        this.applyTo = applyTo == null ? Collections.emptyList() : applyTo;
    }

    public String getDisplayName() {
        return "Unfold YAML properties";
    }

    public String getDescription() {
        return "Transforms dot-separated property keys in YAML files into nested map hierarchies to enhance clarity and readability, or for compatibility with tools expecting structured YAML.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List exclusionMatchers = this.exclusions.stream().map(JsonPathMatcher::new).collect(Collectors.toList());
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                Yaml doc = super.visitDocument(document, ctx);
                this.doAfterVisit(new MergeDuplicateSectionsVisitor(doc));
                return doc;
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry e, ExecutionContext ctx) {
                Yaml entry = super.visitMappingEntry(e, ctx);
                String key = ((Yaml.Mapping.Entry)entry).getKey().getValue();
                if (key.contains(".")) {
                    List<String> parts;
                    boolean foundMatch = false;
                    Cursor c = this.getCursor();
                    while (!foundMatch && !c.isRoot()) {
                        Cursor current = c;
                        foundMatch = exclusionMatchers.stream().anyMatch(it -> it.matches(current));
                        if (foundMatch) break;
                        c = c.getParent();
                    }
                    if (!foundMatch && (parts = this.getParts(key)).size() > 1) {
                        Yaml.Mapping.Entry nestedEntry = this.createNestedEntry(parts, 0, ((Yaml.Mapping.Entry)entry).getValue()).withPrefix(((Yaml.Mapping.Entry)entry).getPrefix());
                        Yaml.Mapping.Entry newEntry = this.maybeAutoFormat(entry, nestedEntry, ((Yaml.Mapping.Entry)entry).getValue(), ctx, this.getCursor());
                        if (this.shouldShift()) {
                            int identLevel = Math.abs(this.getIndentLevel((Yaml.Mapping.Entry)entry) - this.getIndentLevel(newEntry));
                            if (!StringUtils.hasLineBreak((String)((Yaml.Mapping.Entry)entry).getPrefix()) && StringUtils.hasLineBreak((String)newEntry.getPrefix())) {
                                newEntry = newEntry.withPrefix(this.substringOfAfterFirstLineBreak(((Yaml.Mapping.Entry)entry).getPrefix()));
                            }
                            this.doAfterVisit(new ShiftFormatLeftVisitor(newEntry, identLevel));
                        }
                        return newEntry;
                    }
                }
                return entry;
            }

            private List<String> getParts(String key) {
                String parentKey = this.getParentKey();
                ArrayList<String> keepTogether = new ArrayList<String>();
                for (String ex : UnfoldProperties.this.exclusions) {
                    keepTogether.addAll(this.matches(key, ex, parentKey));
                }
                ArrayList<String> result = new ArrayList<String>();
                List<String> parts = Arrays.asList(key.split("\\."));
                int i = 0;
                block1: while (i < parts.size()) {
                    for (String group : keepTogether) {
                        List<String> subList;
                        List<String> groupParts = Arrays.asList(group.split("\\."));
                        if (i + groupParts.size() > parts.size() || !(subList = parts.subList(i, i + groupParts.size())).equals(groupParts)) continue;
                        result.add(String.join((CharSequence)".", groupParts));
                        i += groupParts.size();
                        continue block1;
                    }
                    result.add(parts.get(i));
                    ++i;
                }
                if (!UnfoldProperties.this.applyTo.isEmpty() && UnfoldProperties.this.applyTo.stream().allMatch(it -> this.matches(key, (String)it, parentKey).isEmpty())) {
                    return Collections.emptyList();
                }
                return result;
            }

            private String getParentKey() {
                StringBuilder parentKey = new StringBuilder();
                for (Cursor c = this.getCursor().getParent(); c != null; c = c.getParent()) {
                    if (!(c.getValue() instanceof Yaml.Mapping.Entry)) continue;
                    parentKey.insert(0, ((Yaml.Mapping.Entry)c.getValue()).getKey().getValue() + ".");
                }
                return parentKey.length() == 0 ? "" : parentKey.substring(0, parentKey.length() - 1);
            }

            private List<String> matches(String key, String pattern, String parentKey) {
                ArrayList<String> result = new ArrayList<String>();
                if (pattern.startsWith("$..")) {
                    pattern = pattern.substring(3);
                }
                if (pattern.startsWith("$.") && (pattern = pattern.replace("$." + parentKey, "")).startsWith(".")) {
                    pattern = pattern.substring(1);
                }
                if (pattern.startsWith("[") && pattern.contains("][")) {
                    int secondBracketStart = pattern.indexOf(91, 1);
                    String secondBracket = pattern.substring(secondBracketStart);
                    String valueOfFirstBracket = pattern.substring(1, secondBracketStart - 1);
                    List<String> firstBracketMatches = this.matches(key, valueOfFirstBracket, parentKey);
                    for (String firstBracketMatch : firstBracketMatches) {
                        if (!key.startsWith(firstBracketMatch) || key.length() <= firstBracketMatch.length()) continue;
                        result.addAll(this.matches(key.substring(firstBracketMatch.length() + 1), secondBracket, (!parentKey.isEmpty() ? parentKey + "." : parentKey) + valueOfFirstBracket));
                    }
                    pattern = pattern.substring(1, secondBracketStart - 1) + secondBracket;
                }
                if (!pattern.startsWith("[") && pattern.contains("[") && parentKey.contains(pattern.split("\\[")[0])) {
                    pattern = "[" + pattern.split("\\[")[1];
                }
                if (pattern.startsWith("[") && pattern.endsWith("]")) {
                    pattern = pattern.substring(1, pattern.length() - 1);
                }
                if (pattern.startsWith("\"") && pattern.endsWith("\"")) {
                    pattern = pattern.substring(1, pattern.length() - 1);
                } else if (pattern.startsWith("'") && pattern.endsWith("'")) {
                    pattern = pattern.substring(1, pattern.length() - 1);
                }
                if (key.contains(pattern)) {
                    result.add(pattern);
                } else if (pattern.startsWith("?(@property.match(/") && pattern.endsWith("/))")) {
                    pattern = pattern.substring(19, pattern.length() - 3);
                    Matcher m = Pattern.compile(".*(" + pattern + ").*").matcher(key);
                    if (m.matches()) {
                        String match;
                        String string = match = m.group(1).isEmpty() ? m.group(0) : m.group(1);
                        if (match.endsWith(".")) {
                            match = match.substring(0, match.length() - 1);
                        }
                        result.add(match);
                    }
                }
                return result;
            }

            private Yaml.Mapping.Entry createNestedEntry(List<String> keys, int index, Yaml.Block value) {
                if (index != keys.size() - 1) {
                    Yaml.Mapping.Entry entry = this.createNestedEntry(keys, index + 1, value);
                    value = new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.singletonList(entry), null, null, null);
                }
                Yaml.Scalar key = new Yaml.Scalar(Tree.randomId(), "", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, null, null, keys.get(index));
                return new Yaml.Mapping.Entry(Tree.randomId(), "", Markers.EMPTY, key, "", value);
            }

            private int getIndentLevel(Yaml.Mapping.Entry entry) {
                String[] parts = entry.getPrefix().split("\\R");
                return parts.length > 1 ? StringUtils.countOccurrences((String)parts[1], (String)" ") : 0;
            }

            private boolean shouldShift() {
                try {
                    this.getCursor().dropParentUntil(it -> it instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)it).getKey().getValue().contains("."));
                    return false;
                }
                catch (IllegalStateException ignored) {
                    return true;
                }
            }

            private String substringOfAfterFirstLineBreak(String s) {
                String[] lines = LINE_BREAK.split(s, -1);
                return lines.length > 1 ? String.join((CharSequence)"\n", Arrays.copyOfRange(lines, 1, lines.length)) : "";
            }
        };
    }

    @Generated
    public List<String> getExclusions() {
        return this.exclusions;
    }

    @Generated
    public List<String> getApplyTo() {
        return this.applyTo;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UnfoldProperties(exclusions=" + this.getExclusions() + ", applyTo=" + this.getApplyTo() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnfoldProperties)) {
            return false;
        }
        UnfoldProperties other = (UnfoldProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
            return false;
        }
        List<String> this$applyTo = this.getApplyTo();
        List<String> other$applyTo = other.getApplyTo();
        return !(this$applyTo == null ? other$applyTo != null : !((Object)this$applyTo).equals(other$applyTo));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UnfoldProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        List<String> $applyTo = this.getApplyTo();
        result = result * 59 + ($applyTo == null ? 43 : ((Object)$applyTo).hashCode());
        return result;
    }
}

