/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.trait;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.trait.Reference;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.yaml.trait.YamlReference;
import org.openrewrite.yaml.tree.Yaml;

public final class YamlApplicationConfigReference
extends YamlReference {
    private final Cursor cursor;
    private final Reference.Kind kind;

    @Generated
    public YamlApplicationConfigReference(Cursor cursor, Reference.Kind kind) {
        this.cursor = cursor;
        this.kind = kind;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public Reference.Kind getKind() {
        return this.kind;
    }

    @NonNull
    @Generated
    public String toString() {
        return "YamlApplicationConfigReference(cursor=" + this.getCursor() + ", kind=" + this.getKind() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YamlApplicationConfigReference)) {
            return false;
        }
        YamlApplicationConfigReference other = (YamlApplicationConfigReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        Reference.Kind this$kind = this.getKind();
        Reference.Kind other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof YamlApplicationConfigReference;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        Reference.Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public static class Provider
    extends YamlReference.YamlProvider {
        private static final Predicate<String> applicationPropertiesMatcher = Pattern.compile("^application(-\\w+)?\\.(yaml|yml)$").asPredicate();
        private static final SimpleTraitMatcher<YamlReference> matcher = new SimpleTraitMatcher<YamlReference>(){
            private final Predicate<String> javaFullyQualifiedTypePattern = Pattern.compile("^\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*$").asPredicate();

            protected @Nullable YamlReference test(Cursor cursor) {
                Object value = cursor.getValue();
                if (value instanceof Yaml.Scalar && this.javaFullyQualifiedTypePattern.test(((Yaml.Scalar)value).getValue())) {
                    return new YamlApplicationConfigReference(cursor, this.determineKind(((Yaml.Scalar)value).getValue()));
                }
                return null;
            }

            private Reference.Kind determineKind(String value) {
                return Character.isUpperCase(value.charAt(value.lastIndexOf(46) + 1)) ? Reference.Kind.TYPE : Reference.Kind.PACKAGE;
            }
        };

        @Override
        public boolean isAcceptable(SourceFile sourceFile) {
            return super.isAcceptable(sourceFile) && applicationPropertiesMatcher.test(sourceFile.getSourcePath().getFileName().toString());
        }

        public SimpleTraitMatcher<YamlReference> getMatcher() {
            return matcher;
        }
    }
}

