/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;
import org.openrewrite.yaml.MultilineScalarChanged;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class MergeYamlVisitor<P>
extends YamlVisitor<P> {
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    private final Yaml existing;
    private final Yaml incoming;
    private final boolean acceptTheirs;
    private final @Nullable String objectIdentifyingProperty;
    private final @Nullable String insertBefore;
    private boolean shouldAutoFormat = true;
    private @Nullable String linebreak = null;

    public MergeYamlVisitor(Yaml.Block block, Yaml incoming, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, boolean shouldAutoFormat) {
        this((Yaml)block, incoming, acceptTheirs, objectIdentifyingProperty, null);
        this.shouldAutoFormat = shouldAutoFormat;
    }

    private String linebreak() {
        if (this.linebreak == null) {
            this.linebreak = Optional.ofNullable((Yaml.Documents)this.getCursor().firstEnclosing(Yaml.Documents.class)).map(docs -> (GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)docs)).map(format -> format.isUseCRLFNewLines() ? "\r\n" : "\n").orElse("\n");
        }
        return this.linebreak;
    }

    public MergeYamlVisitor(Yaml scope, @Language(value="yml") String yamlString, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, @Nullable String insertBefore) {
        this(scope, (Yaml)new YamlParser().parse(yamlString).findFirst().map(Yaml.Documents.class::cast).map(docs -> {
            Yaml.Document doc = docs.getDocuments().get(0);
            if (doc.getBlock() instanceof Yaml.Mapping) {
                Yaml.Mapping m = (Yaml.Mapping)doc.getBlock();
                return m.withEntries(ListUtils.mapFirst(m.getEntries(), entry -> entry.withPrefix(doc.getPrefix())));
            }
            if (doc.getBlock() instanceof Yaml.Sequence) {
                Yaml.Sequence s = (Yaml.Sequence)doc.getBlock();
                return s.withEntries(ListUtils.mapFirst(s.getEntries(), entry -> entry.withPrefix(doc.getPrefix())));
            }
            return doc.getBlock().withPrefix(doc.getPrefix());
        }).orElseThrow(() -> new IllegalArgumentException("Could not parse as YAML")), acceptTheirs, objectIdentifyingProperty, insertBefore);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar existingScalar, P p) {
        if (this.existing.isScope(existingScalar) && this.incoming instanceof Yaml.Scalar) {
            return this.mergeScalar(existingScalar, (Yaml.Scalar)this.incoming);
        }
        return super.visitScalar(existingScalar, p);
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence existingSeq, P p) {
        if (this.existing.isScope(existingSeq)) {
            if (this.incoming instanceof Yaml.Mapping) {
                return existingSeq.withEntries(ListUtils.map(existingSeq.getEntries(), (i, existingSeqEntry) -> existingSeqEntry.withBlock((Yaml.Block)new MergeYamlVisitor<P>(existingSeqEntry.getBlock(), this.incoming, this.acceptTheirs, this.objectIdentifyingProperty, this.shouldAutoFormat).visitNonNull(existingSeqEntry.getBlock(), p, new Cursor(this.getCursor(), existingSeqEntry)))));
            }
            if (this.incoming instanceof Yaml.Sequence) {
                return this.mergeSequence(existingSeq, (Yaml.Sequence)this.incoming, p, this.getCursor());
            }
        }
        return super.visitSequence(existingSeq, p);
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping existingMapping, P p) {
        if (this.existing.isScope(existingMapping) && this.incoming instanceof Yaml.Mapping) {
            Yaml.Mapping mapping = this.mergeMapping(existingMapping, (Yaml.Mapping)this.incoming, p, this.getCursor());
            if (((Boolean)this.getCursor().getMessage("REMOVE_PREFIX", (Object)false)).booleanValue()) {
                List<Yaml.Mapping.Entry> entries = ((Yaml.Mapping)this.getCursor().getValue()).getEntries();
                return mapping.withEntries(ListUtils.mapLast(mapping.getEntries(), it -> it.withPrefix(this.linebreak() + this.substringOfAfterFirstLineBreak(((Yaml.Mapping.Entry)entries.get(entries.size() - 1)).getPrefix()))));
            }
            return mapping;
        }
        return super.visitMapping(existingMapping, p);
    }

    private static boolean keyMatches(@Nullable Yaml.Mapping.Entry e1, @Nullable Yaml.Mapping.Entry e2) {
        return e1 != null && e2 != null && e1.getKey().getValue().equals(e2.getKey().getValue());
    }

    private boolean keyMatches(Yaml.Mapping m1, Yaml.Mapping m2) {
        Optional<String> nameToAdd = m2.getEntries().stream().filter(e -> this.objectIdentifyingProperty != null && this.objectIdentifyingProperty.equals(e.getKey().getValue())).map(e -> ((Yaml.Scalar)e.getValue()).getValue()).findAny();
        return nameToAdd.map(nameToAddValue -> m1.getEntries().stream().filter(e -> this.objectIdentifyingProperty.equals(e.getKey().getValue())).map(e -> ((Yaml.Scalar)e.getValue()).getValue()).anyMatch(existingName -> existingName.equals(nameToAddValue))).orElse(false);
    }

    private Yaml.Mapping mergeMapping(Yaml.Mapping m1, Yaml.Mapping m2, P p, Cursor cursor) {
        Cursor c;
        ArrayList<Yaml.Mapping.Entry> mutatedEntries;
        List mergedEntries = ListUtils.map(m1.getEntries(), existingEntry -> {
            for (Yaml.Mapping.Entry incomingEntry : m2.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)) continue;
                Yaml.Block value = incomingEntry.getValue();
                if (this.shouldAutoFormat && incomingEntry.getValue() instanceof Yaml.Scalar && StringUtils.hasLineBreak((String)((Yaml.Scalar)value).getValue())) {
                    MultilineScalarChanged marker = new MultilineScalarChanged(Tree.randomId(), false, this.calculateMultilineIndent(incomingEntry));
                    value = this.autoFormat((Yaml.Block)value.withMarkers(value.getMarkers().add((Marker)marker)), p);
                }
                Yaml mergedYaml = (Yaml)new MergeYamlVisitor<P>(existingEntry.getValue(), (Yaml)value, this.acceptTheirs, this.objectIdentifyingProperty, this.shouldAutoFormat).visitNonNull(existingEntry.getValue(), p, new Cursor(cursor, existingEntry));
                return existingEntry.withValue((Yaml.Block)mergedYaml);
            }
            return existingEntry;
        });
        List newEntries = ListUtils.map(m2.getEntries(), it -> {
            for (Yaml.Mapping.Entry existingEntry : m1.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, it)) continue;
                return null;
            }
            if (this.shouldAutoFormat && it.getValue() instanceof Yaml.Scalar && StringUtils.hasLineBreak((String)((Yaml.Scalar)it.getValue()).getValue())) {
                MultilineScalarChanged marker = new MultilineScalarChanged(Tree.randomId(), true, this.calculateMultilineIndent((Yaml.Mapping.Entry)it));
                it = it.withValue((Yaml.Block)it.getValue().withMarkers(it.getValue().getMarkers().add((Marker)marker)));
            }
            return this.shouldAutoFormat ? this.autoFormat(it, p, cursor) : it;
        });
        if (StringUtils.isBlank((String)this.insertBefore) || newEntries.isEmpty()) {
            mutatedEntries = ListUtils.concatAll((List)mergedEntries, (List)newEntries);
        } else {
            mutatedEntries = new ArrayList<Yaml.Mapping.Entry>();
            for (Yaml.Mapping.Entry existingEntry2 : mergedEntries) {
                if (this.insertBefore.equals(existingEntry2.getKey().getValue())) {
                    mutatedEntries.addAll(newEntries);
                }
                mutatedEntries.add(existingEntry2);
            }
        }
        if (m1.getEntries().size() < mutatedEntries.size() && !this.getCursor().isRoot() && ((c = this.getCursor().dropParentUntil(it -> {
            if ("root".equals(it) || it instanceof Yaml.Document) {
                return true;
            }
            if (it instanceof Yaml.Mapping) {
                List<Yaml.Mapping.Entry> entries = ((Yaml.Mapping)it).getEntries();
                if (entries.get(entries.size() - 1).equals(this.getCursor().getParentOrThrow().getValue())) {
                    return false;
                }
                return entries.size() > 1;
            }
            return false;
        })).getValue() instanceof Yaml.Document || c.getValue() instanceof Yaml.Mapping)) {
            String comment = null;
            if (c.getValue() instanceof Yaml.Document) {
                comment = ((Yaml.Document)c.getValue()).getEnd().getPrefix();
            } else {
                List<Yaml.Mapping.Entry> entries = ((Yaml.Mapping)c.getValue()).getEntries();
                for (int i = 0; i < entries.size() - 1; ++i) {
                    if (!entries.get(i).getValue().equals(this.getCursor().getValue())) continue;
                    comment = this.substringOfBeforeFirstLineBreak(entries.get(i + 1).getPrefix());
                    break;
                }
                if (comment == null && StringUtils.hasLineBreak((String)entries.get(entries.size() - 1).getPrefix())) {
                    comment = this.substringOfBeforeFirstLineBreak(entries.get(entries.size() - 1).getPrefix());
                }
            }
            if (comment != null) {
                Yaml.Mapping.Entry last = (Yaml.Mapping.Entry)mutatedEntries.get(mutatedEntries.size() - 1);
                mutatedEntries.set(mutatedEntries.size() - 1, last.withPrefix(comment + last.getPrefix()));
                c.putMessage("REMOVE_PREFIX", (Object)true);
            }
        }
        this.removePrefixForDirectChildren(m1.getEntries(), mutatedEntries);
        return m1.withEntries(mutatedEntries);
    }

    private void removePrefixForDirectChildren(List<Yaml.Mapping.Entry> m1Entries, List<Yaml.Mapping.Entry> mutatedEntries) {
        for (int i = 0; i < m1Entries.size() - 1; ++i) {
            if (!(m1Entries.get(i).getValue() instanceof Yaml.Mapping) || !(mutatedEntries.get(i).getValue() instanceof Yaml.Mapping) || ((Yaml.Mapping)m1Entries.get(i).getValue()).getEntries().size() >= ((Yaml.Mapping)mutatedEntries.get(i).getValue()).getEntries().size()) continue;
            mutatedEntries.set(i + 1, mutatedEntries.get(i + 1).withPrefix(this.linebreak() + this.substringOfAfterFirstLineBreak(mutatedEntries.get(i + 1).getPrefix())));
        }
    }

    private Yaml.Sequence mergeSequence(Yaml.Sequence s1, Yaml.Sequence s2, P p, Cursor cursor) {
        if (this.acceptTheirs) {
            return s1;
        }
        boolean isSequenceOfScalars = s2.getEntries().stream().allMatch(entry -> entry.getBlock() instanceof Yaml.Scalar);
        if (isSequenceOfScalars) {
            ArrayList<Yaml.Sequence.Entry> incomingEntries = new ArrayList<Yaml.Sequence.Entry>(s2.getEntries());
            block0: for (Yaml.Sequence.Entry entry2 : s1.getEntries()) {
                if (!(entry2.getBlock() instanceof Yaml.Scalar)) continue;
                String existingScalar = ((Yaml.Scalar)entry2.getBlock()).getValue();
                for (Yaml.Sequence.Entry incomingEntry : incomingEntries) {
                    if (!((Yaml.Scalar)incomingEntry.getBlock()).getValue().equals(existingScalar)) continue;
                    incomingEntries.remove(incomingEntry);
                    continue block0;
                }
            }
            return s1.withEntries(ListUtils.concatAll(s1.getEntries(), (List)ListUtils.map(incomingEntries, it -> this.autoFormat(it, p, cursor))));
        }
        if (this.objectIdentifyingProperty == null) {
            return s1;
        }
        List mutatedEntries = ListUtils.map(s2.getEntries(), entry -> {
            Yaml.Mapping incomingMapping = (Yaml.Mapping)entry.getBlock();
            for (Yaml.Sequence.Entry existingEntry : s1.getEntries()) {
                Yaml.Mapping existingMapping = (Yaml.Mapping)existingEntry.getBlock();
                if (!this.keyMatches(existingMapping, incomingMapping)) continue;
                Yaml.Sequence.Entry e1 = existingEntry.withBlock(this.mergeMapping(existingMapping, incomingMapping, p, cursor));
                if (e1 == existingEntry) {
                    return null;
                }
                return e1;
            }
            return entry;
        });
        if (mutatedEntries.isEmpty()) {
            return s1;
        }
        List entries = ListUtils.concatAll(s1.getEntries().stream().filter(entry -> !mutatedEntries.contains(entry)).collect(Collectors.toList()), (List)ListUtils.map((List)mutatedEntries, entry -> this.autoFormat(entry, p, cursor)));
        if (entries.size() != s1.getEntries().size()) {
            return s1.withEntries(entries);
        }
        for (int i = 0; i < s1.getEntries().size(); ++i) {
            if (entries.get(i) == s1.getEntries().get(i)) continue;
            return s1.withEntries(entries);
        }
        return s1;
    }

    private Yaml.Scalar mergeScalar(Yaml.Scalar y1, Yaml.Scalar y2) {
        String s2;
        String s1 = y1.getValue();
        return !s1.equals(s2 = y2.getValue()) && !this.acceptTheirs ? y1.withValue(s2) : y1;
    }

    private String substringOfBeforeFirstLineBreak(String s) {
        String[] lines = LINE_BREAK.split(s);
        return lines.length > 0 ? lines[0] : "";
    }

    private String substringOfAfterFirstLineBreak(String s) {
        String[] lines = LINE_BREAK.split(s);
        return lines.length > 1 ? String.join((CharSequence)this.linebreak(), Arrays.copyOfRange(lines, 1, lines.length)) : "";
    }

    private int calculateMultilineIndent(Yaml.Mapping.Entry entry) {
        String[] lines = LINE_BREAK.split(entry.getPrefix());
        int keyIndent = (lines.length > 1 ? lines[lines.length - 1] : "").length();
        int indent = StringUtils.minCommonIndentLevel((String)this.substringOfAfterFirstLineBreak(((Yaml.Scalar)entry.getValue()).getValue()));
        return Math.max(indent - keyIndent, 0);
    }

    @Generated
    public MergeYamlVisitor(Yaml existing, Yaml incoming, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, @Nullable String insertBefore) {
        this.existing = existing;
        this.incoming = incoming;
        this.acceptTheirs = acceptTheirs;
        this.objectIdentifyingProperty = objectIdentifyingProperty;
        this.insertBefore = insertBefore;
    }
}

