/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.Tree;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class CountLinesVisitor
extends YamlVisitor<AtomicInteger> {
    @Override
    public Yaml visitDocuments(Yaml.Documents documents, AtomicInteger count) {
        if (documents.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitDocuments(documents, count);
    }

    @Override
    public Yaml visitDocument(Yaml.Document document, AtomicInteger count) {
        if (document.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitDocument(document, count);
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, AtomicInteger count) {
        if (mapping.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitMapping(mapping, count);
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, AtomicInteger count) {
        if (entry.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitMappingEntry(entry, count);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, AtomicInteger count) {
        if (scalar.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitScalar(scalar, count);
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence sequence, AtomicInteger count) {
        if (sequence.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitSequence(sequence, count);
    }

    @Override
    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, AtomicInteger count) {
        if (entry.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitSequenceEntry(entry, count);
    }

    @Override
    public Yaml visitAnchor(Yaml.Anchor anchor, AtomicInteger count) {
        if (anchor.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitAnchor(anchor, count);
    }

    @Override
    public Yaml visitAlias(Yaml.Alias alias, AtomicInteger count) {
        if (alias.getPrefix().contains("\n")) {
            count.incrementAndGet();
        }
        return super.visitAlias(alias, count);
    }

    public static int countLines(Tree tree) {
        return ((AtomicInteger)new CountLinesVisitor().reduce(tree, new AtomicInteger())).get();
    }
}

