/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.format;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.format.IndentsVisitor;
import org.openrewrite.yaml.format.MinimumViableSpacingVisitor;
import org.openrewrite.yaml.format.NormalizeFormatVisitor;
import org.openrewrite.yaml.format.NormalizeLineBreaksVisitor;
import org.openrewrite.yaml.style.Autodetect;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.style.YamlDefaultStyles;
import org.openrewrite.yaml.tree.Yaml;

public class AutoFormatVisitor<P>
extends YamlIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public @Nullable Yaml preVisit(Yaml tree, P p) {
        this.stopAfterPreVisit();
        Yaml.Documents docs = (Yaml.Documents)this.getCursor().firstEnclosingOrThrow(Yaml.Documents.class);
        Cursor cursor = this.getCursor().getParentOrThrow();
        Yaml y = (Yaml)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        y = (Yaml)new MinimumViableSpacingVisitor(this.stopAfter).visit(y, p, cursor.fork());
        y = new IndentsVisitor(Optional.ofNullable((IndentsStyle)docs.getStyle(IndentsStyle.class)).orElse(Autodetect.tabsAndIndents(docs, YamlDefaultStyles.indents())), this.stopAfter).visit((Tree)y, (Object)p, cursor.fork());
        y = (Yaml)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)docs.getStyle(GeneralFormatStyle.class)).orElse(Autodetect.generalFormat(docs)), this.stopAfter).visit(y, p, cursor.fork());
        return y;
    }

    @Override
    public Yaml.Documents visitDocuments(Yaml.Documents documents, P p) {
        Yaml.Documents y = (Yaml.Documents)new NormalizeFormatVisitor(this.stopAfter).visit((Tree)documents, (Object)p);
        y = (Yaml.Documents)new MinimumViableSpacingVisitor(this.stopAfter).visit((Tree)y, (Object)p);
        y = (Yaml.Documents)new IndentsVisitor(Optional.ofNullable((IndentsStyle)documents.getStyle(IndentsStyle.class)).orElse(Autodetect.tabsAndIndents(y, YamlDefaultStyles.indents())), this.stopAfter).visit((Tree)documents, (Object)p);
        y = (Yaml.Documents)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)documents.getStyle(GeneralFormatStyle.class)).orElse(Autodetect.generalFormat(y)), this.stopAfter).visit((Tree)documents, (Object)p);
        assert (y != null);
        return y;
    }

    public @Nullable Yaml postVisit(Yaml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Yaml.Documents.class, "stop", (Object)true);
        }
        return (Yaml)super.postVisit((Tree)tree, p);
    }

    public @Nullable Yaml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Yaml)tree;
        }
        return (Yaml)super.visit(tree, p);
    }
}

