/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class MergeYamlVisitor<P>
extends YamlVisitor<P> {
    private final Yaml scope;
    private final Yaml incoming;
    private final boolean acceptTheirs;
    @Nullable
    private final String objectIdentifyingProperty;
    private boolean shouldAutoFormat = true;

    public MergeYamlVisitor(Yaml scope, @Language(value="yml") String yamlString, boolean acceptTheirs, @Nullable String objectIdentifyingProperty) {
        this(scope, new YamlParser().parse(yamlString).get(0).getDocuments().get(0).getBlock(), acceptTheirs, objectIdentifyingProperty);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar existingScalar, P p) {
        if (this.scope.isScope(existingScalar) && this.incoming instanceof Yaml.Scalar) {
            return this.mergeScalar(existingScalar, (Yaml.Scalar)this.incoming);
        }
        return super.visitScalar(existingScalar, p);
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence existingSeq, P p) {
        if (this.scope.isScope(existingSeq)) {
            if (this.incoming instanceof Yaml.Mapping) {
                return existingSeq.withEntries(ListUtils.map(existingSeq.getEntries(), (i, existingSeqEntry) -> {
                    Yaml.Block b = (Yaml.Block)new MergeYamlVisitor<P>(existingSeqEntry.getBlock(), this.incoming, this.acceptTheirs, this.objectIdentifyingProperty, this.shouldAutoFormat).visit(existingSeqEntry.getBlock(), p, this.getCursor());
                    return existingSeqEntry.withBlock(Objects.requireNonNull(b));
                }));
            }
            if (this.incoming instanceof Yaml.Sequence) {
                return this.mergeSequence(existingSeq, (Yaml.Sequence)this.incoming, p, this.getCursor());
            }
        }
        return super.visitSequence(existingSeq, p);
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping existingMapping, P p) {
        if (this.scope.isScope(existingMapping)) {
            return this.mergeMapping(existingMapping, (Yaml.Mapping)this.incoming, p, this.getCursor());
        }
        return super.visitMapping(existingMapping, p);
    }

    private static boolean keyMatches(Yaml.Mapping.Entry e1, Yaml.Mapping.Entry e2) {
        return e1.getKey().getValue().equals(e2.getKey().getValue());
    }

    private boolean keyMatches(Yaml.Mapping m1, Yaml.Mapping m2) {
        Optional<String> nameToAdd = m2.getEntries().stream().filter(e -> this.objectIdentifyingProperty != null && this.objectIdentifyingProperty.equals(e.getKey().getValue())).map(e -> ((Yaml.Scalar)e.getValue()).getValue()).findAny();
        return nameToAdd.map(nameToAddValue -> m1.getEntries().stream().filter(e -> this.objectIdentifyingProperty.equals(e.getKey().getValue())).map(e -> ((Yaml.Scalar)e.getValue()).getValue()).anyMatch(existingName -> existingName.equals(nameToAddValue))).orElse(false);
    }

    private Yaml.Mapping mergeMapping(Yaml.Mapping m1, Yaml.Mapping m2, P p, Cursor cursor) {
        List mutatedEntries = ListUtils.map(m1.getEntries(), existingEntry -> {
            for (Yaml.Mapping.Entry incomingEntry : m2.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)) continue;
                return existingEntry.withValue((Yaml.Block)new MergeYamlVisitor<P>(existingEntry.getValue(), incomingEntry.getValue(), this.acceptTheirs, this.objectIdentifyingProperty, this.shouldAutoFormat).visit(existingEntry.getValue(), p, new Cursor(cursor, existingEntry)));
            }
            return existingEntry;
        });
        mutatedEntries = ListUtils.concatAll((List)mutatedEntries, (List)ListUtils.map(m2.getEntries(), incomingEntry -> {
            for (Yaml.Mapping.Entry existingEntry : m1.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)) continue;
                return null;
            }
            if (this.shouldAutoFormat) {
                return this.autoFormat(incomingEntry, p, cursor);
            }
            return incomingEntry;
        }));
        return m1.withEntries(mutatedEntries);
    }

    private Yaml.Sequence mergeSequence(Yaml.Sequence s1, Yaml.Sequence s2, P p, Cursor cursor) {
        if (this.acceptTheirs) {
            return s1;
        }
        boolean isSequenceOfScalars = s2.getEntries().stream().allMatch(entry -> entry.getBlock() instanceof Yaml.Scalar);
        if (isSequenceOfScalars) {
            ArrayList<Yaml.Sequence.Entry> incomingEntries = new ArrayList<Yaml.Sequence.Entry>(s2.getEntries());
            block0: for (Yaml.Sequence.Entry entry2 : s1.getEntries()) {
                if (!(entry2.getBlock() instanceof Yaml.Scalar)) continue;
                String existingScalar = ((Yaml.Scalar)entry2.getBlock()).getValue();
                for (Yaml.Sequence.Entry incomingEntry2 : incomingEntries) {
                    if (!((Yaml.Scalar)incomingEntry2.getBlock()).getValue().equals(existingScalar)) continue;
                    incomingEntries.remove(incomingEntry2);
                    continue block0;
                }
            }
            return s1.withEntries(ListUtils.concatAll(s1.getEntries(), (List)ListUtils.map(incomingEntries, incomingEntry -> this.autoFormat(incomingEntry, p, cursor))));
        }
        if (this.objectIdentifyingProperty == null) {
            return s1;
        }
        List mutatedEntries = ListUtils.map(s2.getEntries(), entry -> {
            Yaml.Mapping incomingMapping = (Yaml.Mapping)entry.getBlock();
            for (Yaml.Sequence.Entry existingEntry : s1.getEntries()) {
                Yaml.Mapping existingMapping = (Yaml.Mapping)existingEntry.getBlock();
                if (!this.keyMatches(existingMapping, incomingMapping)) continue;
                return existingEntry.withBlock(this.mergeMapping(existingMapping, incomingMapping, p, cursor));
            }
            return entry;
        });
        return s1.withEntries(ListUtils.concatAll(s1.getEntries().stream().filter(entry -> !mutatedEntries.contains(entry)).collect(Collectors.toList()), (List)ListUtils.map((List)mutatedEntries, entry -> this.autoFormat(entry, p, cursor))));
    }

    private Yaml.Scalar mergeScalar(Yaml.Scalar y1, Yaml.Scalar y2) {
        String s2;
        String s1 = y1.getValue();
        return !s1.equals(s2 = y2.getValue()) && !this.acceptTheirs ? y1.withValue(s2) : y1;
    }

    public MergeYamlVisitor(Yaml scope, Yaml incoming, boolean acceptTheirs, @Nullable String objectIdentifyingProperty, boolean shouldAutoFormat) {
        this.scope = scope;
        this.incoming = incoming;
        this.acceptTheirs = acceptTheirs;
        this.objectIdentifyingProperty = objectIdentifyingProperty;
        this.shouldAutoFormat = shouldAutoFormat;
    }

    public MergeYamlVisitor(Yaml scope, Yaml incoming, boolean acceptTheirs, @Nullable String objectIdentifyingProperty) {
        this.scope = scope;
        this.incoming = incoming;
        this.acceptTheirs = acceptTheirs;
        this.objectIdentifyingProperty = objectIdentifyingProperty;
    }
}

