/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.yaml.tree.Yaml;

public class XPathMatcher {
    private final String expression;

    public XPathMatcher(String expression) {
        this.expression = expression;
    }

    public boolean matches(Cursor cursor) {
        List path = cursor.getPathAsStream().filter(p -> p instanceof Yaml.Mapping.Entry).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toList());
        if (this.expression.startsWith("//") || !this.expression.startsWith("/")) {
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList((this.expression.startsWith("//") ? this.expression.substring(2) : this.expression).split("/")));
            Collections.reverse(parts);
            int pathIndex = 0;
            int i = 0;
            while (i < parts.size()) {
                String part = (String)parts.get(i);
                if (path.size() < i + 1 || !((Yaml.Mapping.Entry)path.get(pathIndex)).getKey().getValue().equals(part) && !part.equals("*")) {
                    return false;
                }
                ++i;
                ++pathIndex;
            }
            return this.expression.startsWith("/") || path.size() - pathIndex <= 1;
        }
        if (this.expression.startsWith("/")) {
            Collections.reverse(path);
            String[] parts = this.expression.substring(1).split("/");
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (path.size() >= i + 1 && (((Yaml.Mapping.Entry)path.get(i)).getKey().getValue().equals(part) || part.equals("*"))) continue;
                return false;
            }
            return cursor.getValue() instanceof Yaml.Mapping.Entry && path.size() == parts.length;
        }
        return false;
    }
}

