/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.CoalescePropertiesVisitor;
import org.openrewrite.yaml.cleanup.RemoveUnusedVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlVisitor<P>
extends TreeVisitor<Yaml, P> {
    public String getLanguage() {
        return "yaml";
    }

    public Yaml visitDocuments(Yaml.Documents documents, P p) {
        return documents.withDocuments(ListUtils.map(documents.getDocuments(), d -> (Yaml.Document)this.visitAndCast((Tree)d, p))).withMarkers(this.visitMarkers(documents.getMarkers(), p));
    }

    public Yaml visitDocument(Yaml.Document document, P p) {
        return document.withBlock((Yaml.Block)this.visit(document.getBlock(), p)).withMarkers(this.visitMarkers(document.getMarkers(), p));
    }

    public Yaml visitMapping(Yaml.Mapping mapping, P p) {
        return mapping.withEntries(ListUtils.map(mapping.getEntries(), e -> (Yaml.Mapping.Entry)this.visitAndCast((Tree)e, p))).withMarkers(this.visitMarkers(mapping.getMarkers(), p));
    }

    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        Yaml.Mapping.Entry e = entry;
        e = e.withKey((Yaml.Scalar)this.visitAndCast(e.getKey(), p));
        e = e.withValue((Yaml.Block)this.visitAndCast(e.getValue(), p));
        return e.withMarkers(this.visitMarkers(e.getMarkers(), p));
    }

    public Yaml visitScalar(Yaml.Scalar scalar, P p) {
        return scalar.withMarkers(this.visitMarkers(scalar.getMarkers(), p));
    }

    public Yaml visitSequence(Yaml.Sequence sequence, P p) {
        return sequence.withEntries(ListUtils.map(sequence.getEntries(), e -> (Yaml.Sequence.Entry)this.visitAndCast((Tree)e, p))).withMarkers(this.visitMarkers(sequence.getMarkers(), p));
    }

    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
        return entry.withBlock((Yaml.Block)this.visitAndCast(entry.getBlock(), p)).withMarkers(this.visitMarkers(entry.getMarkers(), p));
    }

    public void maybeCoalesceProperties() {
        if (this.getAfterVisit().stream().noneMatch(CoalescePropertiesVisitor.class::isInstance)) {
            this.doAfterVisit(new CoalescePropertiesVisitor());
        }
    }

    public void removeUnused() {
        if (this.getAfterVisit().stream().noneMatch(RemoveUnusedVisitor.class::isInstance)) {
            this.doAfterVisit(new RemoveUnusedVisitor());
        }
    }
}

