/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DeleteProperty
extends Recipe {
    @Option(displayName="Property key", description="The key to be deleted.", example="management.metrics.binders.files.enabled")
    private final String propertyKey;
    @Option(displayName="Coalesce", description="Simplify nested map hierarchies into their simplest dot separated property form.", example="true")
    private final Boolean coalesce;
    @Option(displayName="Use relaxed binding", description="Whether to match the `propertyKey` using [relaxed binding](https://docs.spring.io/spring-boot/docs/2.5.6/reference/html/features.html#features.external-config.typesafe-configuration-properties.relaxed-binding) rules. Default is `true`. Set to `false`  to use exact matching.", required=false)
    @Nullable
    @Incubating(since="7.17.0")
    private final Boolean relaxedBinding;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.yml")
    @Nullable
    @Incubating(since="7.8.0")
    private final String fileMatcher;

    public String getDisplayName() {
        return "Delete property";
    }

    public String getDescription() {
        return "Delete a YAML property. Nested YAML mappings are interpreted as dot separated property names, i.e.  as Spring Boot interprets application.yml files.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public YamlVisitor<ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml e = super.visitMappingEntry(entry, ctx);
                Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
                String prop = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
                if (!Boolean.FALSE.equals(DeleteProperty.this.relaxedBinding) ? NameCaseConvention.equalsRelaxedBinding((String)prop, (String)DeleteProperty.this.propertyKey) : prop.equals(DeleteProperty.this.propertyKey)) {
                    this.doAfterVisit(new DeletePropertyVisitor(entry));
                    if (DeleteProperty.this.coalesce.booleanValue()) {
                        this.maybeCoalesceProperties();
                    }
                }
                return e;
            }
        };
    }

    public DeleteProperty(String propertyKey, Boolean coalesce, @Nullable Boolean relaxedBinding, @Nullable String fileMatcher) {
        this.propertyKey = propertyKey;
        this.coalesce = coalesce;
        this.relaxedBinding = relaxedBinding;
        this.fileMatcher = fileMatcher;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public Boolean getCoalesce() {
        return this.coalesce;
    }

    @Nullable
    public Boolean getRelaxedBinding() {
        return this.relaxedBinding;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "DeleteProperty(propertyKey=" + this.getPropertyKey() + ", coalesce=" + this.getCoalesce() + ", relaxedBinding=" + this.getRelaxedBinding() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteProperty)) {
            return false;
        }
        DeleteProperty other = (DeleteProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$coalesce = this.getCoalesce();
        Boolean other$coalesce = other.getCoalesce();
        if (this$coalesce == null ? other$coalesce != null : !((Object)this$coalesce).equals(other$coalesce)) {
            return false;
        }
        Boolean this$relaxedBinding = this.getRelaxedBinding();
        Boolean other$relaxedBinding = other.getRelaxedBinding();
        if (this$relaxedBinding == null ? other$relaxedBinding != null : !((Object)this$relaxedBinding).equals(other$relaxedBinding)) {
            return false;
        }
        String this$propertyKey = this.getPropertyKey();
        String other$propertyKey = other.getPropertyKey();
        if (this$propertyKey == null ? other$propertyKey != null : !this$propertyKey.equals(other$propertyKey)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $coalesce = this.getCoalesce();
        result = result * 59 + ($coalesce == null ? 43 : ((Object)$coalesce).hashCode());
        Boolean $relaxedBinding = this.getRelaxedBinding();
        result = result * 59 + ($relaxedBinding == null ? 43 : ((Object)$relaxedBinding).hashCode());
        String $propertyKey = this.getPropertyKey();
        result = result * 59 + ($propertyKey == null ? 43 : $propertyKey.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }

    private static class DeletePropertyVisitor<P>
    extends YamlVisitor<P> {
        private final Yaml.Mapping.Entry scope;

        private DeletePropertyVisitor(Yaml.Mapping.Entry scope) {
            this.scope = scope;
        }

        @Override
        public Yaml visitMapping(Yaml.Mapping mapping, P p) {
            Yaml.Mapping m = (Yaml.Mapping)super.visitMapping(mapping, p);
            boolean changed = false;
            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList();
            for (Yaml.Mapping.Entry entry : m.getEntries()) {
                if (entry == this.scope || entry.getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)entry.getValue()).getEntries().isEmpty()) {
                    changed = true;
                    continue;
                }
                entries.add(entry);
            }
            if (entries.size() == 1) {
                entries = ListUtils.map(entries, e -> e.withPrefix(""));
            }
            if (changed) {
                Yaml.Document document;
                m = m.withEntries(entries);
                if (this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document && !(document = (Yaml.Document)this.getCursor().getParentOrThrow().getValue()).isExplicit()) {
                    m = m.withEntries(m.getEntries());
                }
            }
            return m;
        }
    }
}

