/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression to locate a YAML entry.", example="$.source.kind")
    private final String keyPath;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.yml")
    @Nullable
    @Incubating(since="7.8.0")
    private final String fileMatcher;

    public String getDisplayName() {
        return "Delete key";
    }

    public String getDescription() {
        return "Delete a YAML mapping entry key.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.keyPath);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext executionContext) {
                if (matcher.matches(this.getCursor()) || matcher.matches(new Cursor(this.getCursor(), (Object)entry.getBlock()))) {
                    return null;
                }
                return super.visitSequenceEntry(entry, executionContext);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml m = super.visitMapping(mapping, ctx);
                AtomicReference copyFirstPrefix = new AtomicReference();
                if (!((Yaml.Mapping)(m = ((Yaml.Mapping)m).withEntries(ListUtils.map(((Yaml.Mapping)m).getEntries(), (i, e) -> {
                    if (matcher.matches(new Cursor(this.getCursor(), e))) {
                        if (i == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Sequence.Entry) {
                            copyFirstPrefix.set(e.getPrefix());
                        }
                        this.removeUnused();
                        return null;
                    }
                    return e;
                })))).getEntries().isEmpty() && copyFirstPrefix.get() != null) {
                    m = ((Yaml.Mapping)m).withEntries(ListUtils.mapFirst(((Yaml.Mapping)m).getEntries(), e -> e.withPrefix((String)copyFirstPrefix.get())));
                }
                return m;
            }
        };
    }

    public DeleteKey(String keyPath, @Nullable String fileMatcher) {
        this.keyPath = keyPath;
        this.fileMatcher = fileMatcher;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

