/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.CoalesceProperties;
import org.openrewrite.yaml.tree.Yaml;

public class YamlVisitor<P>
extends TreeVisitor<Yaml, P> {
    public Yaml visitDocuments(Yaml.Documents documents, P p) {
        return documents.withDocuments(ListUtils.map(documents.getDocuments(), d -> (Yaml.Document)this.visitAndCast((Tree)d, p)));
    }

    public Yaml visitDocument(Yaml.Document document, P p) {
        return document.withBlocks(ListUtils.map(document.getBlocks(), b -> (Yaml.Block)this.visitAndCast((Tree)b, p)));
    }

    public Yaml visitMapping(Yaml.Mapping mapping, P p) {
        return mapping.withEntries(ListUtils.map(mapping.getEntries(), e -> (Yaml.Mapping.Entry)this.visitAndCast((Tree)e, p)));
    }

    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, P p) {
        Yaml.Mapping.Entry e = entry;
        e = e.withKey((Yaml.Scalar)this.visitAndCast(e.getKey(), p));
        return e.withValue((Yaml.Block)this.visitAndCast(e.getValue(), p));
    }

    public Yaml visitScalar(Yaml.Scalar scalar, P p) {
        return scalar;
    }

    public Yaml visitSequence(Yaml.Sequence sequence, P p) {
        return sequence.withEntries(ListUtils.map(sequence.getEntries(), e -> (Yaml.Sequence.Entry)this.visitAndCast((Tree)e, p)));
    }

    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, P p) {
        return entry.withBlock((Yaml.Block)this.visitAndCast(entry.getBlock(), p));
    }

    public void maybeCoalesceProperties() {
        if (this.getAfterVisit().stream().noneMatch(CoalesceProperties.CoalescePropertiesVisitor.class::isInstance)) {
            this.doAfterVisit(new CoalesceProperties());
        }
    }
}

