/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.WhitespaceValidationService;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class XmlWhitespaceValidationService
implements WhitespaceValidationService {
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Attribute visitAttribute(Xml.Attribute attribute, ExecutionContext executionContext) {
                Xml a = super.visitAttribute(attribute, executionContext);
                return ((Xml.Attribute)a).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.Attribute)a).getPrefix()));
            }

            @Override
            public Xml.CharData visitCharData(Xml.CharData charData, ExecutionContext executionContext) {
                Xml c = super.visitCharData(charData, executionContext);
                c = ((Xml.CharData)c).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.CharData)c).getPrefix()));
                return ((Xml.CharData)c).withAfterText(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.CharData)c).getAfterText()));
            }

            @Override
            public Xml.Comment visitComment(Xml.Comment comment, ExecutionContext executionContext) {
                Xml c = super.visitComment(comment, executionContext);
                return ((Xml.Comment)c).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.Comment)c).getPrefix()));
            }

            @Override
            public Xml.DocTypeDecl visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, ExecutionContext executionContext) {
                Xml d = super.visitDocTypeDecl(docTypeDecl, executionContext);
                return ((Xml.DocTypeDecl)d).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.DocTypeDecl)d).getPrefix()));
            }

            @Override
            public Xml.Element visitElement(Xml.Element element, ExecutionContext executionContext) {
                Xml e = super.visitElement(element, executionContext);
                return ((Xml.Element)e).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.Element)e).getPrefix()));
            }

            @Override
            public Xml.Ident visitIdent(Xml.Ident ident, ExecutionContext executionContext) {
                Xml i = super.visitIdent(ident, executionContext);
                return ((Xml.Ident)i).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.Ident)i).getPrefix()));
            }

            @Override
            public Xml.XmlDecl visitXmlDecl(Xml.XmlDecl xmlDecl, ExecutionContext executionContext) {
                Xml x = super.visitXmlDecl(xmlDecl, executionContext);
                return ((Xml.XmlDecl)x).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.XmlDecl)x).getPrefix()));
            }

            @Override
            public Xml.ProcessingInstruction visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, ExecutionContext executionContext) {
                Xml p = super.visitProcessingInstruction(processingInstruction, executionContext);
                return ((Xml.ProcessingInstruction)p).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.ProcessingInstruction)p).getPrefix()));
            }

            @Override
            public Xml.Prolog visitProlog(Xml.Prolog prolog, ExecutionContext executionContext) {
                Xml p = super.visitProlog(prolog, executionContext);
                return ((Xml.Prolog)p).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.Prolog)p).getPrefix()));
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml t = super.visitTag(tag, executionContext);
                return ((Xml.Tag)t).withPrefix(XmlWhitespaceValidationService.withNonWhitespaceWarning(((Xml.Tag)t).getPrefix()));
            }
        };
    }

    private static String withNonWhitespaceWarning(String s) {
        if (StringUtils.isBlank((String)s)) {
            return s;
        }
        return "~~(non-whitespace)~~>" + s + "<~~";
    }
}

