/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class AddTagAttribute
extends Recipe {
    @Option(displayName="Element name", description="The name of the element whose attribute's value is to be added. Interpreted as an XPath expression.", example="//beans/bean")
    private final String elementName;
    @Option(displayName="Attribute name", description="The name of the new attribute.", example="attribute-name")
    private final String attributeName;
    @Option(displayName="New value", description="The new value to be used for key specified by `attributeName`.", example="value-to-add")
    private final String newValue;

    public String getDisplayName() {
        return "Add new XML attribute for an Element";
    }

    public String getDescription() {
        return "Add new XML attribute with value on a specified element.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (!new XPathMatcher(AddTagAttribute.this.elementName).matches(this.getCursor())) {
                    return t;
                }
                for (Xml.Attribute attr : t.getAttributes()) {
                    if (!AddTagAttribute.this.attributeName.equals(attr.getKeyAsString())) continue;
                    return t;
                }
                Xml.Ident name = new Xml.Ident(Tree.randomId(), "", Markers.EMPTY, AddTagAttribute.this.attributeName);
                Xml.Attribute.Value value = new Xml.Attribute.Value(Tree.randomId(), "", Markers.EMPTY, Xml.Attribute.Value.Quote.Double, AddTagAttribute.this.newValue);
                return t.withAttributes(ListUtils.concat(t.getAttributes(), (Object)new Xml.Attribute(Tree.randomId(), " ", Markers.EMPTY, name, "", value)));
            }
        };
    }

    @Generated
    public AddTagAttribute(String elementName, String attributeName, String newValue) {
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.newValue = newValue;
    }

    @Generated
    public String getElementName() {
        return this.elementName;
    }

    @Generated
    public String getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddTagAttribute(elementName=" + this.getElementName() + ", attributeName=" + this.getAttributeName() + ", newValue=" + this.getNewValue() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTagAttribute)) {
            return false;
        }
        AddTagAttribute other = (AddTagAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddTagAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }
}

