/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.trait.Namespaced;
import org.openrewrite.xml.tree.Xml;

public final class FindNamespacePrefix
extends Recipe {
    @Option(displayName="Namespace prefix", description="The Namespace Prefix to find.", example="http://www.w3.org/2001/XMLSchema-instance")
    private final String namespacePrefix;
    @Option(displayName="XPath", description="An XPath expression used to find namespace URIs.", example="/dependencies/dependency", required=false)
    private final @Nullable String xPath;

    public String getDisplayName() {
        return "Find XML namespace prefixes";
    }

    public String getDescription() {
        return "Find XML namespace prefixes, optionally restricting the search by a XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Namespaced.matcher().xPath(this.xPath).prefix(this.namespacePrefix).asVisitor(n -> n.getTree() instanceof Xml.Tag ? SearchResult.found((Tree)((Xml)n.getTree())) : n.getTree());
    }

    public static Set<Xml.Tag> find(Xml x, String namespacePrefix, @Nullable String xPath) {
        LinkedHashSet<Xml.Tag> ts = new LinkedHashSet<Xml.Tag>();
        Namespaced.matcher().xPath(xPath).prefix(namespacePrefix).asVisitor(n -> {
            if (n.getTree() instanceof Xml.Tag) {
                ts.add((Xml.Tag)n.getTree());
            }
            return n.getTree();
        }).visit((Tree)x, (Object)0);
        return ts;
    }

    @Generated
    public FindNamespacePrefix(String namespacePrefix, @Nullable String xPath) {
        this.namespacePrefix = namespacePrefix;
        this.xPath = xPath;
    }

    @Generated
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Generated
    public @Nullable String getXPath() {
        return this.xPath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindNamespacePrefix(namespacePrefix=" + this.getNamespacePrefix() + ", xPath=" + this.getXPath() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindNamespacePrefix)) {
            return false;
        }
        FindNamespacePrefix other = (FindNamespacePrefix)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespacePrefix = this.getNamespacePrefix();
        String other$namespacePrefix = other.getNamespacePrefix();
        if (this$namespacePrefix == null ? other$namespacePrefix != null : !this$namespacePrefix.equals(other$namespacePrefix)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        return !(this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindNamespacePrefix;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespacePrefix = this.getNamespacePrefix();
        result = result * 59 + ($namespacePrefix == null ? 43 : $namespacePrefix.hashCode());
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        return result;
    }
}

