/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class RemoveContentVisitor<P>
extends XmlVisitor<P> {
    private final Content scope;
    private final boolean removeEmptyAncestors;

    public RemoveContentVisitor(Content tag, boolean removeEmptyAncestors) {
        this.scope = tag;
        this.removeEmptyAncestors = removeEmptyAncestors;
    }

    @Override
    public Xml visitTag(Xml.Tag tag, P p) {
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, p);
        if (t.getContent() != null) {
            for (Content content : t.getContent()) {
                if (!this.scope.isScope(content)) continue;
                ArrayList<? extends Content> contents = new ArrayList<Content>(t.getContent());
                contents.remove(content);
                if (this.removeEmptyAncestors && contents.isEmpty() && t.getAttributes().isEmpty()) {
                    if (this.getCursor().getParentOrThrow().getValue() instanceof Xml.Document) {
                        return t.withContent(null).withClosing(null);
                    }
                    this.doAfterVisit(new RemoveContentVisitor<P>(t, true));
                    continue;
                }
                return t.withContent(contents);
            }
        }
        return t;
    }
}

