/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

@Incubating(since="7.24.0")
public final class AddCommentToXmlTag
extends Recipe {
    @Option(displayName="XPath", description="An XPath expression used to find matching tags.", example="/project/dependencies/dependency")
    private final String xPath;
    @Option(displayName="Comment text", description="The text to add as a comment..", example="This is excluded due to CVE <X> and will be removed when we upgrade the next version is available.")
    private final String commentText;

    public String getDisplayName() {
        return "Add a comment to an XML tag";
    }

    public String getDescription() {
        return "Adds a comment as the first element in an XML tag.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){
            final XPathMatcher matcher;
            {
                this.matcher = new XPathMatcher(AddCommentToXmlTag.this.xPath);
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                ArrayList<? extends Content> contents;
                boolean containsComment;
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (this.matcher.matches(this.getCursor()) && tag.getContent() != null && !(containsComment = (contents = new ArrayList<Content>(tag.getContent())).stream().anyMatch(c -> c instanceof Xml.Comment && AddCommentToXmlTag.this.commentText.equals(((Xml.Comment)c).getText())))) {
                    int insertPos = 0;
                    Xml.Comment customComment = new Xml.Comment(Tree.randomId(), ((Content)contents.get(insertPos)).getPrefix(), Markers.EMPTY, AddCommentToXmlTag.this.commentText);
                    contents.add(insertPos, customComment);
                    t = t.withContent(contents);
                }
                return t;
            }
        };
    }

    public AddCommentToXmlTag(String xPath, String commentText) {
        this.xPath = xPath;
        this.commentText = commentText;
    }

    public String getXPath() {
        return this.xPath;
    }

    public String getCommentText() {
        return this.commentText;
    }

    @NonNull
    public String toString() {
        return "AddCommentToXmlTag(xPath=" + this.getXPath() + ", commentText=" + this.getCommentText() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCommentToXmlTag)) {
            return false;
        }
        AddCommentToXmlTag other = (AddCommentToXmlTag)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        if (this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath)) {
            return false;
        }
        String this$commentText = this.getCommentText();
        String other$commentText = other.getCommentText();
        return !(this$commentText == null ? other$commentText != null : !this$commentText.equals(other$commentText));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddCommentToXmlTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        String $commentText = this.getCommentText();
        result = result * 59 + ($commentText == null ? 43 : $commentText.hashCode());
        return result;
    }
}

