/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.xml.search.FindTags;
import org.openrewrite.xml.tree.Xml;

public class XPathMatcher {
    private static final Pattern PATTERN = Pattern.compile("([-\\w]+)\\[([-\\w]+)='([-\\w.]+)']");
    private final String expression;

    public XPathMatcher(String expression) {
        this.expression = expression;
    }

    public boolean matches(Cursor cursor) {
        List path = cursor.getPathAsStream().filter(p -> p instanceof Xml.Tag).map(Xml.Tag.class::cast).collect(Collectors.toList());
        if (this.expression.startsWith("//") || !this.expression.startsWith("/")) {
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList((this.expression.startsWith("//") ? this.expression.substring(2) : this.expression).split("/")));
            Collections.reverse(parts);
            int pathIndex = 0;
            int i = 0;
            while (i < parts.size()) {
                String part = (String)parts.get(i);
                if (part.startsWith("@")) {
                    if (!(cursor.getValue() instanceof Xml.Attribute && ((Xml.Attribute)cursor.getValue()).getKeyAsString().equals(part.substring(1)) || "*".equals(part.substring(1)))) {
                        return false;
                    }
                    --pathIndex;
                } else if (path.size() < i + 1 || !((Xml.Tag)path.get(pathIndex)).getName().equals(part) && !"*".equals(part)) {
                    return false;
                }
                ++i;
                ++pathIndex;
            }
            return this.expression.startsWith("/") || path.size() - pathIndex <= 1;
        }
        if (this.expression.startsWith("/")) {
            Collections.reverse(path);
            String[] parts = this.expression.substring(1).split("/");
            if (this.expression.contains("//") && Arrays.stream(parts).anyMatch(StringUtils::isBlank)) {
                int blankPartIndex = Arrays.asList(parts).indexOf("");
                int doubleSlashIndex = this.expression.indexOf("//");
                if (path.size() > blankPartIndex && path.size() >= parts.length - 1) {
                    String newExpression = Objects.equals(((Xml.Tag)path.get(blankPartIndex)).getName(), parts[blankPartIndex + 1]) ? String.format("%s/%s", this.expression.substring(0, doubleSlashIndex), this.expression.substring(doubleSlashIndex + 2)) : String.format("%s/%s/%s", this.expression.substring(0, doubleSlashIndex), ((Xml.Tag)path.get(blankPartIndex)).getName(), this.expression.substring(doubleSlashIndex + 2));
                    return new XPathMatcher(newExpression).matches(cursor);
                }
            }
            if (parts.length > path.size() + 1) {
                return false;
            }
            for (int i = 0; i < parts.length; ++i) {
                String partName;
                String part = parts[i];
                Xml.Tag tag = i < path.size() ? (Xml.Tag)path.get(i) : null;
                Matcher matcher = PATTERN.matcher(part);
                if (tag != null && matcher.matches()) {
                    String name = matcher.group(1);
                    String subTag = matcher.group(2);
                    String subTagValue = matcher.group(3);
                    boolean matchCondition = FindTags.find(tag, subTag).stream().anyMatch(t -> t.getValue().map(v -> v.equals(subTagValue)).orElse(false));
                    if (!matchCondition) {
                        return false;
                    }
                    partName = name;
                } else {
                    partName = part;
                }
                if (part.startsWith("@")) {
                    return cursor.getValue() instanceof Xml.Attribute && (((Xml.Attribute)cursor.getValue()).getKeyAsString().equals(part.substring(1)) || "*".equals(part.substring(1)));
                }
                if (path.size() >= i + 1 && (tag == null || tag.getName().equals(partName) || "*".equals(part))) continue;
                return false;
            }
            return cursor.getValue() instanceof Xml.Tag && path.size() == parts.length;
        }
        return false;
    }
}

