/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeTagValue
extends Recipe {
    @Option(displayName="Element name", description="The name of the element whose value is to be changed. Interpreted as an XPath Expression.", example="/settings/servers/server/username")
    private final String elementName;
    @Option(displayName="Old value", description="The old value of the tag.", required=false, example="user")
    @Nullable
    private final String oldValue;
    @Option(displayName="New value", description="The new value for the tag.", example="user")
    private final String newValue;

    public String getDisplayName() {
        return "Change XML tag value";
    }

    public String getDescription() {
        return "Alters the value of XML tags matching the provided expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){
            private final XPathMatcher xPathMatcher;
            {
                this.xPathMatcher = new XPathMatcher(ChangeTagValue.this.elementName);
            }

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.xPathMatcher.matches(this.getCursor()) && (ChangeTagValue.this.oldValue == null || ChangeTagValue.this.oldValue.equals(tag.getValue().orElse(null)))) {
                    this.doAfterVisit(new ChangeTagValueVisitor(tag, ChangeTagValue.this.newValue));
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    public ChangeTagValue(String elementName, @Nullable String oldValue, String newValue) {
        this.elementName = elementName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getElementName() {
        return this.elementName;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @NonNull
    public String toString() {
        return "ChangeTagValue(elementName=" + this.getElementName() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagValue)) {
            return false;
        }
        ChangeTagValue other = (ChangeTagValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTagValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }
}

