/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.marker.XmlSearchResult;
import org.openrewrite.xml.tree.Xml;

public final class FindTags
extends Recipe {
    @Option(displayName="XPath", description="XPath expression used to find matching tags.", example="/dependencies/dependency")
    private final String xPath;
    private final UUID id = Tree.randomId();

    public String getDisplayName() {
        return "Find XML tags";
    }

    public String getDescription() {
        return "Find XML tags by XPath expression.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher xPathMatcher = new XPathMatcher(this.xPath);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (xPathMatcher.matches(this.getCursor())) {
                    t = t.withMarkers(t.getMarkers().addOrUpdate((Marker)new XmlSearchResult(FindTags.this.id, FindTags.this)));
                }
                return t;
            }
        };
    }

    public static Set<Xml.Tag> find(Xml x, String xPath) {
        final XPathMatcher xPathMatcher = new XPathMatcher(xPath);
        XmlVisitor<Set<Xml.Tag>> findVisitor = new XmlVisitor<Set<Xml.Tag>>(){

            @Override
            public Xml visitTag(Xml.Tag tag, Set<Xml.Tag> ts) {
                if (xPathMatcher.matches(this.getCursor())) {
                    ts.add(tag);
                }
                return super.visitTag(tag, ts);
            }
        };
        HashSet<Xml.Tag> ts = new HashSet<Xml.Tag>();
        findVisitor.visit(x, ts);
        return ts;
    }

    public FindTags(String xPath) {
        this.xPath = xPath;
    }

    public String getXPath() {
        return this.xPath;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "FindTags(xPath=" + this.getXPath() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTags)) {
            return false;
        }
        FindTags other = (FindTags)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        if (this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTags;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

