/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class XmlPrinter<P>
extends XmlVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public XmlPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
        this.setCursoringOn();
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().peekMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(Xml xml, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)xml, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Xml visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Xml)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (Xml)tree;
    }

    public void visit(@Nullable List<? extends Xml> nodes, P p) {
        if (nodes != null) {
            for (Xml xml : nodes) {
                this.visit((Tree)xml, (Object)p);
            }
        }
    }

    @Override
    public Xml visitDocument(Xml.Document document, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(document.getPrefix());
        document = (Xml.Document)super.visitDocument(document, p);
        acc.append(document.getEof());
        return document;
    }

    @Override
    public Xml visitProlog(Xml.Prolog prolog, P p) {
        this.getPrinter().append(prolog.getPrefix());
        return super.visitProlog(prolog, p);
    }

    @Override
    public Xml visitTag(Xml.Tag tag, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(tag.getPrefix()).append('<').append(tag.getName());
        this.visit(tag.getAttributes(), p);
        acc.append(tag.getBeforeTagDelimiterPrefix());
        if (tag.getClosing() == null) {
            acc.append("/>");
        } else {
            acc.append('>');
            this.visit(tag.getContent(), p);
            acc.append(tag.getClosing().getPrefix()).append("</").append(tag.getClosing().getName()).append(tag.getClosing().getBeforeTagDelimiterPrefix()).append(">");
        }
        return tag;
    }

    @Override
    public Xml visitAttribute(Xml.Attribute attribute, P p) {
        StringBuilder acc = this.getPrinter();
        char valueDelim = Xml.Attribute.Value.Quote.Double.equals((Object)attribute.getValue().getQuote()) ? (char)'\"' : '\'';
        acc.append(attribute.getPrefix()).append(attribute.getKey().getPrefix()).append(attribute.getKeyAsString()).append('=').append(attribute.getValue().getPrefix()).append(valueDelim).append(attribute.getValueAsString()).append(valueDelim);
        return attribute;
    }

    @Override
    public Xml visitComment(Xml.Comment comment, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(comment.getPrefix()).append("<!--").append(comment.getText()).append("-->");
        return comment;
    }

    @Override
    public Xml visitProcessingInstruction(Xml.ProcessingInstruction pi, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(pi.getPrefix()).append("<?").append(pi.getName());
        this.visit(pi.getAttributes(), p);
        acc.append(pi.getBeforeTagDelimiterPrefix()).append("?>");
        return pi;
    }

    @Override
    public Xml visitCharData(Xml.CharData charData, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(charData.getPrefix());
        if (charData.isCdata()) {
            acc.append("<![CDATA[").append(charData.getText()).append("]]>");
        } else {
            acc.append(charData.getText());
        }
        acc.append(charData.getAfterText());
        return charData;
    }

    @Override
    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(docTypeDecl.getPrefix()).append("<!DOCTYPE");
        this.visit((Tree)docTypeDecl.getName(), (Object)p);
        this.visit((Tree)docTypeDecl.getExternalId(), (Object)p);
        this.visit(docTypeDecl.getInternalSubset(), p);
        if (docTypeDecl.getExternalSubsets() != null) {
            acc.append(docTypeDecl.getExternalSubsets().getPrefix()).append('[');
            this.visit(docTypeDecl.getExternalSubsets().getElements(), p);
            acc.append(']');
        }
        acc.append('>');
        return docTypeDecl;
    }

    @Override
    public Xml visitElement(Xml.Element element, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(element.getPrefix()).append("<!ELEMENT");
        this.visit(element.getSubset(), p);
        acc.append('>');
        return element;
    }

    @Override
    public Xml visitIdent(Xml.Ident ident, P p) {
        this.getPrinter().append(ident.getPrefix()).append(ident.getName());
        return ident;
    }
}

