/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.internal.XmlParserVisitor;
import org.openrewrite.xml.internal.grammar.XMLLexer;
import org.openrewrite.xml.internal.grammar.XMLParser;
import org.openrewrite.xml.tree.Xml;

public class XmlParser
implements Parser<Xml.Document> {
    public List<Xml.Document> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            try {
                XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer(CharStreams.fromStream((InputStream)sourceFile.getSource()))));
                return new XmlParserVisitor(sourceFile.getRelativePath(relativeTo), StringUtils.readFully((InputStream)sourceFile.getSource())).visitDocument(parser.document());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    public Xml.Tag parseTag(String tag) {
        XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer((CharStream)CharStreams.fromString((String)tag))));
        return (Xml.Tag)new XmlParserVisitor(null, tag).visitContent(parser.content());
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".xml");
    }
}

