/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Tree;
import org.openrewrite.refactor.Formatter;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class AutoFormat
extends XmlRefactorVisitor {
    private final Xml.Tag[] scope;

    public AutoFormat(Xml.Tag ... scope) {
        this.scope = scope;
        this.setCursoringOn();
    }

    public Xml reduce(Xml r1, Xml r2) {
        Xml x = (Xml)super.reduce((Object)r1, (Object)r2);
        if (r2 != null && r2.getPrefix().startsWith("|")) {
            x = (Xml)x.withPrefix(r2.getPrefix().substring(1));
        }
        return x;
    }

    public Xml visitTree(Tree tree) {
        Xml x = (Xml)super.visitTree(tree);
        String prefix = tree.getPrefix();
        if (prefix.contains("\n") && Arrays.stream(this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) {
            int indentMultiple = (int)this.getCursor().getPathAsStream().filter(Xml.Tag.class::isInstance).count() - 1;
            Formatter.Result wholeSourceIndent = this.formatter.wholeSourceIndent();
            String shiftedPrefix = "|" + prefix.substring(0, prefix.lastIndexOf(10) + 1) + IntStream.range(0, indentMultiple * wholeSourceIndent.getIndentToUse()).mapToObj(n -> wholeSourceIndent.isIndentedWithSpaces() ? " " : "\t").collect(Collectors.joining(""));
            if (!shiftedPrefix.equals(prefix)) {
                x = (Xml)x.withPrefix(shiftedPrefix);
            }
        }
        return x;
    }
}

