/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class RemoveContent {
    private RemoveContent() {
    }

    public static class Scoped
    extends XmlRefactorVisitor {
        private final Content scope;
        private final boolean removeEmptyAncestors;

        public Scoped(Content tag, boolean removeEmptyAncestors) {
            this.scope = tag;
            this.removeEmptyAncestors = removeEmptyAncestors;
            this.setCursoringOn();
        }

        @Override
        public Xml visitTag(Xml.Tag tag) {
            if (tag.getContent() != null) {
                for (Content content : tag.getContent()) {
                    if (!this.scope.isScope(content)) continue;
                    ArrayList<? extends Content> contents = new ArrayList<Content>(tag.getContent());
                    contents.remove(content);
                    if (this.removeEmptyAncestors && contents.isEmpty()) {
                        if (this.getCursor().getParentOrThrow().getTree() instanceof Xml.Document) {
                            return tag.withContent(null).withClosing(null);
                        }
                        this.andThen((RefactorVisitor)new Scoped(tag, true));
                        continue;
                    }
                    return tag.withContent(contents);
                }
            }
            return super.visitTag(tag);
        }
    }
}

