/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.AbstractXmlSourceVisitor;
import org.openrewrite.xml.tree.Xml;

public class PrintXml
extends AbstractXmlSourceVisitor<String> {
    public String defaultTo(Tree t) {
        return "";
    }

    public String reduce(String r1, String r2) {
        return r1 + r2;
    }

    @Override
    public String visitDocument(Xml.Document document) {
        return this.fmt(document, (String)this.visit(document.getProlog()) + (String)this.visit(document.getRoot()));
    }

    @Override
    public String visitProlog(Xml.Prolog prolog) {
        return this.fmt(prolog, (String)this.visit(prolog.getXmlDecl()) + (String)this.visit(prolog.getMisc()));
    }

    @Override
    public String visitTag(Xml.Tag tag) {
        return this.fmt(tag, "<" + tag.getName() + (String)this.visit(tag.getAttributes()) + tag.getBeforeTagDelimiterPrefix() + (tag.getClosing() == null ? "/>" : ">" + (String)this.visit(tag.getContent()) + this.fmt(tag.getClosing(), "</" + tag.getClosing().getName() + tag.getClosing().getBeforeTagDelimiterPrefix() + ">")));
    }

    @Override
    public String visitAttribute(Xml.Attribute attribute) {
        String valueDelim = Xml.Attribute.Value.Quote.Double.equals((Object)attribute.getValue().getQuote()) ? "\"" : "'";
        return this.fmt(attribute, this.fmt(attribute.getKey(), attribute.getKeyAsString()) + "=" + this.fmt(attribute.getValue(), valueDelim + attribute.getValueAsString() + valueDelim));
    }

    @Override
    public String visitComment(Xml.Comment comment) {
        return this.fmt(comment, "<!--" + comment.getText() + "-->");
    }

    @Override
    public String visitProcessingInstruction(Xml.ProcessingInstruction pi) {
        return this.fmt(pi, "<?" + pi.getName() + (String)this.visit(pi.getAttributes()) + pi.getBeforeTagDelimiterPrefix() + "?>");
    }

    @Override
    public String visitCharData(Xml.CharData charData) {
        return this.fmt(charData, charData.isCdata() ? "<![CDATA[" + charData.getText() + "]]>" : charData.getText());
    }

    @Override
    public String visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl) {
        return this.fmt(docTypeDecl, "<!DOCTYPE" + (String)this.visit(docTypeDecl.getName()) + (String)this.visit(docTypeDecl.getExternalId()) + (String)this.visit(docTypeDecl.getInternalSubset()) + (docTypeDecl.getExternalSubsets() == null ? "" : this.fmt(docTypeDecl.getExternalSubsets(), "[" + (String)this.visit(docTypeDecl.getExternalSubsets().getElements()) + "]")) + ">");
    }

    @Override
    public String visitElement(Xml.Element element) {
        return this.fmt(element, "<!ELEMENT" + (String)this.visit(element.getSubset()) + ">");
    }

    @Override
    public String visitIdent(Xml.Ident ident) {
        return this.fmt(ident, ident.getName());
    }

    private String fmt(@Nullable Tree tree, @Nullable String code) {
        return tree == null || code == null ? "" : tree.getPrefix() + code + tree.getSuffix();
    }
}

