/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.internal.grammar.XMLParser;
import org.openrewrite.xml.internal.grammar.XMLParserBaseVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;
import org.openrewrite.xml.tree.Xml;

public class XmlParserVisitor
extends XMLParserBaseVisitor<Xml> {
    private final Path path;
    private final String source;
    private int cursor = 0;

    public XmlParserVisitor(Path path, String source) {
        this.path = path;
        this.source = source;
    }

    @Override
    public Xml.Document visitDocument(XMLParser.DocumentContext ctx) {
        Xml.Document d = this.convert(ctx, (C c, Formatting format) -> new Xml.Document(Tree.randomId(), this.path.toString(), Collections.emptyMap(), this.visitProlog(ctx.prolog()), this.visitElement(ctx.element()), (Formatting)format));
        return d == null ? null : (Xml.Document)d.withSuffix(this.source.substring(this.cursor));
    }

    @Override
    public Xml.Prolog visitProlog(XMLParser.PrologContext ctx) {
        return this.convert(ctx, (C c, Formatting format) -> new Xml.Prolog(Tree.randomId(), this.visitXmldecl(ctx.xmldecl()), ctx.misc().stream().map(arg_0 -> ((XmlParserVisitor)this).visit(arg_0)).map(Misc.class::cast).collect(Collectors.toList()), (Formatting)format));
    }

    @Override
    public Xml visitMisc(XMLParser.MiscContext ctx) {
        if (ctx.COMMENT() != null) {
            return this.convert(ctx.COMMENT(), (TerminalNode comment, Formatting format) -> new Xml.Comment(Tree.randomId(), comment.getText().substring("<!--".length(), comment.getText().length() - "-->".length()), (Formatting)format));
        }
        return (Xml)super.visitMisc(ctx);
    }

    @Override
    public Xml visitContent(XMLParser.ContentContext ctx) {
        if (ctx.CDATA() != null) {
            Xml.CharData charData = this.convert(ctx.CDATA(), (TerminalNode cdata, Formatting format) -> {
                Map.Entry<Formatting, String> formatAndText = this.charDataFormat(cdata.getText());
                return new Xml.CharData(Tree.randomId(), true, formatAndText.getValue().substring("<![CDATA[".length(), cdata.getText().length() - "]]>".length()), formatAndText.getKey());
            });
            ++this.cursor;
            return charData;
        }
        if (ctx.chardata() != null) {
            Xml.CharData charData = this.convert(ctx.chardata(), (C chardata, Formatting format) -> {
                Map.Entry<Formatting, String> formatAndText = this.charDataFormat(chardata.getText());
                return new Xml.CharData(Tree.randomId(), false, formatAndText.getValue(), formatAndText.getKey());
            });
            ++this.cursor;
            return charData;
        }
        return (Xml)super.visitContent(ctx);
    }

    private Map.Entry<Formatting, String> charDataFormat(String text) {
        boolean prefixDone = false;
        StringBuilder prefix = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (!prefixDone) {
                if (Character.isWhitespace(text.charAt(i))) {
                    prefix.append(text.charAt(i));
                    continue;
                }
                prefixDone = true;
                value.append(text.charAt(i));
                continue;
            }
            if (Character.isWhitespace(text.charAt(i))) {
                suffix.append(text.charAt(i));
            } else {
                suffix.setLength(0);
            }
            value.append(text.charAt(i));
        }
        String valueStr = value.toString();
        return Map.of(Formatting.format((String)prefix.toString(), (String)suffix.toString()), valueStr.substring(0, valueStr.length() - suffix.length())).entrySet().iterator().next();
    }

    @Override
    public Xml.ProcessingInstruction visitXmldecl(XMLParser.XmldeclContext ctx) {
        return this.convert(ctx, (C c, Formatting format) -> {
            this.cursor = ctx.XML_DECL().getSymbol().getStopIndex() + 1;
            List<Xml.Attribute> attributes = ctx.attribute().stream().map(this::visitAttribute).collect(Collectors.toList());
            return new Xml.ProcessingInstruction(Tree.randomId(), "xml", attributes, this.format(ctx.getStop()).getPrefix(), (Formatting)format);
        });
    }

    @Override
    public Xml.ProcessingInstruction visitProcessinginstruction(XMLParser.ProcessinginstructionContext ctx) {
        return this.convert(ctx, (C c, Formatting format) -> {
            String name = this.convert(ctx.Name(), (TerminalNode n, Formatting f) -> n.getText());
            List<Xml.Attribute> attributes = ctx.attribute().stream().map(this::visitAttribute).collect(Collectors.toList());
            return new Xml.ProcessingInstruction(Tree.randomId(), name, attributes, this.format(ctx.getStop()).getPrefix(), (Formatting)format);
        });
    }

    @Override
    public Xml.Tag visitElement(XMLParser.ElementContext ctx) {
        return this.convert(ctx, (C c, Formatting format) -> {
            String beforeTagDelimiterPrefix;
            String name = this.convert(ctx.Name(0), (TerminalNode n, Formatting f) -> n.getText());
            List<Xml.Attribute> attributes = ctx.attribute().stream().map(this::visitAttribute).collect(Collectors.toList());
            List content = null;
            Xml.Tag.Closing closeTag = null;
            if (ctx.SLASH_CLOSE() != null) {
                beforeTagDelimiterPrefix = this.format(ctx.SLASH_CLOSE()).getPrefix();
                this.cursor = ctx.SLASH_CLOSE().getSymbol().getStopIndex() + 1;
            } else {
                beforeTagDelimiterPrefix = this.format(ctx.CLOSE(0)).getPrefix();
                this.cursor = ctx.CLOSE(0).getSymbol().getStopIndex() + 1;
                content = ctx.content().stream().map(arg_0 -> ((XmlParserVisitor)this).visit(arg_0)).map(Content.class::cast).collect(Collectors.toList());
                Formatting closeTagFormat = this.format(ctx.OPEN(1));
                this.cursor += 2;
                closeTag = new Xml.Tag.Closing(Tree.randomId(), this.convert(ctx.Name(1), (TerminalNode n, Formatting f) -> n.getText()), this.format(ctx.CLOSE(1)).getPrefix(), closeTagFormat);
                ++this.cursor;
            }
            return new Xml.Tag(Tree.randomId(), name, attributes, content, closeTag, beforeTagDelimiterPrefix, (Formatting)format);
        });
    }

    @Override
    public Xml.Attribute visitAttribute(XMLParser.AttributeContext ctx) {
        return this.convert(ctx, (C c, Formatting format) -> {
            Xml.Ident key = (Xml.Ident)this.convert(c.Name(), (TerminalNode t, Formatting f) -> new Xml.Ident(Tree.randomId(), t.getText(), (Formatting)f)).withSuffix(this.convert(c.EQUALS(), (TerminalNode e, Formatting f) -> f.getPrefix()));
            Xml.Attribute.Value value = this.convert(c.STRING(), (TerminalNode v, Formatting f) -> new Xml.Attribute.Value(Tree.randomId(), v.getText().startsWith("'") ? Xml.Attribute.Value.Quote.Single : Xml.Attribute.Value.Quote.Double, v.getText().substring(1, c.STRING().getText().length() - 1), (Formatting)f));
            return new Xml.Attribute(Tree.randomId(), key, value, (Formatting)format);
        });
    }

    @Override
    public Xml.DocTypeDecl visitDoctypedecl(XMLParser.DoctypedeclContext ctx) {
        return this.convert(ctx, (C c, Formatting format) -> {
            this.skip(c.DOCTYPE());
            Xml.Ident name = this.convert(c.Name(), (TerminalNode n, Formatting f) -> new Xml.Ident(Tree.randomId(), n.getText(), (Formatting)f));
            Xml.Ident externalId = this.convert(c.externalid(), (C n, Formatting f) -> new Xml.Ident(Tree.randomId(), n.Name().getText(), (Formatting)f));
            List<Xml.Ident> internalSubset = c.STRING().stream().map(s -> this.convert((TerminalNode)s, (TerminalNode attr, Formatting f) -> new Xml.Ident(Tree.randomId(), attr.getText(), (Formatting)f))).collect(Collectors.toList());
            String beforeTagDelimiterPrefix = this.format(c.CLOSE()).getPrefix();
            return new Xml.DocTypeDecl(Tree.randomId(), name, externalId, internalSubset, null, beforeTagDelimiterPrefix, (Formatting)format);
        });
    }

    private Formatting format(ParserRuleContext ctx) {
        return this.format(ctx.getStart());
    }

    private Formatting format(TerminalNode terminalNode) {
        return this.format(terminalNode.getSymbol());
    }

    private Formatting format(Token token) {
        int start = token.getStartIndex();
        if (start < this.cursor) {
            return Formatting.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, start);
        this.cursor = start;
        return Formatting.format((String)prefix);
    }

    @Nullable
    private <C extends ParserRuleContext, T> T convert(C ctx, BiFunction<C, Formatting, T> conversion) {
        if (ctx == null) {
            return null;
        }
        Formatting format = this.format(ctx);
        T t = conversion.apply(ctx, format);
        this.cursor = ctx.getStop().getStopIndex() + (Character.isWhitespace(this.source.charAt(ctx.getStop().getStopIndex())) ? 0 : 1);
        return t;
    }

    private <T> T convert(TerminalNode node, BiFunction<TerminalNode, Formatting, T> conversion) {
        Formatting format = this.format(node);
        T t = conversion.apply(node, format);
        this.cursor = node.getSymbol().getStopIndex() + 1;
        return t;
    }

    private void skip(TerminalNode node) {
        this.cursor = node.getSymbol().getStopIndex() + 1;
    }
}

