/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.SourceFile;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.test.RecipePrinter;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.UncheckedConsumer;

public class RecipeSpec {
    public static Supplier<RecipeSpec> DEFAULTS = RecipeSpec::new;
    @Nullable Recipe recipe;
    List<Parser.Builder> parsers = new ArrayList<Parser.Builder>();
    @Nullable ExecutionContext executionContext;
    @Nullable ExecutionContext recipeExecutionContext;
    @Nullable Path relativeTo;
    @Nullable Integer cycles;
    @Nullable Integer expectedCyclesThatMakeChanges;
    @Nullable TypeValidation typeValidation;
    @Nullable TypeValidation afterTypeValidation;
    boolean serializationValidation = true;
    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PrintOutputCapture.MarkerPrinter markerPrinter;
    List<UncheckedConsumer<List<SourceFile>>> beforeRecipes = new ArrayList<UncheckedConsumer<List<SourceFile>>>();
    List<UncheckedConsumer<RecipeRun>> afterRecipes = new ArrayList<UncheckedConsumer<RecipeRun>>();
    List<UncheckedConsumer<SourceSpec<?>>> allSources = new ArrayList();
    @Nullable Function<List<SourceFile>, LargeSourceSet> sourceSet;
    @Nullable RecipePrinter recipePrinter;
    private static final Map<String, Recipe> RECIPE_CACHE = new ConcurrentHashMap<String, Recipe>();

    public static RecipeSpec defaults() {
        return DEFAULTS.get();
    }

    public RecipeSpec allSources(UncheckedConsumer<SourceSpec<?>> allSources) {
        this.allSources.add(allSources);
        return this;
    }

    public RecipeSpec recipe(Recipe recipe) {
        this.recipe = recipe;
        return this;
    }

    public RecipeSpec recipes(Recipe ... recipes) {
        this.recipe = new CompositeRecipe(Arrays.asList(recipes));
        return this;
    }

    public RecipeSpec recipe(InputStream yaml, String ... activeRecipes) {
        return this.recipe(RecipeSpec.recipeFromInputStream(yaml, activeRecipes));
    }

    public RecipeSpec recipeFromYaml(@Language(value="yaml") String yaml, String ... activeRecipes) {
        return this.recipe(RECIPE_CACHE.computeIfAbsent(RecipeSpec.key("recipeFromYaml", yaml, RecipeSpec.key(activeRecipes)), k -> RecipeSpec.recipeFromInputStream(new ByteArrayInputStream(yaml.getBytes(StandardCharsets.UTF_8)), activeRecipes)));
    }

    public RecipeSpec recipeFromResource(String yamlResource, String ... activeRecipes) {
        return this.recipe(RECIPE_CACHE.computeIfAbsent(RecipeSpec.key("recipeFromResource", yamlResource, RecipeSpec.key(activeRecipes)), k -> RecipeSpec.recipeFromInputStream(Objects.requireNonNull(RecipeSpec.class.getResourceAsStream(yamlResource)), activeRecipes)));
    }

    public RecipeSpec recipeFromResources(String ... activeRecipes) {
        return this.recipe(RECIPE_CACHE.computeIfAbsent(RecipeSpec.key("recipeFromResources", RecipeSpec.key(activeRecipes)), k -> Environment.builder().scanYamlResources().build().activateRecipes(activeRecipes)));
    }

    private static Recipe recipeFromInputStream(InputStream yaml, String ... activeRecipes) {
        return Environment.builder().load((ResourceLoader)new YamlResourceLoader(yaml, URI.create("rewrite.yml"), new Properties(), null, Collections.emptyList(), mapper -> mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).build().activateRecipes(activeRecipes);
    }

    private static String key(String ... s) {
        return String.join((CharSequence)"-", s);
    }

    public RecipeSpec parser(Parser.Builder parser) {
        this.parsers.add(parser);
        return this;
    }

    public RecipeSpec executionContext(ExecutionContext ctx) {
        this.executionContext = ctx;
        return this;
    }

    public RecipeSpec recipeExecutionContext(ExecutionContext ctx) {
        this.recipeExecutionContext = ctx;
        return this;
    }

    public RecipeSpec markerPrinter(PrintOutputCapture.MarkerPrinter markerPrinter) {
        this.markerPrinter = markerPrinter;
        return this;
    }

    public RecipeSpec relativeTo(@Nullable Path relativeTo) {
        this.relativeTo = relativeTo;
        return this;
    }

    public RecipeSpec cycles(int cycles) {
        this.cycles = cycles;
        return this;
    }

    public RecipeSpec beforeRecipe(UncheckedConsumer<List<SourceFile>> beforeRecipe) {
        this.beforeRecipes.add(beforeRecipe);
        return this;
    }

    public RecipeSpec afterRecipe(UncheckedConsumer<RecipeRun> afterRecipe) {
        this.afterRecipes.add(afterRecipe);
        return this;
    }

    @Incubating(since="7.35.0")
    public <E> RecipeSpec dataTable(Class<E> rowType, UncheckedConsumer<List<E>> extract) {
        return this.afterRecipe(run -> {
            for (Map.Entry dataTableListEntry : run.getDataTables().entrySet()) {
                if (!((DataTable)dataTableListEntry.getKey()).getType().equals(rowType)) continue;
                List rows = run.getDataTableRows(((DataTable)dataTableListEntry.getKey()).getName());
                Assertions.assertThat((List)rows).isNotNull();
                Assertions.assertThat((List)rows).isNotEmpty();
                extract.accept(rows);
                return;
            }
            String message = "No data table found with row type: " + rowType;
            Set tables = run.getDataTables().keySet();
            if (!tables.isEmpty()) {
                message = message + "\nFound data tables row type(s): " + tables.stream().map(it -> it.getType().getName().replace("$", ".")).collect(Collectors.joining(","));
            }
            Assertions.fail((String)message);
        });
    }

    @Incubating(since="7.35.0")
    public <E, V> RecipeSpec dataTableAsCsv(Class<? extends DataTable<?>> dataTableClass, String expect) {
        return this.dataTableAsCsv(dataTableClass.getName(), expect);
    }

    @Incubating(since="7.35.0")
    public <E, V> RecipeSpec dataTableAsCsv(String name, String expect) {
        this.afterRecipe(run -> {
            DataTable dataTable = run.getDataTable(name);
            Assertions.assertThat((Object)dataTable).isNotNull();
            List rows = run.getDataTableRows(name);
            StringWriter writer = new StringWriter();
            CsvMapper mapper = (CsvMapper)((CsvMapper.Builder)CsvMapper.builder().disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
            CsvSchema schema = mapper.schemaFor(dataTable.getType()).withHeader();
            mapper.writerFor(dataTable.getType()).with((FormatSchema)schema).writeValues((Writer)writer).writeAll((Collection)rows);
            Assertions.assertThat((String)writer.toString()).isEqualTo(expect);
        });
        return this;
    }

    @Incubating(since="7.35.0")
    public RecipeSpec validateRecipeSerialization(boolean validate) {
        this.serializationValidation = validate;
        return this;
    }

    public RecipeSpec sourceSet(Function<List<SourceFile>, LargeSourceSet> sourceSetBuilder) {
        this.sourceSet = sourceSetBuilder;
        return this;
    }

    public RecipeSpec expectedCyclesThatMakeChanges(int expectedCyclesThatMakeChanges) {
        this.expectedCyclesThatMakeChanges = expectedCyclesThatMakeChanges;
        return this;
    }

    int getCycles() {
        return this.cycles == null ? 2 : this.cycles;
    }

    int getExpectedCyclesThatMakeChanges(int cycles) {
        return this.expectedCyclesThatMakeChanges == null ? cycles - 1 : this.expectedCyclesThatMakeChanges;
    }

    public RecipeSpec typeValidationOptions(TypeValidation typeValidation) {
        this.typeValidation = typeValidation;
        return this;
    }

    public RecipeSpec afterTypeValidationOptions(TypeValidation typeValidation) {
        this.afterTypeValidation = typeValidation;
        return this;
    }

    @Nullable ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Incubating(since="8.12.1")
    public RecipeSpec printRecipe(RecipePrinter recipePrinter) {
        this.recipePrinter = recipePrinter;
        return this;
    }

    @Generated
    public @Nullable Recipe getRecipe() {
        return this.recipe;
    }

    @Generated
    public List<Parser.Builder> getParsers() {
        return this.parsers;
    }

    @Generated
    public @Nullable ExecutionContext getRecipeExecutionContext() {
        return this.recipeExecutionContext;
    }

    @Generated
    public @Nullable Path getRelativeTo() {
        return this.relativeTo;
    }

    @Generated
    public @Nullable Integer getExpectedCyclesThatMakeChanges() {
        return this.expectedCyclesThatMakeChanges;
    }

    @Generated
    public @Nullable TypeValidation getTypeValidation() {
        return this.typeValidation;
    }

    @Generated
    public @Nullable TypeValidation getAfterTypeValidation() {
        return this.afterTypeValidation;
    }

    @Generated
    public boolean isSerializationValidation() {
        return this.serializationValidation;
    }

    @Generated
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PrintOutputCapture.MarkerPrinter getMarkerPrinter() {
        return this.markerPrinter;
    }

    @Generated
    public List<UncheckedConsumer<List<SourceFile>>> getBeforeRecipes() {
        return this.beforeRecipes;
    }

    @Generated
    public List<UncheckedConsumer<RecipeRun>> getAfterRecipes() {
        return this.afterRecipes;
    }

    @Generated
    public List<UncheckedConsumer<SourceSpec<?>>> getAllSources() {
        return this.allSources;
    }

    @Generated
    public @Nullable Function<List<SourceFile>, LargeSourceSet> getSourceSet() {
        return this.sourceSet;
    }

    @Generated
    public @Nullable RecipePrinter getRecipePrinter() {
        return this.recipePrinter;
    }
}

