/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.jspecify.annotations.Nullable;
import org.openrewrite.CursorValidatingExecutionContextView;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeSerializer;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.internal.InMemoryDiffEntry;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.WhitespaceValidationService;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.test.AdHocRecipe;
import org.openrewrite.test.AdHocScanningRecipe;
import org.openrewrite.test.LargeSourceSetCheckingExpectedCycles;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTestUtils;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.UncheckedConsumer;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingExecutionContextView;

public interface RewriteTest
extends SourceSpecs {
    public static AdHocRecipe toRecipe(Supplier<TreeVisitor<?, ExecutionContext>> visitor) {
        return new AdHocRecipe(null, null, null, visitor, null, null);
    }

    public static AdHocRecipe toRecipe() {
        return new AdHocRecipe(null, null, null, TreeVisitor::noop, null, null);
    }

    public static AdHocRecipe toRecipe(Function<Recipe, TreeVisitor<?, ExecutionContext>> visitor) {
        AdHocRecipe r = RewriteTest.toRecipe();
        return r.withGetVisitor(() -> (TreeVisitor)visitor.apply(r));
    }

    public static Recipe fromRuntimeClasspath(String recipe) {
        return Environment.builder().scanRuntimeClasspath(new String[0]).build().activateRecipes(new String[]{recipe});
    }

    default public void assertRecipesConfigure(String packageName) {
        SoftAssertions softly = new SoftAssertions();
        for (Recipe recipe : Environment.builder().scanRuntimeClasspath(new String[]{packageName}).build().listRecipes()) {
            if (!recipe.getName().startsWith(packageName)) continue;
            softly.assertThatCode(() -> {
                try {
                    this.rewriteRun((RecipeSpec spec) -> spec.recipe(recipe), new SourceSpecs[0]);
                }
                catch (Throwable t) {
                    Assertions.fail((String)("Recipe " + recipe.getName() + " failed to configure"), (Throwable)t);
                }
            }).doesNotThrowAnyException();
        }
        softly.assertAll();
    }

    default public void assertRecipesConfigure() {
        this.assertRecipesConfigure(this.getClass().getPackage().getName());
    }

    default public @Nullable String doesNotExist() {
        return null;
    }

    default public void defaults(RecipeSpec spec) {
        spec.recipe(Recipe.noop());
    }

    default public void rewriteRun(SourceSpecs ... sourceSpecs) {
        this.rewriteRun((RecipeSpec spec) -> {}, sourceSpecs);
    }

    default public void rewriteRun(Consumer<RecipeSpec> spec, SourceSpecs ... sourceSpecs) {
        this.rewriteRun(spec, (SourceSpec[])Arrays.stream(sourceSpecs).flatMap(specGroup -> StreamSupport.stream(specGroup.spliterator(), false)).toArray(SourceSpec[]::new));
    }

    /*
     * WARNING - void declaration
     */
    default public void rewriteRun(Consumer<RecipeSpec> spec, SourceSpec<?> ... sourceSpecs) {
        void var25_63;
        void var19_45;
        void var18_37;
        int i;
        SourceSpec<?>[] sourceFiles;
        int cycles;
        Recipe recipe;
        RecipeSpec testClassSpec = RecipeSpec.defaults();
        this.defaults(testClassSpec);
        RecipeSpec testMethodSpec = RecipeSpec.defaults();
        spec.accept(testMethodSpec);
        ExecutionContext ctx = testMethodSpec.getExecutionContext() != null ? testMethodSpec.getExecutionContext() : (testClassSpec.getExecutionContext() != null ? testClassSpec.getExecutionContext() : this.defaultExecutionContext(sourceSpecs));
        PrintOutputCapture.MarkerPrinter markerPrinter = testMethodSpec.getMarkerPrinter() != null ? testMethodSpec.getMarkerPrinter() : (testClassSpec.getMarkerPrinter() != null ? testClassSpec.getMarkerPrinter() : PrintOutputCapture.MarkerPrinter.DEFAULT);
        PrintOutputCapture out = new PrintOutputCapture((Object)ctx, markerPrinter);
        Recipe recipe2 = testMethodSpec.recipe == null ? (testClassSpec.recipe == null ? Recipe.noop() : testClassSpec.recipe) : (recipe = testMethodSpec.recipe);
        if (!(recipe instanceof AdHocRecipe) && !(recipe instanceof AdHocScanningRecipe) && !(recipe instanceof CompositeRecipe) && !recipe.equals((Object)Recipe.noop()) && testClassSpec.serializationValidation && testMethodSpec.serializationValidation) {
            RecipeSerializer recipeSerializer = new RecipeSerializer();
            ((ObjectAssert)Assertions.assertThat((Object)recipeSerializer.read(recipeSerializer.write(recipe))).as("Recipe must be serializable/deserializable", new Object[0])).isEqualTo((Object)recipe);
            ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
                Recipe r = RecipeIntrospectionUtils.constructRecipe(recipe.getClass());
                r.getRecipeList();
                r.hashCode();
                r.equals((Object)r);
            }).as("Recipe must be able to instantiate via RecipeIntrospectionUtils", new Object[0])).doesNotThrowAnyException();
            this.validateRecipeNameAndDescription(recipe);
            this.validateRecipeOptions(recipe);
        }
        if (testMethodSpec.getRecipePrinter() != null) {
            testMethodSpec.getRecipePrinter().printTree(recipe);
        } else if (testClassSpec.getRecipePrinter() != null) {
            testClassSpec.getRecipePrinter().printTree(recipe);
        }
        int n = cycles = testMethodSpec.cycles == null ? testClassSpec.getCycles() : testMethodSpec.getCycles();
        int expectedCyclesThatMakeChanges = testMethodSpec.expectedCyclesThatMakeChanges == null ? (testClassSpec.expectedCyclesThatMakeChanges == null ? 0 : testClassSpec.expectedCyclesThatMakeChanges) : testMethodSpec.expectedCyclesThatMakeChanges;
        for (SourceSpec<?> s : sourceSpecs) {
            if (s.after == null) continue;
            expectedCyclesThatMakeChanges = testMethodSpec.expectedCyclesThatMakeChanges == null ? testClassSpec.getExpectedCyclesThatMakeChanges(cycles) : testMethodSpec.getExpectedCyclesThatMakeChanges(cycles);
            break;
        }
        for (SourceSpec<?> s : sourceSpecs) {
            s.customizeExecutionContext.accept((Object)ctx);
        }
        ArrayList validations = new ArrayList();
        recipe.validateAll(ctx, validations);
        ((ListAssert)Assertions.assertThat(validations.stream().filter(Validated::isInvalid)).as("Recipe validation must have no failures", new Object[0])).isEmpty();
        HashMap sourceSpecsByParser = new HashMap();
        List<Parser.Builder> methodSpecParsers = testMethodSpec.parsers;
        List<Parser.Builder> testClassSpecParsers = testClassSpec.parsers.stream().map(Parser.Builder::clone).collect(Collectors.toList());
        for (SourceSpec<?> sourceSpec : sourceSpecs) {
            if (RewriteTestUtils.groupSourceSpecsByParser(methodSpecParsers, sourceSpecsByParser, sourceSpec) || RewriteTestUtils.groupSourceSpecsByParser(testClassSpecParsers, sourceSpecsByParser, sourceSpec)) continue;
            sourceSpecsByParser.computeIfAbsent(sourceSpec.getParser().clone(), p -> new ArrayList()).add(sourceSpec);
        }
        LinkedHashMap<SourceFile, SourceSpec> specBySourceFile = new LinkedHashMap<SourceFile, SourceSpec>(sourceSpecs.length);
        for (Map.Entry sourceSpecsForParser : sourceSpecsByParser.entrySet()) {
            LinkedHashMap<SourceSpec, Parser.Input> linkedHashMap = new LinkedHashMap<SourceSpec, Parser.Input>(((List)sourceSpecsForParser.getValue()).size());
            Parser parser = ((Parser.Builder)sourceSpecsForParser.getKey()).build();
            for (SourceSpec sourceSpec : (List)sourceSpecsForParser.getValue()) {
                if (sourceSpec.before == null) continue;
                String string = sourceSpec.noTrim ? sourceSpec.before : StringUtils.trimIndentPreserveCRLF((String)sourceSpec.before);
                Path sourcePath = sourceSpec.sourcePath != null ? sourceSpec.dir.resolve(sourceSpec.sourcePath) : parser.sourcePathFromSourceText(sourceSpec.dir, string);
                for (UncheckedConsumer<SourceSpec<?>> uncheckedConsumer : testMethodSpec.allSources) {
                    uncheckedConsumer.accept(sourceSpec);
                }
                for (UncheckedConsumer<SourceSpec<?>> uncheckedConsumer : testClassSpec.allSources) {
                    uncheckedConsumer.accept(sourceSpec);
                }
                linkedHashMap.put(sourceSpec, Parser.Input.fromString((Path)sourcePath, (String)string, (Charset)parser.getCharset(ctx)));
            }
            Path relativeTo = testMethodSpec.relativeTo == null ? testClassSpec.relativeTo : testMethodSpec.relativeTo;
            Iterator<Object> sourceSpecIter = linkedHashMap.keySet().iterator();
            boolean bl = (Boolean)ctx.getMessage("org.openrewrite.requirePrintEqualsInput", (Object)true);
            if (bl) {
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
            }
            sourceFiles = parser.parseInputs(linkedHashMap.values(), relativeTo, ctx).collect(Collectors.toList());
            ((AbstractIntegerAssert)Assertions.assertThat((int)sourceFiles.size()).as("Every input should be parsed into a SourceFile.", new Object[0])).isEqualTo(linkedHashMap.size());
            if (bl) {
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)true);
            }
            for (i = 0; i < sourceFiles.size(); ++i) {
                void var26_68;
                SourceFile sourceFile = (SourceFile)sourceFiles.get(i);
                Markers markers = sourceFile.getMarkers();
                SourceSpec nextSpec = (SourceSpec)sourceSpecIter.next();
                for (Marker marker : nextSpec.getMarkers()) {
                    Markers markers2 = var26_68.setByType(marker);
                }
                SourceFile sourceFile2 = (SourceFile)sourceFile.withMarkers((Markers)var26_68);
                nextSpec.validateSource.accept(sourceFile2, TypeValidation.before(testMethodSpec, testClassSpec));
                int j = 0;
                for (Parser.Input input : linkedHashMap.values()) {
                    if (j++ != i || sourceFile2 instanceof Quark) continue;
                    RewriteTest.assertContentEquals(sourceFile2, StringUtils.readFully((InputStream)input.getSource(ctx), (Charset)parser.getCharset(ctx)), sourceFile2.printAll(out.clone()), "When parsing and printing the source code back to text without modifications, the printed source didn't match the original source code. This means there is a bug in the parser implementation itself. Please open an issue to report this, providing a sample of the code that generated this error for");
                    try {
                        WhitespaceValidationService service = (WhitespaceValidationService)sourceFile2.service(WhitespaceValidationService.class);
                        SourceFile whitespaceValidated = (SourceFile)service.getVisitor().visit((Tree)sourceFile2, (Object)ctx);
                        if (whitespaceValidated == null || whitespaceValidated == sourceFile2) continue;
                        Assertions.fail((String)("Source file was parsed into an LST that contains non-whitespace characters in its whitespace. This is indicative of a bug in the parser. \n" + whitespaceValidated.printAll()));
                    }
                    catch (UnsupportedOperationException service) {}
                }
                SourceFile sourceFile3 = (SourceFile)nextSpec.beforeRecipe.apply(sourceFile2);
                specBySourceFile.put(sourceFile3, nextSpec);
            }
        }
        ArrayList beforeSourceFiles = new ArrayList(specBySourceFile.keySet());
        for (Consumer consumer : testClassSpec.beforeRecipes) {
            consumer.accept(beforeSourceFiles);
        }
        for (Consumer consumer : testMethodSpec.beforeRecipes) {
            consumer.accept(beforeSourceFiles);
        }
        for (SourceFile sourceFile : beforeSourceFiles) {
            specBySourceFile.put(sourceFile, (SourceSpec)specBySourceFile.remove(sourceFile));
        }
        ArrayList<SourceFile> runnableSourceFiles = new ArrayList<SourceFile>(beforeSourceFiles.size());
        for (Map.Entry entry : specBySourceFile.entrySet()) {
            if (((SourceSpec)entry.getValue()).isSkip()) continue;
            runnableSourceFiles.add((SourceFile)entry.getKey());
        }
        ExecutionContext executionContext = ctx;
        if (testMethodSpec.getRecipeExecutionContext() != null) {
            ExecutionContext executionContext2 = testMethodSpec.getRecipeExecutionContext();
        } else if (testClassSpec.getRecipeExecutionContext() != null) {
            ExecutionContext executionContext3 = testClassSpec.getRecipeExecutionContext();
        }
        if (testMethodSpec.getSourceSet() != null) {
            LargeSourceSet largeSourceSet = testMethodSpec.getSourceSet().apply(runnableSourceFiles);
        } else if (testClassSpec.getSourceSet() != null) {
            LargeSourceSet largeSourceSet = testClassSpec.getSourceSet().apply(runnableSourceFiles);
        } else {
            LargeSourceSetCheckingExpectedCycles largeSourceSetCheckingExpectedCycles = new LargeSourceSetCheckingExpectedCycles(expectedCyclesThatMakeChanges, runnableSourceFiles);
        }
        CursorValidatingExecutionContextView cursorValidatingExecutionContextView = CursorValidatingExecutionContextView.view((ExecutionContext)var18_37).setValidateCursorAcyclic(TypeValidation.before(testMethodSpec, testClassSpec).cursorAcyclic()).setValidateImmutableExecutionContext(TypeValidation.before(testMethodSpec, testClassSpec).immutableExecutionContext());
        RecipeRun recipeRun = recipe.run((LargeSourceSet)var19_45, (ExecutionContext)cursorValidatingExecutionContextView, cycles, expectedCyclesThatMakeChanges + 1);
        for (Consumer consumer : testClassSpec.afterRecipes) {
            consumer.accept(recipeRun);
        }
        for (Consumer consumer : testMethodSpec.afterRecipes) {
            consumer.accept(recipeRun);
        }
        Collection expectedNewSources = Collections.newSetFromMap(new IdentityHashMap());
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        sourceFiles = sourceSpecs;
        i = sourceFiles.length;
        boolean bl = false;
        while (var25_63 < i) {
            SourceSpec<?> sourceSpec = sourceFiles[var25_63];
            if (sourceSpec.before == null) {
                expectedNewSources.add(sourceSpec);
            }
            ++var25_63;
        }
        expectedNewSources = new CopyOnWriteArrayList(expectedNewSources);
        List allResults = recipeRun.getChangeset().getAllResults();
        block21: for (SourceSpec sourceSpec : expectedNewSources) {
            String actual;
            ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
            if (sourceSpec.getSourcePath() != null) {
                for (Result result2 : allResults) {
                    if (result2.getAfter() == null || !sourceSpec.getSourcePath().equals(result2.getAfter().getSourcePath())) continue;
                    expectedNewSources.remove(sourceSpec);
                    set.add(result2);
                    ((ObjectAssert)Assertions.assertThat((Object)result2.getBefore()).as("Expected a new file for the source path but there was an existing file already present: " + sourceSpec.getSourcePath(), new Object[0])).isNull();
                    actual = result2.getAfter().printAll(out.clone());
                    actual = sourceSpec.noTrim ? actual : actual.trim();
                    String string = sourceSpec.noTrim ? (String)sourceSpec.after.apply(actual) : StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(actual)));
                    ((AbstractStringAssert)Assertions.assertThat((String)actual).as("Unexpected result in \"" + result2.getAfter().getSourcePath() + "\"", new Object[0])).isEqualTo(string);
                    continue block21;
                }
                String string = allResults.stream().map(it -> {
                    String beforePath = it.getBefore() == null ? "null" : it.getBefore().getSourcePath().toString();
                    String afterPath = it.getAfter() == null ? "null" : it.getAfter().getSourcePath().toString();
                    return "    " + beforePath + " -> " + afterPath;
                }).collect(Collectors.joining("\n"));
                Assertions.fail((String)("Expected a new source file with the source path: " + sourceSpec.getSourcePath() + "\nAll source file paths, before and after recipe run:\n" + string));
            }
            for (Result result2 : allResults) {
                String string;
                if (result2.getAfter() == null || result2.getAfter() instanceof Remote) continue;
                ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
                actual = result2.getAfter().printAll(out.clone()).trim();
                if (!actual.equals(string = StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(actual))))) continue;
                expectedNewSources.remove(sourceSpec);
                set.add(result2);
                sourceSpec.afterRecipe.accept(result2.getAfter());
                if (sourceSpec.sourcePath == null) break;
                Assertions.assertThat((Path)result2.getAfter().getSourcePath()).isEqualTo((Object)sourceSpec.dir.resolve(sourceSpec.sourcePath));
                break;
            }
            for (Result result2 : allResults) {
                String string;
                if (!(result2.getAfter() instanceof Remote)) continue;
                ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
                actual = result2.getAfter().printAll(out.clone());
                if (!actual.equals(string = StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(actual))))) continue;
                expectedNewSources.remove(sourceSpec);
                sourceSpec.afterRecipe.accept(result2.getAfter());
                if (sourceSpec.sourcePath == null) continue block21;
                Assertions.assertThat((Path)result2.getAfter().getSourcePath()).isEqualTo((Object)sourceSpec.dir.resolve(sourceSpec.sourcePath));
                continue block21;
            }
        }
        block25: for (Map.Entry entry : specBySourceFile.entrySet()) {
            Object parseError;
            SourceSpec sourceSpec = (SourceSpec)entry.getValue();
            SourceFile source = (SourceFile)entry.getKey();
            if (source instanceof ParseError && (parseError = (ParseError)source).getErroneous() != null) {
                RewriteTest.assertContentEquals((SourceFile)parseError, parseError.getText(), parseError.getErroneous().printAll(), "Bug in source parser or printer resulted in the following difference for");
            }
            parseError = allResults.iterator();
            while (parseError.hasNext()) {
                Result result3 = (Result)parseError.next();
                if ((result3.getBefore() != null || source != null) && (result3.getBefore() == null || !result3.getBefore().getId().equals(source.getId()))) continue;
                if (result3.getAfter() != null) {
                    String expectedAfter;
                    String before = result3.getBefore() == null ? null : result3.getBefore().printAll(out.clone());
                    String actualAfter = result3.getAfter().printAll(out.clone());
                    String string = expectedAfter = sourceSpec.after == null ? null : (String)sourceSpec.after.apply(actualAfter);
                    if (expectedAfter != null) {
                        String expected2 = sourceSpec.noTrim ? expectedAfter : StringUtils.trimIndentPreserveCRLF((String)expectedAfter);
                        RewriteTest.assertContentEquals(result3.getAfter(), expected2, actualAfter, "Unexpected result in");
                        sourceSpec.validateSource.accept(result3.getAfter(), TypeValidation.after(testMethodSpec, testClassSpec));
                    } else {
                        boolean isRemote = result3.getAfter() instanceof Remote;
                        if (!isRemote && Objects.equals(result3.getBefore().getSourcePath(), result3.getAfter().getSourcePath()) && Objects.equals(before, actualAfter)) {
                            Assertions.fail((String)"An empty diff was generated. The recipe incorrectly changed a reference without changing its contents.");
                        }
                        if (!2.$assertionsDisabled && result3.getBefore() == null) {
                            throw new AssertionError();
                        }
                        if (!isRemote) {
                            ((AbstractStringAssert)Assertions.assertThat((String)actualAfter).as("The recipe must not make changes to \"" + result3.getBefore().getSourcePath() + "\"", new Object[0])).isEqualTo(before);
                        }
                    }
                } else if (sourceSpec.after == null) {
                    if (!2.$assertionsDisabled && result3.getBefore() == null) {
                        throw new AssertionError();
                    }
                    Assertions.fail((String)("The recipe deleted a source file \"" + result3.getBefore().getSourcePath() + "\" that was not expected to change"));
                } else {
                    String expected3 = (String)sourceSpec.after.apply(null);
                    if (expected3 != null) {
                        if (!2.$assertionsDisabled && result3.getBefore() == null) {
                            throw new AssertionError();
                        }
                        ((AbstractStringAssert)Assertions.assertThat((String)null).as("The recipe deleted a source file \"" + result3.getBefore().getSourcePath() + "\" but should have changed it instead", new Object[0])).isEqualTo(expected3);
                    }
                }
                try {
                    sourceSpec.afterRecipe.accept(result3.getAfter());
                }
                catch (ClassCastException expected3) {}
                continue block25;
            }
            if (sourceSpec.after != null) {
                String actual = sourceSpec.noTrim ? source.printAll(out.clone()) : StringUtils.trimIndentPreserveCRLF((String)source.printAll(out.clone()));
                String string = sourceSpec.noTrim ? sourceSpec.before : StringUtils.trimIndentPreserveCRLF((String)sourceSpec.before);
                String expected = sourceSpec.noTrim ? (String)sourceSpec.after.apply(null) : StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(null)));
                ((AbstractStringAssert)Assertions.assertThat((String)expected).as("To assert that a Recipe makes no change, supply only \"before\" source.", new Object[0])).isNotEqualTo((Object)string);
                ((AbstractStringAssert)Assertions.assertThat((String)actual).as("The recipe should have made the following change to \"" + source.getSourcePath() + "\"", new Object[0])).isEqualTo(expected);
            }
            sourceSpec.afterRecipe.accept(source);
        }
        SoftAssertions newFilesGenerated = new SoftAssertions();
        for (SourceSpec sourceSpec : expectedNewSources) {
            ((StringAssert)newFilesGenerated.assertThat(sourceSpec.after == null ? null : (String)sourceSpec.after.apply(null)).as("No new source file was generated that matched.", new Object[0])).isEmpty();
        }
        newFilesGenerated.assertAll();
        Map<Result, Boolean> map = allResults.stream().collect(Collectors.toMap(result -> result, result -> result.getBefore() == null && !(result.getAfter() instanceof Remote) && !expectedNewResults.contains(result) && testMethodSpec.afterRecipes.isEmpty()));
        if (map.values().stream().anyMatch(unexpected -> unexpected)) {
            String string = map.entrySet().stream().map(it -> {
                Result result = (Result)it.getKey();
                if (!2.$assertionsDisabled && result.getAfter() == null) {
                    throw new AssertionError();
                }
                String beforePath = result.getBefore() == null ? "null" : result.getAfter().getSourcePath().toString();
                String afterPath = result.getAfter() == null ? "null" : result.getAfter().getSourcePath().toString();
                String status = (Boolean)it.getValue() != false ? "\u274c\ufe0f" : "\u2714";
                return "    " + beforePath + " | " + afterPath + " | " + status;
            }).collect(Collectors.joining("\n"));
            Assertions.fail((String)("The recipe generated source files the test did not expect.\nSource file paths before recipe, after recipe, and whether the test expected that result:\n    before | after | expected\n" + string));
        }
    }

    public static void assertContentEquals(SourceFile sourceFile, String expected, String actual, String errorMessagePrefix) {
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(sourceFile.getSourcePath(), sourceFile.getSourcePath(), null, expected, actual, Collections.emptySet());){
            ((AbstractStringAssert)Assertions.assertThat((String)actual).as(errorMessagePrefix + " \"%s\":\n%s", new Object[]{sourceFile.getSourcePath(), diffEntry.getDiff()})).isEqualTo(expected);
        }
        catch (LinkageError e) {
            ((AbstractStringAssert)Assertions.assertThat((String)actual).as(errorMessagePrefix + " \"%s\"", new Object[]{sourceFile.getSourcePath()})).isEqualTo(expected);
        }
    }

    default public void rewriteRun(SourceSpec<?> ... sources) {
        this.rewriteRun((RecipeSpec spec) -> {}, sources);
    }

    default public ExecutionContext defaultExecutionContext(SourceSpec<?>[] sourceSpecs) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(t -> {
            if (t instanceof RecipeRunException) {
                Assertions.fail((String)("Failed to run recipe at " + ((RecipeRunException)t).getCursor()), (Throwable)t);
            }
            Assertions.fail((String)"Failed to parse sources or run recipe", (Throwable)t);
        });
        ParsingExecutionContextView.view((ExecutionContext)ctx).setCharset(StandardCharsets.UTF_8);
        return ctx;
    }

    @Override
    default public Iterator<SourceSpec<?>> iterator() {
        return new Iterator<SourceSpec<?>>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public SourceSpec<?> next() {
                throw new UnsupportedOperationException("RewriteTest is not intended to be iterated.");
            }
        };
    }

    default public void validateRecipeNameAndDescription(Recipe recipe) {
        if (recipe instanceof CompositeRecipe) {
            for (Recipe childRecipe : recipe.getRecipeList()) {
                this.validateRecipeNameAndDescription(childRecipe);
            }
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)recipe.getDisplayName()).as("%s display name should not end with a period.", new Object[]{recipe.getName()})).doesNotEndWith((CharSequence)".");
            String description = recipe.getDescription();
            ((AbstractStringAssert)Assertions.assertThat((String)description).as("%s description should not be null or empty", new Object[]{recipe.getName()})).isNotEmpty();
            if (description.endsWith(")")) {
                String lastLine = description.substring(description.lastIndexOf(10) + 1).trim();
                ((AbstractStringAssert)Assertions.assertThat((String)lastLine).as("%s description not ending with a period should be because the description ends with a markdown list of pure links", new Object[]{recipe.getName()})).startsWith((CharSequence)"- [");
            } else {
                ((AbstractStringAssert)Assertions.assertThat((String)description).as("%s description should end with a period.", new Object[]{recipe.getName()})).endsWith((CharSequence)".");
            }
        }
    }

    default public void validateRecipeOptions(Recipe recipe) {
        for (OptionDescriptor option : recipe.getDescriptor().getOptions()) {
            ((AbstractStringAssert)Assertions.assertThat((String)option.getName()).as("%s option `name` conflicts with the recipe's name. Please use a different field name for this option.", new Object[]{recipe.getName()})).isNotEqualTo((Object)"name");
        }
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

