/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.config.RecipeDescriptor;

@Incubating(since="8.12.1")
public interface RecipePrinter {
    public Consumer<CharSequence> consumer();

    default public void printTree(Recipe recipe) {
        this.consumer().accept(this.printRecipe(recipe.getDescriptor(), ""));
    }

    default public CharSequence printRecipe(RecipeDescriptor rd, String prefix) {
        String opts;
        List options = rd.getOptions();
        StringBuilder recipeString = new StringBuilder(prefix);
        recipeString.append(rd.getName());
        if (options != null && !options.isEmpty() && !(opts = options.stream().map(option -> {
            if (option.getValue() != null) {
                return String.format("%s=%s", option.getName(), option.getValue());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "))).isEmpty()) {
            recipeString.append(String.format(": {%s}", opts));
        }
        recipeString.append(System.lineSeparator());
        for (RecipeDescriptor child : rd.getRecipeList()) {
            recipeString.append(this.printRecipe(child, prefix + "  "));
        }
        return recipeString;
    }
}

