/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/tree/JavaTypeSerializerTest;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "serializeClass", "", "jp", "Lorg/openrewrite/java/JavaParser;", "serializeMethod", "serializeVariable", "serializeWildcard", "treeSerializer", "Lorg/openrewrite/TreeSerializer;", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "rewrite-test"})
public interface JavaTypeSerializerTest {
    @NotNull
    public TreeSerializer<J.CompilationUnit> treeSerializer();

    @NotNull
    public ObjectMapper objectMapper();

    @Test
    public void serializeClass(@NotNull JavaParser var1);

    @Test
    public void serializeWildcard(@NotNull JavaParser var1);

    @Test
    public void serializeMethod(@NotNull JavaParser var1);

    @Test
    public void serializeVariable(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static TreeSerializer<J.CompilationUnit> treeSerializer(@NotNull JavaTypeSerializerTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new TreeSerializer();
        }

        @NotNull
        public static ObjectMapper objectMapper(@NotNull JavaTypeSerializerTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ObjectMapper m = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
            ObjectMapper objectMapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"m.setVisibility(m.serializationConfig.defaultVisibilityChecker\n            .withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY)\n            .withGetterVisibility(JsonAutoDetect.Visibility.NONE)\n            .withIsGetterVisibility(JsonAutoDetect.Visibility.NONE)\n            .withFieldVisibility(JsonAutoDetect.Visibility.ANY))");
            return objectMapper;
        }

        @Test
        public static void serializeClass(@NotNull JavaTypeSerializerTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            import java.util.ArrayList;\n            import java.util.List;\n\n            public abstract class A extends ArrayList<String> implements List<String> {\n                protected static final class B extends ArrayList<String> implements List<String> {\n                }\n            \n                private class C extends ArrayList<String> implements List<String> {\n                }\n\n                class D extends ArrayList<String> implements List<String> {\n                }\n            }\n        "};
            J.ClassDeclaration clazz = (J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray).get(0)).getClasses().get(0);
            ObjectMapper mapper = this_.objectMapper();
            JavaType.FullyQualified javaClass = clazz.getType();
            String classTypeOut = mapper.writeValueAsString((Object)javaClass);
            JavaType.Class copy = (JavaType.Class)mapper.readValue(classTypeOut, JavaType.Class.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)javaClass), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(2);
            Object object = new Flag[]{Flag.Public, Flag.Abstract};
            Assertions.assertThat((boolean)copy.hasFlags(object)).isTrue();
            object = clazz.getBody().getStatements().get(0);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            }
            javaClass = ((J.ClassDeclaration)object).getType();
            classTypeOut = mapper.writeValueAsString((Object)javaClass);
            copy = (JavaType.Class)mapper.readValue(classTypeOut, JavaType.Class.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)javaClass), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(3);
            object = new Flag[]{Flag.Protected, Flag.Static, Flag.Final};
            Assertions.assertThat((boolean)copy.hasFlags(object)).isTrue();
            object = clazz.getBody().getStatements().get(1);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            }
            javaClass = ((J.ClassDeclaration)object).getType();
            classTypeOut = mapper.writeValueAsString((Object)javaClass);
            copy = (JavaType.Class)mapper.readValue(classTypeOut, JavaType.Class.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)javaClass), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(1);
            object = new Flag[]{Flag.Private};
            Assertions.assertThat((boolean)copy.hasFlags(object)).isTrue();
            object = clazz.getBody().getStatements().get(2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.ClassDeclaration");
            }
            javaClass = ((J.ClassDeclaration)object).getType();
            classTypeOut = mapper.writeValueAsString((Object)javaClass);
            copy = (JavaType.Class)mapper.readValue(classTypeOut, JavaType.Class.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)javaClass), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(0);
        }

        @Test
        public static void serializeWildcard(@NotNull JavaTypeSerializerTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            import java.util.ArrayList;\n            import java.util.List;\n            class E <T extends Number> {\n                List<? extends Number> numberList1 = new ArrayList<>();\n                List<? super Number> numberList2 = new ArrayList<>();\n                List<?> numberList3 = new ArrayList();\n                List<? extends T> numberList4 = new ArrayList<>();\n            }\n        "};
            J.ClassDeclaration clazz = (J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray).get(0)).getClasses().get(0);
            ObjectMapper mapper = this_.objectMapper();
            String classOut = mapper.writeValueAsString((Object)clazz);
            J.ClassDeclaration classCopy = (J.ClassDeclaration)mapper.readValue(classOut, J.ClassDeclaration.class);
            Assertions.assertThat((boolean)clazz.equals((Object)classCopy)).isTrue();
            Object e = clazz.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            JavaType variableType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e).getVariables().get(0)).getType();
            String variableTypeOut = mapper.writeValueAsString((Object)variableType);
            JavaType.Parameterized copy = (JavaType.Parameterized)mapper.readValue(variableTypeOut, JavaType.Parameterized.class);
            Object object = variableType;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            Object e2 = ((JavaType.Parameterized)object).getTypeParameters().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            JavaType.Class typeParameter = (JavaType.Class)e2;
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)variableType, (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((String)typeParameter.getFullyQualifiedName()).isEqualTo("java.lang.Number");
            e2 = clazz.getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            variableType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getType();
            variableTypeOut = mapper.writeValueAsString((Object)variableType);
            copy = (JavaType.Parameterized)mapper.readValue(variableTypeOut, JavaType.Parameterized.class);
            object = variableType;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            e2 = ((JavaType.Parameterized)object).getTypeParameters().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            typeParameter = (JavaType.Class)e2;
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)variableType, (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((String)typeParameter.getFullyQualifiedName()).isEqualTo("java.lang.Number");
            e2 = clazz.getBody().getStatements().get(2);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            variableType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getType();
            variableTypeOut = mapper.writeValueAsString((Object)variableType);
            copy = (JavaType.Parameterized)mapper.readValue(variableTypeOut, JavaType.Parameterized.class);
            object = variableType;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            e2 = ((JavaType.Parameterized)object).getTypeParameters().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            typeParameter = (JavaType.Class)e2;
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)variableType, (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((String)typeParameter.getFullyQualifiedName()).isEqualTo("java.lang.Object");
            e2 = clazz.getBody().getStatements().get(3);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            variableType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)e2).getVariables().get(0)).getType();
            variableTypeOut = mapper.writeValueAsString((Object)variableType);
            copy = (JavaType.Parameterized)mapper.readValue(variableTypeOut, JavaType.Parameterized.class);
            JavaType javaType = variableType;
            if (javaType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Parameterized");
            }
            object = ((JavaType.Parameterized)javaType).getTypeParameters().get(0);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.GenericTypeVariable");
            }
            JavaType.GenericTypeVariable genericTypeParameter = (JavaType.GenericTypeVariable)object;
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)variableType, (JavaType)((JavaType)copy))).isTrue();
            object = genericTypeParameter.getBound();
            Assertions.assertThat((String)(object == null ? null : object.getFullyQualifiedName())).isEqualTo("java.lang.Number");
        }

        @Test
        public static void serializeMethod(@NotNull JavaTypeSerializerTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            import java.util.List;\n\n            public abstract class A {\n                public abstract String getFoo(List<String> list);\n                private static String getFoo2(List<String> list) {\n                    return null;\n                }\n                protected final String getFoo3(List<String> list) {\n                    return null;\n                }\n                String getFoo4(List<String> list) {\n                    return null;\n                }\n            }\n        "};
            List statements = ((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray).get(0)).getClasses().get(0)).getBody().getStatements();
            ObjectMapper mapper = this_.objectMapper();
            Object e = statements.get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            JavaType.Method methodType = ((J.MethodDeclaration)e).getType();
            String methodTypeOut = mapper.writeValueAsString((Object)methodType);
            JavaType.Method copy = (JavaType.Method)mapper.readValue(methodTypeOut, JavaType.Method.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)methodType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(2);
            Object object = new Flag[]{Flag.Public, Flag.Abstract};
            Assertions.assertThat((boolean)copy.hasFlags(object)).isTrue();
            object = statements.get(1);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            methodType = ((J.MethodDeclaration)object).getType();
            methodTypeOut = mapper.writeValueAsString((Object)methodType);
            copy = (JavaType.Method)mapper.readValue(methodTypeOut, JavaType.Method.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)methodType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(2);
            object = new Flag[]{Flag.Private, Flag.Static};
            Assertions.assertThat((boolean)copy.hasFlags(object)).isTrue();
            object = statements.get(2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            methodType = ((J.MethodDeclaration)object).getType();
            methodTypeOut = mapper.writeValueAsString((Object)methodType);
            copy = (JavaType.Method)mapper.readValue(methodTypeOut, JavaType.Method.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)methodType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(2);
            object = new Flag[]{Flag.Protected, Flag.Final};
            Assertions.assertThat((boolean)copy.hasFlags(object)).isTrue();
            object = statements.get(3);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            methodType = ((J.MethodDeclaration)object).getType();
            methodTypeOut = mapper.writeValueAsString((Object)methodType);
            copy = (JavaType.Method)mapper.readValue(methodTypeOut, JavaType.Method.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)methodType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).isEmpty();
        }

        @Test
        public static void serializeVariable(@NotNull JavaTypeSerializerTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public abstract class A {\n                public String getFoo;\n                private final String getFoo2 = \"fred\";\n                protected static String getFoo3;\n                Long getFoo4;\n            }\n        "};
            JavaType.FullyQualified fullyQualified = ((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray).get(0)).getClasses().get(0)).getType();
            if (fullyQualified == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.JavaType.Class");
            }
            List members = ((JavaType.Class)fullyQualified).getMembers();
            ObjectMapper mapper = this_.objectMapper();
            JavaType.Variable variableType = (JavaType.Variable)members.get(0);
            String variableTypeOut = mapper.writeValueAsString((Object)variableType);
            JavaType.Variable copy = (JavaType.Variable)mapper.readValue(variableTypeOut, JavaType.Variable.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)variableType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(1);
            Flag[] flagArray = new Flag[]{Flag.Public};
            Assertions.assertThat((boolean)copy.hasFlags(flagArray)).isTrue();
            variableType = (JavaType.Variable)members.get(1);
            variableTypeOut = mapper.writeValueAsString((Object)variableType);
            copy = (JavaType.Variable)mapper.readValue(variableTypeOut, JavaType.Variable.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)variableType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(2);
            flagArray = new Flag[]{Flag.Private, Flag.Final};
            Assertions.assertThat((boolean)copy.hasFlags(flagArray)).isTrue();
            variableType = (JavaType.Variable)members.get(2);
            variableTypeOut = mapper.writeValueAsString((Object)variableType);
            copy = (JavaType.Variable)mapper.readValue(variableTypeOut, JavaType.Variable.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)variableType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).hasSize(2);
            flagArray = new Flag[]{Flag.Protected, Flag.Static};
            Assertions.assertThat((boolean)copy.hasFlags(flagArray)).isTrue();
            variableType = (JavaType.Variable)members.get(3);
            variableTypeOut = mapper.writeValueAsString((Object)variableType);
            copy = (JavaType.Variable)mapper.readValue(variableTypeOut, JavaType.Variable.class);
            Assertions.assertThat((boolean)TypeUtils.deepEquals((JavaType)((JavaType)variableType), (JavaType)((JavaType)copy))).isTrue();
            Assertions.assertThat((Iterable)copy.getFlags()).isEmpty();
        }
    }
}

