/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AssertionsKt;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeSerializer;
import org.openrewrite.java.tree.J;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/RecipeDiagnosticTest;", "", "()V", "httpClient", "Lokhttp3/OkHttpClient;", "treeSerializer", "Lorg/openrewrite/TreeSerializer;", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "assertChanged", "", "recipe", "Lorg/openrewrite/Recipe;", "moderneAstLink", "", "moderneApiBearerToken", "after", "assertUnchanged", "rewrite-test"})
public abstract class RecipeDiagnosticTest {
    @NotNull
    private final TreeSerializer<J.CompilationUnit> treeSerializer = new TreeSerializer();
    @NotNull
    private final OkHttpClient httpClient = new OkHttpClient.Builder().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertChanged(@NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
        Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        try {
            Request request = new Request.Builder().url(moderneAstLink).header("Authorization", moderneApiBearerToken).build();
            Closeable closeable = (Closeable)this.httpClient.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl3 = false;
                boolean bl4 = response.isSuccessful();
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = Intrinsics.stringPlus((String)"Unexpected status ", (Object)response);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    throw new IllegalStateException("No response body");
                }
                ResponseBody responseBody2 = responseBody;
                J.CompilationUnit source = (J.CompilationUnit)this.treeSerializer.read(responseBody2.byteStream());
                List results = recipe2.run(CollectionsKt.listOf((Object)source), (ExecutionContext)new InMemoryExecutionContext(RecipeDiagnosticTest::assertChanged$lambda-2$lambda-1), 2);
                if (results.isEmpty()) {
                    Assertions.fail((String)"The recipe must make changes");
                }
                Intrinsics.checkNotNullExpressionValue((Object)results, (String)"results");
                Result result = (Result)CollectionsKt.first((List)results);
                ((ObjectAssert)Assertions.assertThat((Object)result).as("The recipe must make changes", new Object[0])).isNotNull();
                Intrinsics.checkNotNull((Object)result);
                Assertions.assertThat((Object)result.getAfter()).isNotNull();
                SourceFile sourceFile = result.getAfter();
                Intrinsics.checkNotNull((Object)sourceFile);
                AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)sourceFile.print(null)).isEqualTo(StringsKt.trimIndent((String)after));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertUnchanged(@NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
        Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
        Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
        try {
            Request request = new Request.Builder().url(moderneAstLink).header("Authorization", moderneApiBearerToken).build();
            Closeable closeable = (Closeable)this.httpClient.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Response response = (Response)closeable;
                boolean bl3 = false;
                boolean bl4 = response.isSuccessful();
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = Intrinsics.stringPlus((String)"Unexpected status ", (Object)response);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    throw new IllegalStateException("No response body");
                }
                ResponseBody responseBody2 = responseBody;
                J.CompilationUnit source = (J.CompilationUnit)this.treeSerializer.read(responseBody2.byteStream());
                List results = recipe2.run(CollectionsKt.listOf((Object)source), (ExecutionContext)new InMemoryExecutionContext(RecipeDiagnosticTest::assertUnchanged$lambda-6$lambda-4), 2);
                Intrinsics.checkNotNullExpressionValue((Object)results, (String)"results");
                Iterable $this$forEach$iv = results;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Result result = (Result)element$iv;
                    boolean bl8 = false;
                    CharSequence charSequence = result.diff();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"result.diff()");
                    charSequence = charSequence;
                    boolean bl9 = false;
                    if (!(charSequence.length() == 0)) continue;
                    AssertionsKt.fail$default((String)"An empty diff was generated. The recipe incorrectly changed a reference without changing its contents.", null, (int)2, null);
                    throw new KotlinNothingValueException();
                }
                for (Result result : results) {
                    SourceFile sourceFile = result.getAfter();
                    AbstractStringAssert abstractStringAssert = (AbstractStringAssert)Assertions.assertThat(sourceFile == null ? null : sourceFile.print(null)).as("The recipe must not make changes", new Object[0]);
                    sourceFile = result.getBefore();
                    abstractStringAssert.isEqualTo(sourceFile == null ? null : sourceFile.print(null));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final void assertChanged$lambda-2$lambda-1(Throwable t) {
        Assertions.fail((String)"Recipe threw an exception", (Throwable)t);
    }

    private static final void assertUnchanged$lambda-6$lambda-4(Throwable t) {
        Assertions.fail((String)"Recipe threw an exception", (Throwable)t);
    }
}

