/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/tree/MethodDeclarationTest;", "Lorg/openrewrite/java/JavaTreeTest;", "constructor", "", "jp", "Lorg/openrewrite/java/JavaParser;", "default", "hasModifier", "hasThrownExceptionInType", "interfaceMethodDecl", "methodWithSuffixMultiComment", "modifiedUtf8SurrogateCharacterLiterals", "nativeModifier", "throws", "typeArguments", "rewrite-test"})
public interface MethodDeclarationTest
extends JavaTreeTest {
    @Test
    public void default(@NotNull JavaParser var1);

    @Test
    public void constructor(@NotNull JavaParser var1);

    @Test
    public void typeArguments(@NotNull JavaParser var1);

    @Test
    public void interfaceMethodDecl(@NotNull JavaParser var1);

    @Test
    public void throws(@NotNull JavaParser var1);

    @Test
    public void nativeModifier(@NotNull JavaParser var1);

    @Test
    public void methodWithSuffixMultiComment(@NotNull JavaParser var1);

    @Test
    public void hasModifier(@NotNull JavaParser var1);

    @Test
    public void modifiedUtf8SurrogateCharacterLiterals(@NotNull JavaParser var1);

    @Test
    public void hasThrownExceptionInType(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void default(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public @interface A {\n                String foo() default \"foo\";\n            }\n        ", new String[0]);
        }

        @Test
        public static void constructor(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public class A {\n                public A() { }\n            }\n        ", new String[0]);
        }

        @Test
        public static void typeArguments(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public <P, R> R foo(P p, String s, String... args) {\n                return null;\n            }\n        ", new String[0]);
        }

        @Test
        public static void interfaceMethodDecl(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public interface A {\n                String getName() ;\n            }\n        ", new String[0]);
        }

        @Test
        public static void throws(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public void foo()  throws Exception { }\n        ", new String[0]);
        }

        @Test
        public static void nativeModifier(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public native void foo();\n        ", new String[0]);
        }

        @Test
        public static void methodWithSuffixMultiComment(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public void foo() { }/*Comments*/\n        ", new String[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void hasModifier(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class A {\n                private static boolean foo() { return true; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(stringArray).get(0);
            List list = ((J.ClassDeclaration)a.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.MethodDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            J.MethodDeclaration inv = (J.MethodDeclaration)CollectionsKt.first((List)((List)destination$iv$iv));
            Assertions.assertThat((List)inv.getModifiers()).hasSize(2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Private));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Static));
        }

        @Test
        public static void modifiedUtf8SurrogateCharacterLiterals(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n                public class A {\n                    private boolean isSockJsSpecialChar(char ch) {\n                        return (ch <= '\\u001F') || (ch >= '\\u200C' && ch <= '\\u200F') ||\n                            (ch >= '\\u2028' && ch <= '\\u202F') || (ch >= '\\u2060' && ch <= '\\u206F') ||\n                            (ch >= '\\uFFF0') || (ch >= '\\uD800' && ch <= '\\uDFFF');\n                    }\n                }\n            ", new String[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void hasThrownExceptionInType(@NotNull MethodDeclarationTest this_, @NotNull JavaParser jp) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            import java.io.IOException;\n            \n            public class A {\n                private static boolean foo(boolean flag) throws IOException, ArithmeticException, org.example.WhatTypeOfExceptionIsThis {\n                    if (flag) {\n                        throw new WhatTypeOfExceptionIsThis();\n                    } else {\n                        throw new IOException();\n                    }\n                } \n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(stringArray).get(0);
            List list = ((J.ClassDeclaration)a.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.MethodDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            J.MethodDeclaration inv = (J.MethodDeclaration)CollectionsKt.first((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = inv.getType();
            Intrinsics.checkNotNull((Object)$this$filterIsInstance$iv);
            Assertions.assertThat((List)$this$filterIsInstance$iv.getThrownExceptions()).hasSize(3);
            Object[] objectArray = inv.getType();
            Intrinsics.checkNotNull((Object)objectArray);
            List fullyQualifiedNames = objectArray.getThrownExceptions().stream().map(JavaType.FullyQualified::getFullyQualifiedName).collect(Collectors.toList());
            objectArray = new String[]{"java.io.IOException", "java.lang.ArithmeticException", "org.example.WhatTypeOfExceptionIsThis"};
            Assertions.assertThat(fullyQualifiedNames).contains(objectArray);
        }
    }
}

