/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.security;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.security.XmlParserXXEVulnerability;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/security/XmlParserXXEVulnerabilityTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "factoryConstructorInitialization", "", "factoryExternalWithClassBlockInitialization", "factoryIsNotVulnerable", "jp", "Lorg/openrewrite/java/JavaParser;", "factoryIsNotVulnerableClassBlockInitialization", "factoryIsVulnerableWithClassBlockInitialization", "factoryIsVulnerableWithMethodInitialization", "factoryNeedsDtdWithClassBlockInitialization", "rewrite-test"})
public interface XmlParserXXEVulnerabilityTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void factoryIsNotVulnerable(@NotNull JavaParser var1);

    @Test
    public void factoryIsNotVulnerableClassBlockInitialization(@NotNull JavaParser var1);

    @Test
    public void factoryIsVulnerableWithMethodInitialization();

    @Test
    public void factoryConstructorInitialization();

    @Test
    public void factoryIsVulnerableWithClassBlockInitialization();

    @Test
    public void factoryNeedsDtdWithClassBlockInitialization();

    @Test
    public void factoryExternalWithClassBlockInitialization();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new XmlParserXXEVulnerability();
        }

        @Test
        public static void factoryIsNotVulnerable(@NotNull XmlParserXXEVulnerabilityTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertUnchanged("\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                public void parseXML(InputStream input) {\n                    XMLInputFactory factory = XMLInputFactory.newFactory();\n                    factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                    factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ");
        }

        @Test
        public static void factoryIsNotVulnerableClassBlockInitialization(@NotNull XmlParserXXEVulnerabilityTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertUnchanged("\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n                {\n                    factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                    factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                }\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ");
        }

        @Test
        public static void factoryIsVulnerableWithMethodInitialization(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.assertChanged("\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                public void parseXML(InputStream input) {\n                    XMLInputFactory f = XMLInputFactory.newFactory();\n                    XMLStreamReader reader = f.createXMLStreamReader(input);\n                }\n            }\n        ", "\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                public void parseXML(InputStream input) {\n                    XMLInputFactory f = XMLInputFactory.newFactory();\n                    f.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                    f.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                    XMLStreamReader reader = f.createXMLStreamReader(input);\n                }\n            }\n        ");
        }

        @Test
        public static void factoryConstructorInitialization(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.assertChanged("\n            import javax.xml.stream.XMLInputFactory;\n            public class MyXmlReader {\n                private XMLInputFactory f;\n                public MyXmlReader() {\n                    f = XMLInputFactory.newFactory();\n                    f.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                }\n            }\n        ", "\n            import javax.xml.stream.XMLInputFactory;\n            public class MyXmlReader {\n                private XMLInputFactory f;\n                public MyXmlReader() {\n                    f = XMLInputFactory.newFactory();\n                    f.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                    f.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                }\n            }\n        ");
        }

        @Test
        public static void factoryIsVulnerableWithClassBlockInitialization(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.assertChanged("\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ", "\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n            \n                {\n                    factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                    factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                }\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ");
        }

        @Test
        public static void factoryNeedsDtdWithClassBlockInitialization(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.assertChanged("\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n                \n                {\n                    factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                }\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ", "\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n                \n                {\n                    factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                    factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                }\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ");
        }

        @Test
        public static void factoryExternalWithClassBlockInitialization(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.assertChanged("\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n                \n                {\n                    factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                }\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ", "\n            import javax.xml.stream.XMLInputFactory;\n            import javax.xml.stream.XMLStreamReader;\n            import java.io.InputStream;\n            public class MyXmlReader {\n                XMLInputFactory factory = XMLInputFactory.newFactory();\n                \n                {\n                    factory.setProperty(XMLInputFactory.SUPPORT_DTD, false);\n                    factory.setProperty(XMLInputFactory.IS_SUPPORTING_EXTERNAL_ENTITIES, false);\n                }\n                public void parseXML(InputStream input) {\n                    XMLStreamReader reader = factory.createXMLStreamReader(input);\n                }\n            }\n        ");
        }

        public static <T extends SourceFile> void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesToComplete, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles, expectedCyclesToComplete);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull XmlParserXXEVulnerabilityTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull XmlParserXXEVulnerabilityTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull XmlParserXXEVulnerabilityTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

