/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.openrewrite.MetricsExtension;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.BlockStatementTemplateGenerator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

@ExtendWith(value={MetricsExtension.class})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/search/BlockStatementTemplateGeneratorTest;", "", "beforeAssert", "", "cu", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "classInit", "", "jp", "Lorg/openrewrite/java/JavaParser;", "format", "s", "generateTemplate", "staticClassInit", "rewrite-test"})
public interface BlockStatementTemplateGeneratorTest {
    @Test
    public void generateTemplate(@NotNull JavaParser var1);

    @Test
    public void classInit(@NotNull JavaParser var1);

    @Test
    public void staticClassInit(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void generateTemplate(@NotNull BlockStatementTemplateGeneratorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            import java.io.FileInputStream;\n            import java.util.function.Function;\n            class Outer {\n                int n;\n                void outer(int p1) {\n                    int n2 = 1;\n                    for(int index;;) {\n                    }\n                    try(FileInputStream f = new FileInputStream(\"\")) {\n                        for(int a : Arrays.asList(0, 1)) {\n                            for(int index; index < 100; index++) {\n                                Function<Integer, Function<Integer, Object>> o = \n                                        (p2) -> {\n                                            Function<Integer, Object> o2 = \n                                                    (Integer p3) ->\n                                                        new Object() {\n                                                            void inner(int p4) {\n                                                                assert n == 0;\n                                                            }\n                                                        };\n                                            return o2;\n                                        };\n                            }\n                            int n3;\n                        }\n                    }\n                    int n4;\n                }\n                \n                int o;\n                int m() {\n                    return 0;\n                }\n                \n                private class Inner {\n                    void m2() {}\n                }\n            }\n        "};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            String expected = "package org.openrewrite;\n\nimport java.util.function.Function;\nimport java.io.FileInputStream;\n\nclass Outer {\n    private class Inner {\n        void m2() {}\n    }\n\n    int m() {\n        return 0;\n    }\n\n    int o;\n    int n;\n\n    void outer(int p1) {\n        int n2 = 0;\n        try (FileInputStream f = new FileInputStream(\"\"); ) {\n            for (int a : Arrays.asList(0, 1)) {\n                for (int index; ; ) {\n                    Function<Integer, Function<Integer, Object>> o =\n                            (p2) -> {\n                                if (true) {\n                                    {\n                                        Function<Integer, Object> o2 =\n                                                (Integer p3) -> {\n                                                    if (true) {\n                                                        new Object() {\n                                                            void inner(int p4) {\n                                                                /*__TEMPLATE__*/ assert n == 1;\n                                                            }\n                                                        };\n                                                    }\n                                                    return null;\n                                                };\n                                    }\n                                    ;\n                                }\n                                return null;\n                            };\n                }\n            }\n        } catch (Throwable t) {\n            throw new RuntimeException(t);\n        }\n    }\n}";
            Intrinsics.checkNotNullExpressionValue((Object)cu, (String)"cu");
            Assertions.assertThat((String)DefaultImpls.beforeAssert(this_, cu)).isEqualTo(expected);
        }

        @Test
        public static void classInit(@NotNull BlockStatementTemplateGeneratorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    int n;\n    {\n        int n;\n        assert n == 0;\n    }\n}"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            String expected = "class Test {\n    int n;\n\n    {\n        int n = 0;\n        /*__TEMPLATE__*/ assert n == 1;\n    }\n}";
            Intrinsics.checkNotNullExpressionValue((Object)cu, (String)"cu");
            Assertions.assertThat((String)DefaultImpls.beforeAssert(this_, cu)).isEqualTo(expected);
        }

        @Test
        public static void staticClassInit(@NotNull BlockStatementTemplateGeneratorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    int n;\n    static {\n        int n;\n        assert n == 0;\n    }\n}"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            String expected = "class Test {\n    int n;\n\n    static {\n        int n = 0;\n        /*__TEMPLATE__*/ assert n == 1;\n    }\n}";
            Intrinsics.checkNotNullExpressionValue((Object)cu, (String)"cu");
            Assertions.assertThat((String)DefaultImpls.beforeAssert(this_, cu)).isEqualTo(expected);
        }

        private static String beforeAssert(BlockStatementTemplateGeneratorTest this_, J.CompilationUnit cu) {
            StringBuilder s = new StringBuilder();
            new JavaVisitor<StringBuilder>(){

                @NotNull
                public J visitAssert(@NotNull J.Assert assert_, @NotNull StringBuilder p) {
                    Intrinsics.checkNotNullParameter((Object)assert_, (String)"assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    p.append(new BlockStatementTemplateGenerator(SetsKt.emptySet()).template(this.getCursor(), "assert n == 1;", Space.Location.STATEMENT_PREFIX));
                    return (J)assert_;
                }
            }.visit((Tree)cu, (Object)s);
            String string = s.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s.toString()");
            return DefaultImpls.format(this_, string);
        }

        private static String format(BlockStatementTemplateGeneratorTest this_, String s) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build()).formatSource(CharSource.wrap((CharSequence)s), new CharSink(bos){
                final /* synthetic */ ByteArrayOutputStream $bos;
                {
                    this.$bos = $bos;
                }

                @NotNull
                public OutputStreamWriter openStream() {
                    return new OutputStreamWriter(this.$bos);
                }
            });
            Object object = bos.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bos.toByteArray()");
            boolean bl = false;
            object = new String((byte[])object, Charsets.UTF_8);
            bl = false;
            return ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
        }
    }
}

