/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\bf\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\f\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u001a\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\rH\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u001f"}, d2={"Lorg/openrewrite/java/JavaTemplateTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addClassAnnotations", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addMethodAnnotations", "afterStatementInBlock", "beforeStatementInBlock", "lastStatementInClassBlock", "lastStatementInMethodBlock", "replaceArguments", "replaceBody", "Lorg/openrewrite/java/JavaParser$Builder;", "replaceClassAnnotation", "replaceClassAnnotations", "replaceClassExtends", "replaceClassImplements", "replaceClassTypeParameters", "replaceLambdaParameters", "replaceMethod", "replaceMethodAnnotations", "replaceMethodParameters", "replaceMethodTypeParameters", "replacePackage", "replaceSingleStatement", "replaceStatementInBlock", "replaceStatementRequiringNewImport", "replaceThrows", "replaceVariableAnnotations", "Companion", "rewrite-test"})
public interface JavaTemplateTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.JavaTemplateTest$Companion.$$INSTANCE;

    @Test
    public void replacePackage(@NotNull JavaParser var1);

    @Test
    public void replaceMethod(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaParameters(@NotNull JavaParser var1);

    @Test
    public void replaceSingleStatement(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void beforeStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void afterStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void replaceStatementRequiringNewImport(@NotNull JavaParser var1);

    @Test
    public void replaceArguments(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotation(@NotNull JavaParser var1);

    @Test
    public void replaceMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceVariableAnnotations(@NotNull JavaParser var1);

    @Test
    public void addMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void addClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassImplements(@NotNull JavaParser var1);

    @Test
    public void replaceClassExtends(@NotNull JavaParser var1);

    @Test
    public void replaceThrows(@NotNull JavaParser var1);

    @Test
    public void replaceMethodTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceClassTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceBody(@NotNull JavaParser.Builder<?, ?> var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/JavaTemplateTest$Companion;", "", "()V", "print", "Ljava/util/function/Consumer;", "", "getPrint", "()Ljava/util/function/Consumer;", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Consumer<String> print;

        private Companion() {
        }

        @NotNull
        public final Consumer<String> getPrint() {
            return print;
        }

        private static final void print$lambda-0(String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build()).formatSource(CharSource.wrap((CharSequence)s), new CharSink(bos){
                    final /* synthetic */ ByteArrayOutputStream $bos;
                    {
                        this.$bos = $bos;
                    }

                    @NotNull
                    public OutputStreamWriter openStream() {
                        return new OutputStreamWriter(this.$bos);
                    }
                });
                String string = bos.toString(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bos.toString(Charsets.UTF_8)");
                boolean bl = false;
                string = ((Object)StringsKt.trim((CharSequence)string)).toString();
                bl = false;
                System.out.println((Object)string);
            }
            catch (Throwable _) {
                String string = "Unable to format:";
                boolean bl = false;
                System.out.println((Object)string);
                boolean bl2 = false;
                System.out.println((Object)s);
            }
        }

        static {
            $$INSTANCE = new Companion();
            print = Companion::print$lambda-0;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void replacePackage(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("b").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Package visitPackage(@NotNull J.Package pkg, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)pkg.getExpression().printTrimmed(), (Object)"a")) {
                        J j = pkg.withTemplate(this.t, pkg.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"pkg.withTemplate(t, pkg.coordinates.replace())");
                        return (J.Package)j;
                    }
                    J.Package package_ = super.visitPackage(pkg, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"super.visitPackage(pkg, p)");
                    return package_;
                }
            }), "\n            package a;\n            class Test {\n            }\n        ", null, "\n            package b;\n            class Test {\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("void test2() {}").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test")) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replace())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                void test() {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                void test2() {\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int m, int n").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test") && method.getParameters().size() == 1) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceParameters())");
                        J.MethodDeclaration m = (J.MethodDeclaration)j;
                        Object object = method.getBody();
                        Intrinsics.checkNotNull((Object)object);
                        E e = object.getStatements().get(0);
                        if (e == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
                        }
                        J.NewClass newRunnable = (J.NewClass)e;
                        J.Block block2 = newRunnable.getBody();
                        Intrinsics.checkNotNull((Object)block2);
                        object = block2.getStatements().get(0);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
                        }
                        J.MethodDeclaration innerMethod = (J.MethodDeclaration)object;
                        object = m.withTemplate(this.t, innerMethod.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"m.withTemplate(t, innerMethod.coordinates.replaceParameters())");
                        return (J.MethodDeclaration)object;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int m, int n) {\n                    new Runnable() {\n                        void inner(int m, int n) {\n                        }\n                    };\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceLambdaParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int m, int n").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Lambda visitLambda(@NotNull J.Lambda lambda, @NotNull ExecutionContext p) {
                    J.Lambda lambda2;
                    Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (lambda.getParameters().getParameters().size() == 1) {
                        J j = lambda.withTemplate(this.t, lambda.getParameters().getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"{\n                    lambda.withTemplate(t, lambda.parameters.coordinates.replace())\n                }");
                        lambda2 = (J.Lambda)j;
                    } else {
                        J.Lambda lambda3 = super.visitLambda(lambda, (Object)p);
                        Intrinsics.checkNotNullExpressionValue((Object)lambda3, (String)"{\n                    super.visitLambda(lambda, p)\n                }");
                        lambda2 = lambda3;
                    }
                    return lambda2;
                }
            }), "\n            class Test {\n                void test() {\n                    Object o = () -> 1;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    Object o = (int m, int n) -> 1;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceSingleStatement(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("if(n != 1) {\n  n++;\n}").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitAssert(@NotNull J.Assert _assert, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)_assert, (String)"_assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = _assert.withTemplate(this.t, _assert.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"_assert.withTemplate(t, _assert.coordinates.replace())");
                    return j;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    if (n != 1) {\n                        n++;\n                    }\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.logCompilationWarningsAndErrors(true).build(), (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 2;\nn = 3;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(1);
                    if (statement instanceof J.Unary) {
                        block2 = method.withTemplate(this.t, ((J.Unary)statement).getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, statement.coordinates.replace())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n = 2;\n                    n = 3;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void beforeStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("assert n == 0;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(0);
                    if (statement instanceof J.Assignment) {
                        block2 = method.withTemplate(this.t, ((J.Assignment)statement).getCoordinates().before(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, statement.coordinates.before())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void afterStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 1;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        block2 = method.withTemplate(this.t, ((Statement)block3.getStatements().get(0)).getCoordinates().after(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, method.body!!.statements[0].coordinates.after())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void lastStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int n;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getBody().getStatements().isEmpty()) {
                        J j = classDecl.withTemplate(this.t, classDecl.getBody().getCoordinates().lastStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.body.coordinates.lastStatement())");
                        return j;
                    }
                    return (J)classDecl;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            class Test {\n                int n;\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void lastStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 1;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        block2 = method.withTemplate(this.t, block3.getCoordinates().lastStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, method.body!!.coordinates.lastStatement())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceStatementRequiringNewImport(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.util.List"};
                    this.t = this.template("List<String> s = null;").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitAssert(@NotNull J.Assert _assert, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)_assert, (String)"_assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    this.maybeAddImport("java.util.List");
                    J j = _assert.withTemplate(this.t, _assert.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"_assert.withTemplate(t, _assert.coordinates.replace())");
                    return j;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n                int n;\n                void test() {\n                    List<String> s = null;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceArguments(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("m, n").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getArguments().size() == 1) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceArguments(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceArguments())");
                        return (J.MethodInvocation)j;
                    }
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, p)");
                    return methodInvocation2;
                }
            }), "\n            abstract class Test {\n                abstract void test();\n            \n                void test(int m, int n) {\n                    test();\n                }\n            }\n        ", null, "\n            abstract class Test {\n                abstract void test();\n            \n                void test(int m, int n) {\n                    test(m, n);\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceClassAnnotation(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@Deprecated").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"SuppressWarnings")) {
                        J j = annotation2.withTemplate(this.t, annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(t, annotation.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    J.Annotation annotation3 = super.visitAnnotation(annotation2, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"super.visitAnnotation(annotation, p)");
                    return annotation3;
                }
            }), "@SuppressWarnings(\"ALL\") class Test {}", null, "@Deprecated class Test {}", 0, 40, null);
        }

        @Test
        public static void replaceMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getLeadingAnnotations().size() == 0) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceAnnotations())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public @SuppressWarnings(WARNINGS) Test() {\n                }\n            \n                public void test1() {\n                }\n            \n                public @SuppressWarnings(WARNINGS) void test2() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public Test() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test1() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test2() {\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getLeadingAnnotations().size() == 0 && !Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"Test")) {
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceAnnotations())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n                \n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceVariableAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.VariableDeclarations visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)multiVariable, (String)"multiVariable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (multiVariable.getLeadingAnnotations().size() == 0) {
                        J j = multiVariable.withTemplate(this.t, multiVariable.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"multiVariable.withTemplate(t, multiVariable.coordinates.replaceAnnotations())");
                        return (J.VariableDeclarations)j;
                    }
                    J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)variableDeclarations, (String)"super.visitVariableDeclarations(multiVariable, p)");
                    return variableDeclarations;
                }
            }), "\n            class Test {\n                void test() {\n                    int m;\n                    final @SuppressWarnings(\"ALL\") int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"other\") int m;\n                    @SuppressWarnings(\"other\") final int n;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void addMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getLeadingAnnotations().size() == 0) {
                        J j = method.withTemplate(this.t, method.getCoordinates().addAnnotation(Comparator.comparing(addMethodAnnotations.1::visitMethodDeclaration$lambda-0)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.addAnnotation(comparing { it.simpleName }))");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final String visitMethodDeclaration$lambda-0(J.Annotation it) {
                    return it.getSimpleName();
                }
            }), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public void test() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public void test() {\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void addClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getLeadingAnnotations().size() == 0 && !Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"Test")) {
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().addAnnotation(Comparator.comparing(addClassAnnotations.1::visitClassDeclaration$lambda-0)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.addAnnotation(comparing { it.simpleName }))");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final String visitClassDeclaration$lambda-0(J.Annotation it) {
                    return it.getSimpleName();
                }
            }), "\n            class Test {\n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceClassImplements(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.io.*"};
                    this.t = this.template("Serializable, Closeable").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getImplements() == null) {
                        this.maybeAddImport("java.io.Closeable");
                        this.maybeAddImport("java.io.Serializable");
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceImplementsClause(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceImplementsClause())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            import java.io.Closeable;\n            import java.io.Serializable;\n            \n            class Test implements Serializable, Closeable {\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceClassExtends(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.util.*"};
                    this.t = this.template("List<String>").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getExtends() == null) {
                        this.maybeAddImport("java.util.List");
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceExtendsClause(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceExtendsClause())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test extends List<String> {\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceThrows(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("Exception").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getThrows() == null) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceThrows(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceThrows())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                void test() {}\n            }\n        ", null, "\n            class Test {\n                void test() throws Exception {}\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceMethodTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("T, U").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getTypeParameters() == null) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceTypeParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceTypeParameters())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n            \n                void test() {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                <T, U> void test() {\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceClassTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("T, U").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getTypeParameters() == null) {
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceTypeParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceTypeParameters())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            class Test<T, U> {\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void replaceBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.logCompilationWarningsAndErrors(true).build(), (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 1;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(0);
                    if (statement instanceof J.Unary) {
                        block2 = method.withTemplate(this.t, method.getCoordinates().replaceBody(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, method.coordinates.replaceBody())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", 0, 40, null);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesToComplete, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles, expectedCyclesToComplete);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull JavaTemplateTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

