/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/tree/LiteralTest;", "Lorg/openrewrite/java/JavaTreeTest;", "escapedCharacter", "", "jp", "Lorg/openrewrite/java/JavaParser;", "escapedString", "literalBinary", "literalCharacter", "literalField", "literalHex", "literalNumerics", "literalOctal", "nullLiteral", "transformLong", "transformString", "variationInSuffixCasing", "rewrite-test"})
public interface LiteralTest
extends JavaTreeTest {
    @Test
    public void literalField(@NotNull JavaParser var1);

    @Test
    public void literalCharacter(@NotNull JavaParser var1);

    @Test
    public void literalNumerics(@NotNull JavaParser var1);

    @Test
    public void literalOctal(@NotNull JavaParser var1);

    @Test
    public void literalBinary(@NotNull JavaParser var1);

    @Test
    public void literalHex(@NotNull JavaParser var1);

    @Test
    public void transformString(@NotNull JavaParser var1);

    @Test
    public void nullLiteral(@NotNull JavaParser var1);

    @Test
    public void transformLong(@NotNull JavaParser var1);

    @Test
    public void variationInSuffixCasing(@NotNull JavaParser var1);

    @Test
    public void escapedString(@NotNull JavaParser var1);

    @Test
    public void escapedCharacter(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void literalField(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            int n = 0;\n        ", new String[0]);
        }

        @Test
        public static void literalCharacter(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            char c = 'a';\n        ", new String[0]);
        }

        @Test
        public static void literalNumerics(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            double d1 = 1.0d;\n            double d2 = 1.0;\n            long l1 = 1L;\n            long l2 = 1;\n        ", new String[0]);
        }

        @Test
        public static void literalOctal(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            long l = 01L;\n            byte b = 01;\n            short s = 01;\n            int i = 01;\n            double d = 01;\n            float f = 01;\n        ", new String[0]);
        }

        @Test
        public static void literalBinary(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            long l = 0b10L;\n            byte b = 0b10;\n            short s = 0b10;\n            int i = 0b10;\n        ", new String[0]);
        }

        @Test
        public static void literalHex(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            long l = 0xA0L;\n            byte b = 0xA0;\n            short s = 0xA0;\n            int i = 0xA0;\n        ", new String[0]);
        }

        @Test
        public static void transformString(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            String s = \"foo ''\";\n        ", new String[0]);
        }

        @Test
        public static void nullLiteral(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            String s = null;\n        ", new String[0]);
        }

        @Test
        public static void transformLong(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            Long l = 2L;\n        ", new String[0]);
        }

        @Test
        public static void variationInSuffixCasing(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            Long l = 0l;\n            Long m = 0L;\n        ", new String[0]);
        }

        @Test
        public static void escapedString(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            String s = \"\\\"\";\n        ", new String[0]);
        }

        @Test
        public static void escapedCharacter(@NotNull LiteralTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            char c = '\\'';\n        ", new String[0]);
        }
    }
}

