/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.search.FindTypes;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\bf\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/search/FindTypesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/search/FindTypes;", "getRecipe", "()Lorg/openrewrite/java/search/FindTypes;", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "checkValidation", "classDecl", "classReference", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "methodWithParameterizedType", "multiCatch", "multiVariable", "newClass", "parameterizedType", "simpleName", "typeCast", "Companion", "rewrite-test"})
public interface FindTypesTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.FindTypesTest$Companion.$$INSTANCE;

    @NotNull
    public FindTypes getRecipe();

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodWithParameterizedType(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindTypesTest$Companion;", "", "()V", "a1", "", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String a1 = "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static FindTypes getRecipe(@NotNull FindTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new FindTypes("a.A1");
        }

        @Test
        public static void simpleName(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B extends A1 {}\n        ", stringArray2, "\n            import a.A1;\n            public class B extends /*~~>*/A1 {}\n        ", 0, 34, null);
        }

        @Test
        public static void fullyQualifiedName(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "public class B extends a.A1 {}", stringArray2, "public class B extends /*~~>*/a.A1 {}", 0, 34, null);
        }

        @Test
        public static void annotation(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindTypes findTypes = new FindTypes("A1");
            String[] stringArray = new String[]{"public @interface A1 {}"};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)findTypes, "@A1 public class B {}", stringArray2, "@/*~~>*/A1 public class B {}", 0, 32, null);
        }

        @Test
        public static void array(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", stringArray2, "\n            import a.A1;\n            public class B {\n               /*~~>*/A1[] a = new /*~~>*/A1[0];\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void classDecl(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = this_.getRecipe().doNext((Recipe)new FindTypes("I1"));
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ", "public interface I1 {}"};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, recipe2, "\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ", stringArray2, "\n            import a.A1;\n            public class B extends /*~~>*/A1 implements /*~~>*/I1 {}\n        ", 0, 32, null);
        }

        @Test
        public static void method(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", stringArray2, "\n            import a.A1;\n            public class B {\n               public /*~~>*/A1 foo() throws /*~~>*/A1 { return null; }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void methodWithParameterizedType(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)new FindTypes("java.util.List"), "\n            import java.util.List;\n            public class B {\n               public List<String> foo() { return null; }\n            }\n        ", null, "\n            import java.util.List;\n            public class B {\n               public /*~~>*/List<String> foo() { return null; }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in) { return null; }\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, null);\n               }\n            }\n        ", stringArray2, "\n            import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends /*~~>*/A1> T generic(T n, List<? super /*~~>*/A1> in) { return null; }\n               public void test() {\n                   /*~~>*/A1.stat();\n                   this.</*~~>*/A1>generic(null, null);\n               }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void multiCatch(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", stringArray2, "\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(/*~~>*/A1 | RuntimeException e) {}\n               }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void multiVariable(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ", stringArray2, "\n            import a.A1;\n            public class B {\n               /*~~>*/A1 f1, f2;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void newClass(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ", stringArray2, "\n            import a.A1;\n            public class B {\n               /*~~>*/A1 a = new /*~~>*/A1();\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void parameterizedType(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            import java.util.Map;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ", stringArray2, "\n            import a.A1;\n            import java.util.Map;\n            public class B {\n               Map</*~~>*/A1, /*~~>*/A1> m;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void typeCast(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = (A1) null;\n            }\n        ", stringArray2, "\n            import a.A1;\n            public class B {\n               /*~~>*/A1 a = (/*~~>*/A1) null;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void classReference(@NotNull FindTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n                import a.A1;\n                class B {\n                    Class<?> clazz = A1.class;\n                }\n            ", stringArray2, "\n                import a.A1;\n                class B {\n                    Class<?> clazz = /*~~>*/A1.class;\n                }\n            ", 0, 34, null);
        }

        @Test
        public static void checkValidation(@NotNull FindTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            FindTypes recipe2 = new FindTypes(null);
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("fullyQualifiedTypeName");
            recipe2 = new FindTypes("com.foo.Foo");
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isTrue();
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindTypesTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesToComplete, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindTypesTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull FindTypesTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles, expectedCyclesToComplete);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull FindTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull FindTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull FindTypesTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull FindTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FindTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

