/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindInheritedFields;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/search/FindInheritedFieldsTest;", "", "findArrayOfType", "", "jp", "Lorg/openrewrite/java/JavaParser;", "findInheritedField", "rewrite-test"})
public interface FindInheritedFieldsTest {
    @Test
    public void findInheritedField(@NotNull JavaParser var1);

    @Test
    public void findArrayOfType(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void findInheritedField(@NotNull FindInheritedFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String a = "\n            import java.util.*;\n            public class A {\n               protected List list;\n               private Set set;\n            }\n        ";
            String[] stringArray = new String[]{"public class B extends A { }", a};
            J.CompilationUnit b = (J.CompilationUnit)jp.parse(stringArray).get(0);
            Set set = FindInheritedFields.find((J)((J)b.getClasses().get(0)), (String)"java.util.List");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"find(b.classes[0], \"java.util.List\")");
            stringArray = (String[])CollectionsKt.firstOrNull((Iterable)set);
            Assertions.assertThat((String)(stringArray == null ? null : stringArray.getName())).isEqualTo("list");
            Assertions.assertThat((Iterable)FindInheritedFields.find((J)((J)b.getClasses().get(0)), (String)"java.util.Set")).isEmpty();
        }

        @Test
        public static void findArrayOfType(@NotNull FindInheritedFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String a = "\n            public class A {\n               String[] s;\n            }\n        ";
            String[] stringArray = new String[]{"public class B extends A { }", a};
            J.CompilationUnit b = (J.CompilationUnit)jp.parse(stringArray).get(0);
            Set set = FindInheritedFields.find((J)((J)b.getClasses().get(0)), (String)"java.lang.String");
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"find(b.classes[0], \"java.lang.String\")");
            stringArray = (String[])CollectionsKt.firstOrNull((Iterable)set);
            Assertions.assertThat((String)(stringArray == null ? null : stringArray.getName())).isEqualTo("s");
            Assertions.assertThat((Iterable)FindInheritedFields.find((J)((J)b.getClasses().get(0)), (String)"java.util.Set")).isEmpty();
        }
    }
}

